/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.lang.X4OLanguagePropertyKeys;
import org.x4o.xml.test.TestDriver;

public class X4ODebugWriterTest
extends TestCase {
    private File createDebugFile() throws IOException {
        File debugFile = File.createTempFile("test-debug", ".xml");
        debugFile.deleteOnExit();
        return debugFile;
    }

    public void testDebugOutput() throws Exception {
        File debugFile = this.createDebugFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        reader.setProperty(X4OLanguagePropertyKeys.DEBUG_OUTPUT_STREAM, (Object)new FileOutputStream(debugFile));
        reader.readResource("tests/attributes/test-bean.xml");
        X4ODebugWriterTest.assertTrue((String)"Debug file does not exists.", (boolean)debugFile.exists());
        debugFile.delete();
    }

    public void testDebugOutputFull() throws Exception {
        File debugFile = this.createDebugFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        reader.setProperty(X4OLanguagePropertyKeys.DEBUG_OUTPUT_STREAM, (Object)new FileOutputStream(debugFile));
        reader.readResource("tests/attributes/test-bean.xml");
        X4ODebugWriterTest.assertTrue((String)"Debug file does not exists.", (boolean)debugFile.exists());
        debugFile.delete();
    }
}

