<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   index.php - Main site creation file */

// Load the main headers for ThemeX, which will (in turn) load the configuration for our selected theme
if(!file_exists('westgen/index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your installation may be corrupt.'); }
define("westgen", true);
include("westgen/index.php");

// If the selected file is a folder, redirect to the index page in that folder
if($_SERVER['PATH_INFO'] != '') {
        $selected_file = './content' . $_SERVER['PATH_INFO'];
	// Get selected title
	if(file_exists($selected_file . ".title")) {
		$page_title = stripslashes(file_get_contents($selected_file . ".title")); }
	if(is_dir('./content' . $_SERVER['PATH_INFO'])) {
                header('Location: ' . $wg_public . '/' . $wg_index . $_SERVER['PATH_INFO'] . '/index.php'); }
        } else {
        // The name of the home page
        $page_title = 'Home';
        if(file_exists('./content/index.html')) {
                $selected_file = './content/index.html';
        }
        elseif(file_exists('./content/index.htm')) {
                $selected_file = './content/index.htm';
        } else {
                $selected_file = './content/index.php'; }
        }

// Check if the selected file can even be loaded
if(!file_exists($selected_file)) {
        die('<b>Fatal error:</b> ' . $wg_identify . ' could not find the path to the requested file (<i>' . $selected_file . '</i>).'); }

// Check if the selected file has a valid type
$ext = pathinfo($selected_file);
$ext = $ext['extension'];
if($ext != "html" && $ext != "htm" && $ext != "php") {
        die('<b>Fatal error:</b> ' . $wg_identify . ' does not know how to deal with the file extension (<i>' . $ext . '</i>).'); }

// If page layout is not selected, use our default
if($_GET['page_layout'] != '') {
        $page_layout = $_GET['page_layout'];
} else {
        // The default page layout
        $page_layout = 'standard'; }

// Check to see if we can use the selected layout
if(!is_dir($theme_root . '/' . $page_layout)) {
        die('<b>Fatal error:</b> ' . $wg_identify . ' could not load the selected layout files (<i>' . $page_layout . '</i>)');
} else {
        // Write out the page with selected layout
        include($theme_root . '/' . $page_layout . '/index.php'); }

?>
