/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.Base;
import processing.app.BufferedStyledDocument;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Theme;

public class EditorConsole
extends JScrollPane {
    Editor editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    MutableAttributeSet stdStyle;
    MutableAttributeSet errStyle;
    boolean cerror;
    int maxLineCount;
    static File errFile;
    static File outFile;
    static File tempFolder;
    public static PrintStream systemOut;
    public static PrintStream systemErr;
    static PrintStream consoleOut;
    static PrintStream consoleErr;
    static OutputStream stdoutFile;
    static OutputStream stderrFile;
    static EditorConsole currentConsole;

    public EditorConsole(Editor editor) {
        this.editor = editor;
        this.maxLineCount = Preferences.getInteger("console.length");
        this.consoleDoc = new BufferedStyledDocument(10000, this.maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, simpleAttributeSet, true);
        Color color = Theme.getColor("console.color");
        Color color2 = Theme.getColor("console.output.color");
        Color color3 = Theme.getColor("console.error.color");
        Font font = Theme.getFont("console.font");
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, color2);
        StyleConstants.setBackground(this.stdStyle, color);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, color3);
        StyleConstants.setBackground(this.errStyle, color);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        this.consoleTextPane.setBackground(color);
        this.setViewportView(this.consoleTextPane);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        int n2 = Preferences.getInteger("console.lines");
        int n3 = 6;
        this.setPreferredSize(new Dimension(1024, n * n2 + n3));
        this.setMinimumSize(new Dimension(1024, n * 4 + n3));
        if (systemOut == null) {
            systemOut = System.out;
            systemErr = System.err;
            tempFolder = Base.createTempFolder("console");
            try {
                String string;
                String string2 = Preferences.get("console.output.file");
                if (string2 != null) {
                    outFile = new File(tempFolder, string2);
                    stdoutFile = new FileOutputStream(outFile);
                }
                if ((string = Preferences.get("console.error.file")) != null) {
                    errFile = new File(tempFolder, string);
                    stderrFile = new FileOutputStream(errFile);
                }
            }
            catch (IOException iOException) {
                Base.showWarning("Console Error", "A problem occurred while trying to open the\nfiles used to store the console output.", iOException);
            }
            consoleOut = new PrintStream(new EditorConsoleStream(false));
            consoleErr = new PrintStream(new EditorConsoleStream(true));
            if (Preferences.getBoolean("console")) {
                try {
                    System.setOut(consoleOut);
                    System.setErr(consoleErr);
                }
                catch (Exception exception) {
                    exception.printStackTrace(systemOut);
                }
            }
        }
        if (Base.isMacOS()) {
            this.setBorder(null);
        }
        new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EditorConsole.this.consoleDoc.hasAppendage) {
                    EditorConsole.this.consoleDoc.insertAll();
                    EditorConsole.this.consoleTextPane.setCaretPosition(EditorConsole.this.consoleDoc.getLength());
                }
            }
        }).start();
    }

    public static void setEditor(Editor editor) {
        currentConsole = editor.console;
    }

    public void handleQuit() {
        System.setOut(systemOut);
        System.setErr(systemErr);
        consoleOut.close();
        consoleErr.close();
        try {
            stdoutFile.close();
            stderrFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(systemOut);
        }
        outFile.delete();
        errFile.delete();
        tempFolder.delete();
    }

    public void write(byte[] byArray, int n, int n2, boolean bl) {
        if (bl != this.cerror) {
            this.message("", this.cerror, true);
        }
        this.message(new String(byArray, n, n2), bl, false);
        this.cerror = bl;
    }

    public synchronized void message(String string, boolean bl, boolean bl2) {
        if (bl) {
            systemErr.print(string);
        } else {
            systemOut.print(string);
        }
        if (bl2) {
            this.appendText("\n", bl);
            if (bl) {
                systemErr.println();
            } else {
                systemOut.println();
            }
        }
        this.appendText(string, bl);
    }

    private synchronized void appendText(String string, boolean bl) {
        this.consoleDoc.appendString(string, bl ? this.errStyle : this.stdStyle);
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    class EditorConsoleStream
    extends OutputStream {
        boolean err;
        byte[] single = new byte[1];

        public EditorConsoleStream(boolean bl) {
            this.err = bl;
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] byArray) {
            OutputStream outputStream;
            currentConsole.write(byArray, 0, byArray.length, this.err);
            OutputStream outputStream2 = outputStream = this.err ? stderrFile : stdoutFile;
            if (outputStream != null) {
                try {
                    outputStream.write(byArray);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    outputStream = null;
                }
            }
        }

        public void write(byte[] byArray, int n, int n2) {
            OutputStream outputStream;
            currentConsole.write(byArray, n, n2, this.err);
            OutputStream outputStream2 = outputStream = this.err ? stderrFile : stdoutFile;
            if (outputStream != null) {
                try {
                    outputStream.write(byArray, n, n2);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    outputStream = null;
                }
            }
        }

        public void write(int n) {
            OutputStream outputStream;
            this.single[0] = (byte)n;
            currentConsole.write(this.single, 0, 1, this.err);
            OutputStream outputStream2 = outputStream = this.err ? stderrFile : stdoutFile;
            if (outputStream != null) {
                try {
                    outputStream.write(n);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    outputStream = null;
                }
            }
        }
    }
}

