/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.SketchCode;
import processing.app.debug.AvrdudeUploader;
import processing.app.debug.Compiler;
import processing.app.debug.RunnerException;
import processing.app.debug.Sizer;
import processing.app.debug.Uploader;
import processing.app.preproc.PdePreprocessor;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sketch {
    private static File tempBuildFolder;
    private Editor editor;
    private File primaryFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    private String appletClassName;
    private String classPath;
    private String libraryPath;
    private ArrayList<File> importedLibraries;
    boolean renamingCode;

    public Sketch(Editor editor, String string) throws IOException {
        this.editor = editor;
        this.primaryFile = new File(string);
        String string2 = this.primaryFile.getName();
        int n = this.getDefaultExtension().length() + 1;
        this.name = string2.substring(0, string2.length() - n);
        tempBuildFolder = Base.getBuildFolder();
        this.folder = new File(new File(string).getParent());
        this.load();
    }

    protected void load() {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] stringArray = this.folder.list();
        this.codeCount = 0;
        this.code = new SketchCode[stringArray.length];
        String[] stringArray2 = this.getExtensions();
        for (String string : stringArray) {
            if (string.startsWith(".") || new File(this.folder, string).isDirectory()) continue;
            String string2 = string;
            for (String string3 : stringArray2) {
                if (!string2.toLowerCase().endsWith("." + string3) || !Sketch.isSanitaryName(string2 = string2.substring(0, string2.length() - (string3.length() + 1)))) continue;
                this.code[this.codeCount++] = new SketchCode(new File(this.folder, string), string3);
            }
        }
        this.code = (SketchCode[])PApplet.subset((Object)this.code, (int)0, (int)this.codeCount);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!this.code[i].getFile().equals(this.primaryFile)) continue;
            SketchCode sketchCode = this.code[0];
            this.code[0] = this.code[i];
            this.code[i] = sketchCode;
            break;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    protected void replaceCode(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].getFileName().equals(sketchCode.getFileName())) continue;
            this.code[i] = sketchCode;
            break;
        }
    }

    protected void insertCode(SketchCode sketchCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)sketchCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        for (int i = 1; i < this.codeCount; ++i) {
            int n = i;
            for (int j = i + 1; j < this.codeCount; ++j) {
                if (this.code[j].getFileName().compareTo(this.code[n].getFileName()) >= 0) continue;
                n = j;
            }
            if (n == i) continue;
            SketchCode sketchCode = this.code[n];
            this.code[n] = this.code[i];
            this.code[i] = sketchCode;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit("Name for new file:", "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.editor.untitled) {
            Base.showMessage("Sketch is Untitled", "How about saving the sketch first \nbefore trying to rename it?");
            return;
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        this.renamingCode = true;
        String string = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String string2 = this.current.isExtension("pde") ? this.current.getPrettyName() : this.current.getFileName();
        this.editor.status.edit(string, string2);
    }

    protected void nameCode(String string) {
        String string2;
        this.ensureExistence();
        if (string.indexOf(46) == -1) {
            string = string + "." + this.getDefaultExtension();
        }
        if (this.renamingCode && string.equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if ((string = string.trim()).equals("")) {
            return;
        }
        int n = string.indexOf(46);
        if (n == 0) {
            Base.showWarning("Problem with rename", "The name cannot start with a period.", null);
            return;
        }
        String string3 = string.substring(n + 1).toLowerCase();
        if (!this.validExtension(string3)) {
            Base.showWarning("Problem with rename", "\"." + string3 + "\"" + "is not a valid extension.", null);
            return;
        }
        if (!this.isDefaultExtension(string3) && this.renamingCode && this.current == this.code[0]) {
            Base.showWarning("Problem with rename", "The main file can't use an extension.\n(It may be time for your to graduate to a\n\"real\" programming environment)", null);
            return;
        }
        String string4 = string.substring(0, n);
        if (!string4.equals(string2 = Sketch.sanitizeName(string4))) {
            string = string2 + "." + string3;
        }
        for (SketchCode sketchCode : this.code) {
            if (!string.equalsIgnoreCase(sketchCode.getFileName())) continue;
            Base.showMessage("Nope", "A file named \"" + sketchCode.getFileName() + "\" already exists\n" + "in \"" + this.folder.getAbsolutePath() + "\"");
            return;
        }
        if (string.equals(this.getName() + ".cpp")) {
            Base.showMessage("Nope", "You can't have a .cpp file with the same name as the sketch.");
            return;
        }
        if (this.currentIndex == 0) {
            for (int i = 1; i < this.codeCount; ++i) {
                if (!string2.equalsIgnoreCase(this.code[i].getPrettyName()) || !this.code[i].getExtension().equalsIgnoreCase("cpp")) continue;
                Base.showMessage("Nope", "You can't rename the sketch to \"" + string2 + "\"\n" + "because the sketch already has a .cpp file with that name.");
                return;
            }
        }
        File file = new File(this.folder, string);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                int n2;
                String string5 = string.substring(0, string.indexOf(46));
                File file2 = new File(this.folder.getParentFile(), string5);
                if (file2.exists()) {
                    Base.showWarning("Cannot Rename", "Sorry, a sketch (or folder) named \"" + string + "\" already exists.", null);
                    return;
                }
                if (this.current.isModified()) {
                    this.current.setProgram(this.editor.getText());
                    try {
                        this.current.save();
                    }
                    catch (Exception exception) {
                        Base.showWarning("Error", "Could not rename the sketch. (0)", exception);
                        return;
                    }
                }
                if (!this.current.renameTo(file, string3)) {
                    Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + file.getName() + "\"", null);
                    return;
                }
                try {
                    for (n2 = 1; n2 < this.codeCount; ++n2) {
                        this.code[n2].save();
                    }
                }
                catch (Exception exception) {
                    Base.showWarning("Error", "Could not rename the sketch. (1)", exception);
                    return;
                }
                n2 = this.folder.renameTo(file2) ? 1 : 0;
                if (n2 == 0) {
                    Base.showWarning("Error", "Could not rename the sketch. (2)", null);
                    return;
                }
                File file3 = new File(file2, string + ".pde");
                String string6 = file3.getAbsolutePath();
                this.editor.handleOpenUnchecked(string6, this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
                this.editor.base.rebuildSketchbookMenus();
            } else if (!this.current.renameTo(file, string3)) {
                Base.showWarning("Error", "Could not rename \"" + this.current.getFileName() + "\" to \"" + file.getName() + "\"", null);
                return;
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException iOException) {
                Base.showWarning("Error", "Could not create the file \"" + file + "\"\n" + "in \"" + this.folder.getAbsolutePath() + "\"", iOException);
                return;
            }
            SketchCode sketchCode = new SketchCode(file, string3);
            this.insertCode(sketchCode);
        }
        this.sortCode();
        this.setCurrentCode(string);
        this.editor.header.rebuild();
    }

    public void handleDeleteCode() {
        Object[] objectArray;
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = this.currentIndex == 0 ? "Are you sure you want to delete this sketch?" : "Are you sure you want to delete \"" + this.current.getPrettyName() + "\"?";
        int n = JOptionPane.showOptionDialog(this.editor, string, "Delete", 0, 3, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0]);
        if (n == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.folder);
                this.editor.base.handleClose(this.editor);
            } else {
                if (!this.current.deleteFile()) {
                    Base.showMessage("Couldn't do it", "Could not delete \"" + this.current.getFileName() + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.setCurrentCode(0);
                this.editor.header.repaint();
            }
        }
    }

    protected void removeCode(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (this.code[i] != sketchCode) continue;
            for (int j = i; j < this.codeCount - 1; ++j) {
                this.code[j] = this.code[j + 1];
            }
            --this.codeCount;
            this.code = (SketchCode[])PApplet.shorten((Object)this.code);
            return;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public void handlePrevCode() {
        int n = this.currentIndex - 1;
        if (n < 0) {
            n = this.codeCount - 1;
        }
        this.setCurrentCode(n);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean bl) {
        this.current.setModified(bl);
        this.calcModified();
    }

    protected void calcModified() {
        this.modified = false;
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.header.repaint();
        if (Base.isMacOS()) {
            Boolean bl = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("windowModified", bl);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is read-only", "Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location.");
            if (!this.saveAs()) {
                return false;
            }
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified()) continue;
            this.code[i].save();
        }
        this.calcModified();
        return true;
    }

    protected boolean saveAs() throws IOException {
        File file;
        Object object;
        String string = null;
        String string2 = null;
        FileDialog fileDialog = new FileDialog((Frame)this.editor, "Save sketch folder as...", 1);
        if (this.isReadOnly() || this.isUntitled()) {
            fileDialog.setDirectory(Preferences.get("sketchbook.path"));
        } else {
            fileDialog.setDirectory(this.folder.getParent());
        }
        String string3 = this.folder.getName();
        fileDialog.setFile(string3);
        fileDialog.setVisible(true);
        string = fileDialog.getDirectory();
        string2 = fileDialog.getFile();
        if (string2 == null) {
            return false;
        }
        string2 = Sketch.checkName(string2);
        File file2 = new File(string, string2);
        for (int i = 1; i < this.codeCount; ++i) {
            if (!string2.equalsIgnoreCase(this.code[i].getPrettyName()) || !this.code[i].getExtension().equalsIgnoreCase("cpp")) continue;
            Base.showMessage("Nope", "You can't save the sketch as \"" + string2 + "\"\n" + "because the sketch already has a .cpp file with that name.");
            return false;
        }
        if (file2.equals(this.folder)) {
            return this.save();
        }
        try {
            String string4 = file2.getCanonicalPath() + File.separator;
            object = this.folder.getCanonicalPath() + File.separator;
            if (string4.indexOf((String)object) == 0) {
                Base.showWarning("How very Borges of you", "You cannot save the sketch into a folder\ninside itself. This would go on forever.", null);
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file2.exists()) {
            Base.removeDir(file2);
        }
        file2.mkdirs();
        if (this.current.isModified()) {
            this.current.setProgram(this.editor.getText());
        }
        for (int i = 1; i < this.codeCount; ++i) {
            object = new File(file2, this.code[i].getFileName());
            this.code[i].saveAs((File)object);
        }
        if (this.dataFolder.exists()) {
            File file3 = new File(file2, "data");
            Base.copyDir(this.dataFolder, file3);
        }
        if (this.codeFolder.exists()) {
            File file4 = new File(file2, "code");
            Base.copyDir(this.codeFolder, file4);
        }
        if ((file = new File(this.folder, "applet.html")).exists()) {
            object = new File(file2, "applet.html");
            Base.copyFile(file, (File)object);
        }
        object = new File(file2, string2 + ".pde");
        this.code[0].saveAs((File)object);
        this.editor.handleOpenUnchecked(((File)object).getPath(), this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        this.editor.base.rebuildSketchbookMenus();
        this.setUntitled(false);
        return true;
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage("Sketch is Read-Only", "Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again.");
            return;
        }
        String string = "Select an image or other data file to copy to your sketch";
        FileDialog fileDialog = new FileDialog((Frame)this.editor, string, 0);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null) {
            return;
        }
        File file = new File(string2, string3);
        boolean bl = this.addFile(file);
        if (bl) {
            this.editor.statusNotice("One file added to the sketch.");
        }
    }

    public boolean addFile(File file) {
        boolean bl;
        String string = file.getName();
        File file2 = null;
        String string2 = null;
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(".o") || string.toLowerCase().endsWith(".a") || string.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            file2 = new File(this.codeFolder, string);
        } else {
            for (String string3 : this.getExtensions()) {
                String string4 = string.toLowerCase();
                if (!string4.endsWith("." + string3)) continue;
                file2 = new File(this.folder, string);
                string2 = string3;
            }
            if (string2 == null) {
                this.prepareDataFolder();
                file2 = new File(this.dataFolder, string);
            }
        }
        if (file2.exists()) {
            Object[] objectArray = new Object[]{"OK", "Cancel"};
            String string5 = "Replace the existing version of " + string + "?";
            int n = JOptionPane.showOptionDialog(this.editor, string5, "Replace", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                bl2 = true;
            } else {
                return false;
            }
        }
        if (bl2 && !(bl = file2.delete())) {
            Base.showWarning("Error adding file", "Could not delete the existing '" + string + "' file.", null);
            return false;
        }
        if (string2 == null && file.equals(file2)) {
            Base.showWarning("You can't fool me", "This file has already been copied to the\nlocation from which where you're trying to add it.\nI ain't not doin nuthin'.", null);
            return false;
        }
        if (!file.equals(file2)) {
            try {
                Base.copyFile(file, file2);
            }
            catch (IOException iOException) {
                Base.showWarning("Error adding file", "Could not add '" + string + "' to the sketch.", iOException);
                return false;
            }
        }
        if (string2 != null) {
            SketchCode sketchCode = new SketchCode(file2, string2);
            if (bl2) {
                this.replaceCode(sketchCode);
            } else {
                this.insertCode(sketchCode);
                this.sortCode();
            }
            this.setCurrentCode(string);
            this.editor.header.repaint();
            if (this.editor.untitled) {
                this.current.setModified(true);
            }
        } else if (this.editor.untitled) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void importLibrary(String string) {
        this.ensureExistence();
        String[] stringArray = Compiler.headerListFromIncludePath(string);
        if (this.hasDefaultExtension(this.current)) {
            this.setCurrentCode(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("#include <");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(">\n");
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.editor.getText());
        this.editor.setText(stringBuffer.toString());
        this.editor.setSelection(0, 0);
        this.setModified(true);
    }

    public void setCurrentCode(int n) {
        if (this.currentIndex == n && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[n];
        this.currentIndex = n;
        this.editor.setCode(this.current);
        this.editor.header.rebuild();
    }

    protected void setCurrentCode(String string) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (!string.equals(this.code[i].getFileName()) && !string.equals(this.code[i].getPrettyName())) continue;
            this.setCurrentCode(i);
            return;
        }
    }

    protected void cleanup() {
        System.gc();
        Base.removeDescendants(tempBuildFolder);
    }

    protected String compile(boolean bl) throws RunnerException {
        this.ensureExistence();
        this.current.setProgram(this.editor.getText());
        if (Preferences.getBoolean("editor.external")) {
            this.current = null;
            this.load();
        }
        this.cleanup();
        String string = this.build(tempBuildFolder.getAbsolutePath(), bl);
        this.size(tempBuildFolder.getAbsolutePath(), string);
        return string;
    }

    public String preprocess(String string) throws RunnerException {
        return this.preprocess(string, new PdePreprocessor());
    }

    public String preprocess(String string, PdePreprocessor pdePreprocessor) throws RunnerException {
        this.ensureExistence();
        String[] stringArray = null;
        this.classPath = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (SketchCode object : this.code) {
            if (!object.isExtension("pde")) continue;
            object.setPreprocOffset(n);
            stringBuffer.append(object.getProgram());
            stringBuffer.append('\n');
            n += object.getLineCount();
        }
        int n2 = 0;
        try {
            n2 = pdePreprocessor.writePrefix(stringBuffer.toString(), string, this.name, stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string2 = "Build folder disappeared or could not be written";
            throw new RunnerException(string2);
        }
        String string3 = null;
        try {
            SketchCode[] sketchCodeArray = pdePreprocessor.write();
            if (sketchCodeArray == null) {
                throw new RunnerException("Could not find main class");
            }
            string3 = (String)sketchCodeArray + ".cpp";
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string2 = "Build folder disappeared or could not be written";
            throw new RunnerException(string2);
        }
        catch (RunnerException runnerException) {
            throw runnerException;
        }
        catch (Exception exception) {
            System.err.println("Uncaught exception type:" + exception.getClass());
            exception.printStackTrace();
            throw new RunnerException(exception.toString());
        }
        this.importedLibraries = new ArrayList();
        for (String string4 : pdePreprocessor.getExtraImports()) {
            File file = Base.importToLibraryTable.get(string4);
            if (file == null || this.importedLibraries.contains(file)) continue;
            this.importedLibraries.add(file);
            this.classPath = this.classPath + Compiler.contentsToClassPath(file);
            this.libraryPath = this.libraryPath + File.pathSeparator + file.getAbsolutePath();
        }
        for (SketchCode sketchCode : this.code) {
            if (sketchCode.isExtension("c") || sketchCode.isExtension("cpp") || sketchCode.isExtension("h")) {
                String string5 = sketchCode.getFileName();
                try {
                    Base.saveFile(sketchCode.getProgram(), new File(string, string5));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RunnerException("Problem moving " + string5 + " to the build folder");
                }
            }
            if (!sketchCode.isExtension("pde")) continue;
            sketchCode.addPreprocOffset(n2);
        }
        return string3;
    }

    public String build(String string, boolean bl) throws RunnerException {
        Compiler compiler = new Compiler();
        String string2 = this.preprocess(string);
        if (compiler.compile(this, string, string2, bl)) {
            return string2;
        }
        return null;
    }

    protected boolean exportApplet(boolean bl) throws Exception {
        return this.exportApplet(tempBuildFolder.getAbsolutePath(), bl);
    }

    public boolean exportApplet(String string, boolean bl) throws RunnerException, IOException {
        this.ensureExistence();
        this.current.setProgram(this.editor.getText());
        if (Preferences.getBoolean("editor.external")) {
            this.current = null;
            this.load();
        }
        File file = new File(string);
        if (Preferences.getBoolean("export.delete_target_folder")) {
            Base.removeDir(file);
        }
        file.mkdirs();
        String string2 = this.build(file.getPath(), false);
        if (string2 == null) {
            return false;
        }
        this.size(file.getPath(), string2);
        this.upload(file.getPath(), string2, bl);
        return true;
    }

    protected void size(String string, String string2) throws RunnerException {
        long l = 0L;
        long l2 = Integer.parseInt(Base.getBoardPreferences().get("upload.maximum_size"));
        Sizer sizer = new Sizer(string, string2);
        try {
            l = sizer.computeSize();
            System.out.println("Binary sketch size: " + l + " bytes (of a " + l2 + " byte maximum)");
        }
        catch (RunnerException runnerException) {
            System.err.println("Couldn't determine program size: " + runnerException.getMessage());
        }
        if (l > l2) {
            throw new RunnerException("Sketch too big; see http://www.arduino.cc/en/Guide/Troubleshooting#size for tips on reducing it.");
        }
    }

    protected String upload(String string, String string2, boolean bl) throws RunnerException {
        AvrdudeUploader avrdudeUploader = new AvrdudeUploader();
        boolean bl2 = ((Uploader)avrdudeUploader).uploadUsingPreferences(string, string2, bl);
        return bl2 ? string2 : null;
    }

    public static String scrubComments(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '/') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                while (n < cArray.length && cArray[n] != '\n') {
                    cArray[n++] = 32;
                }
                continue;
            }
            if (cArray[n] == '/' && n < cArray.length - 1 && cArray[n + 1] == '*') {
                cArray[n++] = 32;
                cArray[n++] = 32;
                boolean bl = false;
                while (n < cArray.length - 1) {
                    if (cArray[n] == '*' && cArray[n + 1] == '/') {
                        cArray[n++] = 32;
                        cArray[n++] = 32;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                throw new RuntimeException("Missing the */ from the end of a /* comment */");
            }
            ++n;
        }
        return new String(cArray);
    }

    public boolean exportApplicationPrompt() throws IOException, RunnerException {
        return false;
    }

    protected boolean exportApplication() throws IOException, RunnerException {
        return false;
    }

    public boolean exportApplication(String string, int n) throws IOException, RunnerException {
        return false;
    }

    protected void addManifest(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipOutputStream.putNextEntry(zipEntry);
        String string = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.VERSION_NAME + "\n" + "Main-Class: " + this.name + "\n";
        zipOutputStream.write(string.getBytes());
        zipOutputStream.closeEntry();
    }

    protected HashMap<String, String> readSettings(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!file.exists()) {
            return hashMap;
        }
        String[] stringArray = PApplet.loadStrings((File)file);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n = stringArray[i].indexOf(35);
            String string2 = string = n == -1 ? stringArray[i].trim() : stringArray[i].substring(0, n).trim();
            if (string.length() == 0) continue;
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                System.err.println("ignoring illegal line in " + file);
                System.err.println("  " + string);
                continue;
            }
            String string3 = string.substring(0, n2).trim();
            String string4 = string.substring(n2 + 1).trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    protected void packClassPathIntoZipFile(String string, ZipOutputStream zipOutputStream, HashMap<String, Object> hashMap) throws IOException {
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].length() == 0) continue;
            if (stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip")) {
                try {
                    object = new ZipFile(stringArray[i]);
                    Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
                    while (enumeration.hasMoreElements()) {
                        int n;
                        String string2;
                        ZipEntry zipEntry = enumeration.nextElement();
                        if (zipEntry.isDirectory() || (string2 = zipEntry.getName()).indexOf("META-INF") == 0 || hashMap.get(string2) != null) continue;
                        hashMap.put(string2, new Object());
                        ZipEntry zipEntry2 = new ZipEntry(string2);
                        zipOutputStream.putNextEntry(zipEntry2);
                        byte[] byArray = new byte[(int)zipEntry.getSize()];
                        InputStream inputStream = ((ZipFile)object).getInputStream(zipEntry);
                        int n2 = 0;
                        for (int j = byArray.length; j > 0; j -= n) {
                            n = inputStream.read(byArray, n2, j);
                            n2 += n;
                        }
                        zipOutputStream.write(byArray);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                    }
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Error in file " + stringArray[i]);
                    iOException.printStackTrace();
                    continue;
                }
            }
            object = new File(stringArray[i]);
            if (!((File)object).exists()) continue;
            Sketch.packClassPathIntoZipFileRecursive((File)object, null, zipOutputStream);
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (stringArray[i].charAt(0) == '.') continue;
            File file2 = new File(file, stringArray[i]);
            String string3 = string2 = string == null ? stringArray[i] : string + "/" + stringArray[i];
            if (file2.isDirectory()) {
                Sketch.packClassPathIntoZipFileRecursive(file2, string2, zipOutputStream);
                continue;
            }
            if (stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip") || stringArray[i].charAt(0) == '.') continue;
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(Base.loadBytesRaw(file2));
            zipOutputStream.closeEntry();
        }
    }

    protected void ensureExistence() {
        if (this.folder.exists()) {
            return;
        }
        Base.showWarning("Sketch Disappeared", "The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost.", null);
        try {
            this.folder.mkdirs();
            this.modified = true;
            for (int i = 0; i < this.codeCount; ++i) {
                this.code[i].save();
            }
            this.calcModified();
        }
        catch (Exception exception) {
            Base.showWarning("Could not re-save sketch", "Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor.", exception);
        }
    }

    public boolean isReadOnly() {
        String string = this.folder.getAbsolutePath();
        if (string.startsWith(Base.getExamplesPath()) || string.startsWith(Base.getLibrariesPath()) || string.startsWith(Base.getSketchbookLibrariesPath())) {
            return true;
        }
        for (int i = 0; i < this.codeCount; ++i) {
            if (!this.code[i].isModified() || !this.code[i].fileReadOnly() || !this.code[i].fileExists()) continue;
            return true;
        }
        return false;
    }

    public boolean hideExtension(String string) {
        return string.equals(this.getDefaultExtension());
    }

    public boolean hasDefaultExtension(SketchCode sketchCode) {
        return sketchCode.getExtension().equals(this.getDefaultExtension());
    }

    public boolean isDefaultExtension(String string) {
        return string.equals(this.getDefaultExtension());
    }

    public boolean validExtension(String string) {
        String[] stringArray = this.getExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "c", "cpp", "h"};
    }

    public String getName() {
        return this.name;
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public File prepareCodeFolder() {
        if (!this.codeFolder.exists()) {
            this.codeFolder.mkdirs();
        }
        return this.codeFolder;
    }

    public ArrayList<File> getImportedLibraries() {
        return this.importedLibraries;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int n) {
        return this.code[n];
    }

    public int getCodeIndex(SketchCode sketchCode) {
        for (int i = 0; i < this.codeCount; ++i) {
            if (sketchCode != this.code[i]) continue;
            return i;
        }
        return -1;
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public void setUntitled(boolean bl) {
        this.editor.untitled = bl;
    }

    public boolean isUntitled() {
        return this.editor.untitled;
    }

    public String getAppletClassName2() {
        return this.appletClassName;
    }

    public static String checkName(String string) {
        String string2 = Sketch.sanitizeName(string);
        if (!string2.equals(string)) {
            String string3 = "The sketch name had to be modified. Sketch names can only consist\nof ASCII characters and numbers (but cannot start with a number).\nThey should also be less less than 64 characters long.";
            System.out.println(string3);
        }
        return string2;
    }

    public static boolean isSanitaryName(String string) {
        return Sketch.sanitizeName(string).equals(string);
    }

    public static String sanitizeName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray[0] >= '0' && cArray[0] <= '9') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= 'A' && cArray[i] <= 'Z') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append('_');
        }
        if (stringBuffer.length() > 63) {
            stringBuffer.setLength(63);
        }
        return stringBuffer.toString();
    }
}

