/*
 * Created on 3 nov. 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package tsp.core.consumer;

import tsp.core.rpc.TSP_status_t;


/**
 * 
 */
public class TspConsumerException extends Exception {

	protected int status;

	
	/**
	 * 
	 */
	public TspConsumerException() {
		super();
		status = TSP_status_t.TSP_STATUS_OK;
		// TODO Auto-generated constructor stub
	}
	
	public TspConsumerException(int status) {
		super();
		this.status = status; 
	}

	/**
	 * 
	 */
	public TspConsumerException(String message) {
		super(message);
		// TODO Auto-generated constructor stub
	}
	
	public TspConsumerException(int status, String message) {
		super(message);
		this.status = status; 
	}

	/**
	 * 
	 */
	public TspConsumerException(String message, Throwable cause) {
		super(message, cause);
		// TODO Auto-generated constructor stub
	}

	/**
	 * 
	 */
	public TspConsumerException(Throwable cause) {
		super(cause);
		// TODO Auto-generated constructor stub
	}
	
	public int getStatus() {
		return this.status;
	}
	
	public static String getStatusString(int status) {
		
		String statusString = null;
		
		switch(status){
		case(TSP_status_t.TSP_STATUS_OK):
			
			statusString = new String("OK");
			break;
			
		case(TSP_status_t.TSP_STATUS_NOK):
			statusString = new String("NOK");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_PROVIDER_UNREACHABLE):
			statusString = new String("TSP_STATUS_ERROR_PROVIDER_UNREACHABLE");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_UNKNOWN):
			statusString = new String("TSP_STATUS_ERROR_UNKNOWN");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_SEE_STRING):
			statusString = new String("TSP_STATUS_ERROR_SEE_STRING");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_VERSION):
			statusString = new String("TSP_STATUS_ERROR_VERSION");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_SYMBOLS):
			statusString = new String("TSP_STATUS_ERROR_SYMBOLS");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_SYMBOL_FILTER):
			statusString = new String("TSP_STATUS_ERROR_SYMBOL_FILTER");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_NOT_SUPPORTED):
			statusString = new String("TSP_STATUS_ERROR_NOT_SUPPORTED");
			break;
			
		case(TSP_status_t.TSP_STATUS_ERROR_NOT_IMPLEMENTED):
			statusString = new String("TSP_STATUS_ERROR_NOT_IMPLEMENTED");
			break;

		case(TSP_status_t.TSP_STATUS_ERROR_PGI_UNKNOWN):
			statusString = new String("TSP_STATUS_ERROR_PGI_UNKNOWN");
			break;
		
		case(TSP_status_t.TSP_STATUS_ERROR_ASYNC_READ_NOT_ALLOWED):
			statusString = new String("TSP_STATUS_ERROR_ASYNC_READ_NOT_ALLOWED");
			break;
		
		case(TSP_status_t.TSP_STATUS_ERROR_ASYNC_WRITE_NOT_ALLOWED):
			statusString = new String("TSP_STATUS_ERROR_ASYNC_WRITE_NOT_ALLOWED");
			break;
		
		case(TSP_status_t.TSP_STATUS_ERROR_ASYNC_READ_NOT_SUPPORTED):
			statusString = new String("TSP_STATUS_ERROR_ASYNC_READ_NOT_SUPPORTED");
			break;
		
		case(TSP_status_t.TSP_STATUS_ERROR_ASYNC_WRITE_NOT_SUPPORTED):
			statusString = new String("TSP_STATUS_ERROR_ASYNC_WRITE_NOT_SUPPORTED");
			break;
		
		case(TSP_status_t.TSP_STATUS_ERROR_MEMORY_ALLOCATION):
			statusString = new String("TSP_STATUS_ERROR_MEMORY_ALLOCATION");
			break;
		
		default:
			statusString = new String("UNKNOWN");
			break;
		}
			
		return statusString;
	}
	  
}
