/* $Id: TspAnswerExtendedInfo.java,v 1.2 2006/06/04 16:39:42 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.common;

import java.util.Hashtable;

import tsp.core.rpc.TSP_answer_extended_information_t;
import tsp.core.rpc.TSP_extended_info_list_t;
import tsp.core.rpc.TSP_sample_symbol_extended_info_t;

public class TspAnswerExtendedInfo  extends TspAnswer {

    public TSP_answer_extended_information_t theAnswer;
    public Hashtable pgiHash;



    /*public TspAnswerExtendedInfo(TSP_answer_extended_information_t answer) {
	   theAnswer = answer;
    }
    
       public TSP_extended_info_list_t getInfoByPGI(int pgi) {
    	TSP_extended_info_list_t info = new TSP_extended_info_list_t();
    	for(int i =0;i<theAnswer.extsymbols.value.length;i++)
    		if (pgi == theAnswer.extsymbols.value[i].provider_global_index)
    			info = theAnswer.extsymbols.value[i].info;
    	
    	return info;
    } */
	   
	   public TspAnswerExtendedInfo(TSP_answer_extended_information_t answer) {
		   theAnswer = answer;

	       pgiHash = new Hashtable();
	       
	       for (int i=0;i<answer.extsymbols.value.length;++i) {
	           pgiHash.put(new Integer(answer.extsymbols.value[i].provider_global_index),
	                       answer.extsymbols.value[i]);
	       }
	    }
 
	   public int getTspStatus() {	
			return theAnswer.status;
		}


		public int getTspVersion() {
			return theAnswer.version_id;
		}
    
    public TSP_extended_info_list_t getInfoByPGI(int pgi)  throws TspException {
    	
    	TSP_extended_info_list_t retval;
        retval = ((TSP_sample_symbol_extended_info_t) pgiHash.get(new Integer(pgi))).info;
        if (null==retval) {
            throw new TspException("Invalid PGI  <"+pgi+">");
        }
        return retval;
     }
    

}


