/* $Id: RenamedSimpleSampleSymbolInfo.java,v 1.3 2005/04/15 03:59:45 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.configuration.decorator;

import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;

public class RenamedSimpleSampleSymbolInfo {
	
	private TspSimpleSampleSymbolInfo info;
	private String renamed;
	
	
	/**
	 * @param info
	 * @param renamed
	 */
	public RenamedSimpleSampleSymbolInfo(TspSimpleSampleSymbolInfo info,
			String renamed) {
		super();
		this.info = info;
		this.renamed = renamed;
	}
	
	
	
	/**
	 * @return Returns the info.
	 */
	public TspSimpleSampleSymbolInfo getInfo() {
		return info;
	}
	/**
	 * @return Returns the renamed.
	 */
	public String getRenamed() {
		return renamed;
	}
	
	
	public static TspSimpleSampleSymbolInfo[] toSimpleSampleSymbolInfoArray(RenamedSimpleSampleSymbolInfo[] renInfos){
		TspSimpleSampleSymbolInfo[] infos = new TspSimpleSampleSymbolInfo[renInfos.length];
		for(int i = 0 ; i < infos.length ; i++ ){			
			infos[i] = renInfos[i].getInfo() ;				
		}
		return infos;
	}
	
	
}
