/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import simtools.ui.DesktopCardPanel;
import simtools.ui.DesktopCardPanelMode;

public class DesktopMode
implements DesktopCardPanelMode {
    private static final int DEFAULT_HEIGHT = 200;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 40;
    private int _frameX;
    private int _frameY;
    private int _frameMaxWidth;
    private int _frameMaxHeight;
    private JDesktopPane _framesPane = new JDesktopPane();
    protected FramesListener _framesListener = new FramesListener();
    protected DesktopCardPanel _desktopCardPanel;

    protected DesktopMode(DesktopCardPanel desktopCardPanel) {
        this._desktopCardPanel = desktopCardPanel;
    }

    public void addComponent(JComponent jComponent) {
        if (this._framesPane.getComponentCount() == 0) {
            this.initDesktop();
        }
        ComponentFrame componentFrame = new ComponentFrame(jComponent, this._desktopCardPanel.is_scrollable(), this._desktopCardPanel.is_closable());
        if (this._framesListener != null) {
            componentFrame.addPropertyChangeListener(this._framesListener);
            componentFrame.addInternalFrameListener(this._framesListener);
        }
        this._framesPane.add(componentFrame);
        componentFrame.reshape(this._frameX, this._frameY, this._frameMaxWidth, 200);
        this.computeNextFramePosition();
        try {
            componentFrame.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void removeComponent(JComponent jComponent) {
        ComponentFrame componentFrame = (ComponentFrame)this.getContainer(jComponent);
        if (componentFrame != null) {
            this._framesPane.remove(componentFrame);
            return;
        }
    }

    public Container getContentPane() {
        return this._framesPane;
    }

    public void selectComponent(JComponent jComponent) {
        ComponentFrame componentFrame = (ComponentFrame)this.getContainer(jComponent);
        if (componentFrame != null) {
            try {
                componentFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void updateComponentName(JComponent jComponent) {
        ComponentFrame componentFrame = (ComponentFrame)this.getContainer(jComponent);
        if (componentFrame != null) {
            componentFrame.setTitle(jComponent.getName());
        }
    }

    public Container getContainer(JComponent jComponent) {
        JInternalFrame[] jInternalFrameArray = this._framesPane.getAllFrames();
        if (jInternalFrameArray == null) {
            return null;
        }
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            ComponentFrame componentFrame = (ComponentFrame)jInternalFrameArray[i];
            if (componentFrame.getComponent() != jComponent) continue;
            return componentFrame;
        }
        return null;
    }

    protected void computeNextFramePosition() {
        this._frameX += 40;
        this._frameY += 40;
        if (this._frameY + 200 >= this._frameMaxHeight) {
            this._frameY = 0;
        }
        if (this._frameX >= this._frameMaxWidth) {
            this._frameX = 0;
        }
    }

    private void initDesktop() {
        this._frameX = 0;
        this._frameY = 0;
        Dimension dimension = this._framesPane.getSize();
        this._frameMaxWidth = dimension.width < 40 ? 40 : dimension.width;
        this._frameMaxHeight = dimension.height < 40 ? 40 : dimension.height;
    }

    public class FramesListener
    extends InternalFrameAdapter
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl;
            ComponentFrame componentFrame = (ComponentFrame)propertyChangeEvent.getSource();
            JComponent jComponent = componentFrame.getComponent();
            if (propertyChangeEvent.getPropertyName().equals("maximum") && (bl = (Boolean)propertyChangeEvent.getNewValue()).equals(Boolean.TRUE)) {
                DesktopMode.this._desktopCardPanel.setMode(0);
                DesktopMode.this.selectComponent(jComponent);
            }
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            ComponentFrame componentFrame = (ComponentFrame)internalFrameEvent.getSource();
            componentFrame.setVisible(false);
            if (componentFrame.isSelected()) {
                try {
                    componentFrame.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            DesktopMode.this._desktopCardPanel.removeComponent(componentFrame.getComponent());
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            ComponentFrame componentFrame = (ComponentFrame)internalFrameEvent.getSource();
            DesktopMode.this.selectComponent(componentFrame.getComponent());
        }
    }

    public class ComponentFrame
    extends JInternalFrame {
        private JComponent _component;
        private JScrollPane _scrollPane;

        public ComponentFrame(JComponent jComponent, boolean bl) {
            this(jComponent, bl, true);
        }

        public ComponentFrame(JComponent jComponent, boolean bl, boolean bl2) {
            super("", true, bl2, true, true);
            this._component = jComponent;
            this.setDefaultCloseOperation(0);
            if (bl) {
                this._scrollPane = new JScrollPane(this._component, 22, 32);
                this.getContentPane().add("Center", this._scrollPane);
            } else {
                this.getContentPane().add("Center", this._component);
            }
            if (jComponent.getName() != null) {
                this.setTitle(jComponent.getName());
            }
            this.pack();
            this.show();
        }

        public JComponent getComponent() {
            return this._component;
        }

        public boolean isScrollable() {
            return this._scrollPane != null;
        }
    }
}

