/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram.undo;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoHandler
implements UndoableEditListener {
    protected UndoManager _undo;
    protected UndoAction _undoAction;
    protected RedoAction _redoAction;

    public UndoHandler(UndoManager undoManager) {
        this._undo = undoManager;
        this._undoAction = new UndoAction();
        this._redoAction = new RedoAction();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this._undo.addEdit(undoableEditEvent.getEdit());
        this._undoAction.update();
        this._redoAction.update();
    }

    public UndoAction getUndoAction() {
        return this._undoAction;
    }

    public RedoAction getRedoAction() {
        return this._redoAction;
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(UndoHandler.this._undo.getRedoPresentationName(), new ImageIcon(UndoHandler.this.getClass().getResource("redo.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoHandler.this._undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.update();
            UndoHandler.this._undoAction.update();
        }

        protected void update() {
            this.setEnabled(UndoHandler.this._undo.canRedo());
            this.putValue("ShortDescription", UndoHandler.this._undo.getRedoPresentationName());
        }
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(UndoHandler.this._undo.getUndoPresentationName(), new ImageIcon(UndoHandler.this.getClass().getResource("undo.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoHandler.this._undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.update();
            UndoHandler.this._redoAction.update();
        }

        protected void update() {
            this.setEnabled(UndoHandler.this._undo.canUndo());
            this.putValue("ShortDescription", UndoHandler.this._undo.getUndoPresentationName());
        }
    }
}

