/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.buffer;

import simtools.data.DataException;
import simtools.data.ValueProvider;
import simtools.data.buffer.Buffer;
import simtools.data.buffer.SimpleBuffer;

public class ResizeableBuffer
extends SimpleBuffer {
    static final long serialVersionUID = -2478606334421999382L;
    protected int minSize;
    protected int maxSize;

    public ResizeableBuffer() {
        this(null);
    }

    public ResizeableBuffer(int n) {
        this(7, n);
    }

    public ResizeableBuffer(int n, int n2) {
        this(n, null, n2);
    }

    public ResizeableBuffer(ValueProvider valueProvider) {
        this(valueProvider, Integer.MAX_VALUE);
    }

    public ResizeableBuffer(ValueProvider valueProvider, int n) {
        this(7, valueProvider, n);
    }

    public ResizeableBuffer(int n, ValueProvider valueProvider) {
        this(n, valueProvider, Integer.MAX_VALUE);
    }

    public ResizeableBuffer(int n, ValueProvider valueProvider, int n2) {
        this(n, valueProvider, DEFAULT_BUFFER_SIZE, n2);
    }

    public ResizeableBuffer(int n, ValueProvider valueProvider, int n2, int n3) {
        super(n, valueProvider, n2);
        this.minSize = n2;
        this.maxSize = n3;
    }

    protected Buffer.Manipulator createManipulator(int n) {
        switch (n) {
            case 1: {
                return new ResizeableByteManipulator();
            }
            case 2: {
                return new ResizeableShortManipulator();
            }
            case 3: {
                return new ResizeableIntegerManipulator();
            }
            case 4: {
                return new ResizeableLongManipulator();
            }
            case 5: {
                return new ResizeableFloatManipulator();
            }
            case 6: {
                return new ResizeableDoubleManipulator();
            }
            case 7: {
                return new ResizeableObjectManipulator();
            }
        }
        return null;
    }

    public class ResizeableObjectManipulator
    extends SimpleBuffer.SimpleObjectManipulator {
        public ResizeableObjectManipulator() {
            super(ResizeableBuffer.this);
        }

        public Object getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            Object object = ResizeableBuffer.this.provider.getObjectValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                Object[] objectArray = new Object[n2];
                boolean[] blArray = new boolean[n2];
                long l2 = l + (long)n2 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, objectArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = objectArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = object;
                ResizeableBuffer.this.valid[0] = true;
                return object;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            Object[] objectArray = new Object[n5];
            boolean[] blArray = new boolean[n5];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n5 - 1L < l) {
                l3 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, objectArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = objectArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = object;
            ResizeableBuffer.this.valid[n6] = true;
            return object;
        }

        public boolean setValue(long l, Object object) throws DataException {
            if (super.setValue(l, object)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            Object[] objectArray = new Object[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, objectArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = objectArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = object;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            Object[] objectArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                objectArray = new Object[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && objectArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, objectArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = objectArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableDoubleManipulator
    extends SimpleBuffer.SimpleDoubleManipulator {
        public ResizeableDoubleManipulator() {
            super(ResizeableBuffer.this);
        }

        public double getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            double d = ResizeableBuffer.this.provider.getDoubleValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                double[] dArray = new double[n2];
                boolean[] blArray = new boolean[n2];
                long l2 = l + (long)n2 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, dArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = dArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = d;
                ResizeableBuffer.this.valid[0] = true;
                return d;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            double[] dArray = new double[n5];
            boolean[] blArray = new boolean[n5];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n5 - 1L < l) {
                l3 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, dArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = dArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = d;
            ResizeableBuffer.this.valid[n6] = true;
            return d;
        }

        public boolean setValue(long l, double d) throws DataException {
            if (super.setValue(l, d)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            double[] dArray = new double[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, dArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = dArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = d;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            double[] dArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                dArray = new double[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && dArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, dArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = dArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableFloatManipulator
    extends SimpleBuffer.SimpleFloatManipulator {
        public ResizeableFloatManipulator() {
            super(ResizeableBuffer.this);
        }

        public float getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            float f = ResizeableBuffer.this.provider.getFloatValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                float[] fArray = new float[n2];
                boolean[] blArray = new boolean[n2];
                long l2 = l + (long)n2 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, fArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = fArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = f;
                ResizeableBuffer.this.valid[0] = true;
                return f;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            float[] fArray = new float[n5];
            boolean[] blArray = new boolean[n5];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n5 - 1L < l) {
                l3 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, fArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = fArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = f;
            ResizeableBuffer.this.valid[n6] = true;
            return f;
        }

        public boolean setValue(long l, float f) throws DataException {
            if (super.setValue(l, f)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            float[] fArray = new float[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, fArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = fArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = f;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            float[] fArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                fArray = new float[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && fArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, fArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = fArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableLongManipulator
    extends SimpleBuffer.SimpleLongManipulator {
        public ResizeableLongManipulator() {
            super(ResizeableBuffer.this);
        }

        public long getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            long l2 = ResizeableBuffer.this.provider.getLongValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                long[] lArray = new long[n2];
                boolean[] blArray = new boolean[n2];
                long l3 = l + (long)n2 - 1L;
                if (l3 > ResizeableBuffer.this.endIndex) {
                    l3 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l3 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, lArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = lArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = l2;
                ResizeableBuffer.this.valid[0] = true;
                return l2;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            long[] lArray = new long[n5];
            boolean[] blArray = new boolean[n5];
            long l4 = ResizeableBuffer.this.startIndex;
            if (l4 + (long)n5 - 1L < l) {
                l4 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l4 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, lArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l4;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = lArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = l2;
            ResizeableBuffer.this.valid[n6] = true;
            return l2;
        }

        public boolean setValue(long l, long l2) throws DataException {
            if (super.setValue(l, l2)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            long[] lArray = new long[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, lArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = lArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = l2;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            long[] lArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                lArray = new long[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && lArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, lArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = lArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableIntegerManipulator
    extends SimpleBuffer.SimpleIntegerManipulator {
        public ResizeableIntegerManipulator() {
            super(ResizeableBuffer.this);
        }

        public int getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            int n2 = ResizeableBuffer.this.provider.getIntegerValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n3 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n3 > ResizeableBuffer.this.maxSize) {
                    n3 = ResizeableBuffer.this.maxSize;
                }
                int[] nArray = new int[n3];
                boolean[] blArray = new boolean[n3];
                long l2 = l + (long)n3 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n4 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n5 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n4 > 0) {
                    System.arraycopy(this.buffer, 0, nArray, n5, n4);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n5, n4);
                }
                this.buffer = nArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = n2;
                ResizeableBuffer.this.valid[0] = true;
                return n2;
            }
            int n6 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n6 > ResizeableBuffer.this.maxSize) {
                n6 = ResizeableBuffer.this.maxSize;
            }
            int[] nArray = new int[n6];
            boolean[] blArray = new boolean[n6];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n6 - 1L < l) {
                l3 = l - (long)n6 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, nArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = nArray;
            ResizeableBuffer.this.valid = blArray;
            int n7 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n7] = n2;
            ResizeableBuffer.this.valid[n7] = true;
            return n2;
        }

        public boolean setValue(long l, int n) throws DataException {
            if (super.setValue(l, n)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n2 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n2 > ResizeableBuffer.this.maxSize) {
                n2 = ResizeableBuffer.this.maxSize;
            }
            int[] nArray = new int[n2];
            boolean[] blArray = new boolean[n2];
            int n3 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, nArray, 0, n3);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n3);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = nArray;
            ResizeableBuffer.this.valid = blArray;
            int n4 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n4] = n;
            ResizeableBuffer.this.valid[n4] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            int[] nArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                nArray = new int[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && nArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, nArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = nArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableShortManipulator
    extends SimpleBuffer.SimpleShortManipulator {
        public ResizeableShortManipulator() {
            super(ResizeableBuffer.this);
        }

        public short getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            short s = ResizeableBuffer.this.provider.getShortValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                short[] sArray = new short[n2];
                boolean[] blArray = new boolean[n2];
                long l2 = l + (long)n2 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, sArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = sArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = s;
                ResizeableBuffer.this.valid[0] = true;
                return s;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            short[] sArray = new short[n5];
            boolean[] blArray = new boolean[n5];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n5 - 1L < l) {
                l3 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, sArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = sArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = s;
            ResizeableBuffer.this.valid[n6] = true;
            return s;
        }

        public boolean setValue(long l, short s) throws DataException {
            if (super.setValue(l, s)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            short[] sArray = new short[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, sArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = sArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = s;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            short[] sArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                sArray = new short[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && sArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, sArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = sArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }

    public class ResizeableByteManipulator
    extends SimpleBuffer.SimpleByteManipulator {
        public ResizeableByteManipulator() {
            super(ResizeableBuffer.this);
        }

        public byte getValue(long l) throws DataException {
            int n;
            if (ResizeableBuffer.this.startIndex < 0L || ResizeableBuffer.this.endIndex < 0L) {
                return super.getValue(l);
            }
            if (l > ResizeableBuffer.this.endIndex - (long)this.buffer.length && l < ResizeableBuffer.this.startIndex + (long)this.buffer.length) {
                return super.getValue(l);
            }
            if (this.buffer.length == ResizeableBuffer.this.maxSize) {
                return super.getValue(l);
            }
            byte by = ResizeableBuffer.this.provider.getByteValue(l);
            if (l <= ResizeableBuffer.this.endIndex - (long)this.buffer.length) {
                int n2 = (int)(ResizeableBuffer.this.endIndex - l + 1L);
                if (n2 > ResizeableBuffer.this.maxSize) {
                    n2 = ResizeableBuffer.this.maxSize;
                }
                byte[] byArray = new byte[n2];
                boolean[] blArray = new boolean[n2];
                long l2 = l + (long)n2 - 1L;
                if (l2 > ResizeableBuffer.this.endIndex) {
                    l2 = ResizeableBuffer.this.endIndex;
                }
                int n3 = (int)(l2 - ResizeableBuffer.this.startIndex + 1L);
                int n4 = (int)(ResizeableBuffer.this.startIndex - l);
                if (n3 > 0) {
                    System.arraycopy(this.buffer, 0, byArray, n4, n3);
                    System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, n4, n3);
                }
                this.buffer = byArray;
                ResizeableBuffer.this.valid = blArray;
                ResizeableBuffer.this.startIndex = l;
                this.buffer[0] = by;
                ResizeableBuffer.this.valid[0] = true;
                return by;
            }
            int n5 = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n5 > ResizeableBuffer.this.maxSize) {
                n5 = ResizeableBuffer.this.maxSize;
            }
            byte[] byArray = new byte[n5];
            boolean[] blArray = new boolean[n5];
            long l3 = ResizeableBuffer.this.startIndex;
            if (l3 + (long)n5 - 1L < l) {
                l3 = l - (long)n5 + 1L;
            }
            if ((n = (int)(ResizeableBuffer.this.endIndex - l3 + 1L)) > 0) {
                System.arraycopy(this.buffer, 0, byArray, 0, n);
                System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n);
            }
            ResizeableBuffer.this.startIndex = l3;
            ResizeableBuffer.this.endIndex = l;
            this.buffer = byArray;
            ResizeableBuffer.this.valid = blArray;
            int n6 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n6] = by;
            ResizeableBuffer.this.valid[n6] = true;
            return by;
        }

        public boolean setValue(long l, byte by) throws DataException {
            if (super.setValue(l, by)) {
                return true;
            }
            if (l < ResizeableBuffer.this.startIndex || l >= ResizeableBuffer.this.startIndex + (long)ResizeableBuffer.this.maxSize) {
                return false;
            }
            int n = (int)(l - ResizeableBuffer.this.startIndex + 1L) * 3 / 2;
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            byte[] byArray = new byte[n];
            boolean[] blArray = new boolean[n];
            int n2 = (int)(ResizeableBuffer.this.endIndex - ResizeableBuffer.this.startIndex + 1L);
            System.arraycopy(this.buffer, 0, byArray, 0, n2);
            System.arraycopy(ResizeableBuffer.this.valid, 0, blArray, 0, n2);
            ResizeableBuffer.this.endIndex = l;
            this.buffer = byArray;
            ResizeableBuffer.this.valid = blArray;
            int n3 = (int)(l - ResizeableBuffer.this.startIndex);
            this.buffer[n3] = by;
            ResizeableBuffer.this.valid[n3] = true;
            return true;
        }

        public void setSlice(long l, long l2) {
            int n = (int)(l2 - l + 1L);
            if (n > ResizeableBuffer.this.maxSize) {
                n = ResizeableBuffer.this.maxSize;
            }
            byte[] byArray = this.buffer;
            boolean[] blArray = ResizeableBuffer.this.valid;
            if (n > this.buffer.length || n < this.buffer.length >> 3) {
                byArray = new byte[n];
                blArray = new boolean[n];
            }
            if (l >= ResizeableBuffer.this.startIndex && l2 < ResizeableBuffer.this.startIndex + (long)this.buffer.length && byArray == this.buffer) {
                return;
            }
            long l3 = l > ResizeableBuffer.this.startIndex ? l : ResizeableBuffer.this.startIndex;
            long l4 = l2 < ResizeableBuffer.this.endIndex ? l2 : ResizeableBuffer.this.endIndex;
            int n2 = (int)(l3 - ResizeableBuffer.this.startIndex);
            int n3 = (int)(l3 - l);
            int n4 = (int)(l4 - l3 + 1L);
            if (n4 > 0) {
                System.arraycopy(this.buffer, n2, byArray, n3, n4);
                System.arraycopy(ResizeableBuffer.this.valid, n2, blArray, n3, n4);
                ResizeableBuffer.this.startIndex = l;
                ResizeableBuffer.this.endIndex = l4;
            } else {
                ResizeableBuffer.this.startIndex = -1L;
                ResizeableBuffer.this.endIndex = -2L;
            }
            this.buffer = byArray;
            ResizeableBuffer.this.valid = blArray;
        }
    }
}

