/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.async;

import java.io.IOException;
import java.text.ChoiceFormat;
import simtools.data.DataException;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.data.async.StreamingTSDataSourceCollection;
import simtools.data.async.TimeStampedDataSource;
import simtools.data.async.TimeStampedDataSourceCollection;

public class StreamingTSDataSource
extends TimeStampedDataSource {
    protected int _startIndex;
    protected int _lastIndex;
    protected double[] _t;
    protected double[] _v;
    protected double _dmin;
    protected double _dmax;
    protected int _size;
    protected final double _minDuration;

    public StreamingTSDataSource(String string, StreamingTSDataSourceCollection streamingTSDataSourceCollection, int n, double d) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException {
        super(string, streamingTSDataSourceCollection);
        this.setTime(new StreamingTimeSource());
        this._startIndex = -1;
        this._lastIndex = -1;
        this._size = n;
        this._t = new double[this._size];
        this._v = new double[this._size];
        this._minDuration = d;
    }

    public double getStart() {
        if (this._startIndex >= 0) {
            return this._t[this._startIndex % this._size];
        }
        return 0.0;
    }

    public double getEnd() {
        if (this._lastIndex >= 0) {
            return this._t[this._lastIndex % this._size];
        }
        return 0.0;
    }

    protected void computeMinMax() throws UnsupportedOperation {
    }

    public double getDoubleMin() throws DataException {
        return this._dmin;
    }

    public Object getMin() {
        return new Double(this._dmin);
    }

    public double getDoubleMax() throws DataException {
        return this._dmax;
    }

    public Object getMax() {
        return new Double(this._dmax);
    }

    public Object getValue(long l) throws DataException {
        if (this._startIndex < 0) {
            throw new NoSuchIndex(l);
        }
        if (l < (long)this._startIndex) {
            throw new NoSuchIndex(l);
        }
        if (l > (long)this._lastIndex) {
            throw new NoSuchIndex(l);
        }
        return new Double(this._v[(int)l % this._size]);
    }

    public double getDoubleValue(long l) throws DataException {
        if (this._startIndex < 0) {
            throw new NoSuchIndex(l);
        }
        if (l < (long)this._startIndex) {
            throw new NoSuchIndex(l);
        }
        if (l > (long)this._lastIndex) {
            throw new NoSuchIndex(l);
        }
        return this._v[(int)l % this._size];
    }

    public long getStartIndex() throws UnsupportedOperation {
        return this._startIndex;
    }

    public long getLastIndex() throws UnsupportedOperation {
        return this._lastIndex;
    }

    public boolean isValid() {
        return this._startIndex >= 0;
    }

    public ChoiceFormat getChoiceFormat() {
        return null;
    }

    public void add(double d, double d2) {
        if (this._startIndex < 0) {
            this._startIndex = 0;
            this._lastIndex = 0;
            this._t[0] = d;
            this._v[0] = d2;
            this._dmin = this._dmax = d2;
            this.notifyListenersForValueRangeChange();
            this.notifyListenersForIndexRangeChange(0L, 0L);
            this.notifyEndNotificationListeners();
        } else {
            int n;
            ++this._lastIndex;
            if (this._lastIndex >= this._size) {
                if (this._startIndex == 0 && this._minDuration >= 0.0) {
                    if (this._t[this._size - 1] - this._t[0] < this._minDuration) {
                        n = this._size * 2;
                        double[] dArray = new double[n];
                        double[] dArray2 = new double[n];
                        System.arraycopy(this._t, 0, dArray, 0, this._size);
                        System.arraycopy(this._v, 0, dArray2, 0, this._size);
                        this._t = dArray;
                        this._v = dArray2;
                        this._size = n;
                    } else {
                        ++this._startIndex;
                    }
                } else {
                    ++this._startIndex;
                }
            }
            n = this._lastIndex % this._size;
            this._v[n] = d2;
            this._t[n] = d;
            if (d2 < this._dmin) {
                this._dmin = d2;
                if (d2 > this._dmax) {
                    this._dmax = d2;
                }
                this.notifyListenersForValueRangeChange();
            } else if (d2 > this._dmax) {
                this._dmax = d2;
                this.notifyListenersForValueRangeChange();
            }
            this.notifyListenersForIndexRangeChange(this._startIndex, this._lastIndex);
            this.notifyEndNotificationListeners();
            this.getTime().notifyListenersForValueRangeChange();
            this.getTime().notifyListenersForIndexRangeChange(this._startIndex, this._lastIndex);
            this.getTime().notifyEndNotificationListeners();
        }
    }

    public class StreamingTimeSource
    extends TimeStampedDataSource.TimeSource {
        public StreamingTimeSource() {
            super(StreamingTSDataSource.this);
        }

        public Object getValue(long l) throws DataException {
            if (StreamingTSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingTSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingTSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            return new Double(StreamingTSDataSource.this._t[(int)l % StreamingTSDataSource.this._size]);
        }

        public double getDoubleValue(long l) throws DataException {
            if (StreamingTSDataSource.this._startIndex < 0) {
                throw new NoSuchIndex(l);
            }
            if (l < (long)StreamingTSDataSource.this._startIndex) {
                throw new NoSuchIndex(l);
            }
            if (l > (long)StreamingTSDataSource.this._lastIndex) {
                throw new NoSuchIndex(l);
            }
            return StreamingTSDataSource.this._t[(int)l % StreamingTSDataSource.this._size];
        }
    }
}

