/*
 * Decompiled with CFR 0.152.
 */
package simtools.data;

import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.NoSuchIndex;
import simtools.data.UnsupportedOperation;
import simtools.data.buffer.DelayedBuffer;
import simtools.util.NumberStringComparator;

public class DynamicDataSource
extends DataSource {
    public DataInfo info;
    protected long lastIndex;
    protected boolean autoRegister = true;
    protected int kind;
    protected boolean hasValue;
    protected byte currentByte;
    protected byte cachedByte;
    protected byte minByte;
    protected byte maxByte;
    protected short currentShort;
    protected short cachedShort;
    protected short minShort;
    protected short maxShort;
    protected int currentInteger;
    protected int cachedInteger;
    protected int minInteger;
    protected int maxInteger;
    protected long currentLong;
    protected long cachedLong;
    protected long minLong;
    protected long maxLong;
    protected float currentFloat;
    protected float cachedFloat;
    protected float minFloat;
    protected float maxFloat;
    protected double currentDouble;
    protected double cachedDouble;
    protected double minDouble;
    protected double maxDouble;
    protected Object currentObject;
    protected Object cachedObject;
    protected Object minObject;
    protected Object maxObject;
    DelayedBuffer buffer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public DynamicDataSource(DataInfo dataInfo, int n) {
        this(dataInfo, n, 0);
    }

    public DynamicDataSource(DataInfo dataInfo, int n, int n2) {
        this.info = dataInfo;
        this.buffer = n2 > 0 ? new DelayedBuffer(n, this, n2) : null;
        this.kind = n;
        this.lastIndex = -1L;
        this.hasValue = false;
        this.autoRegister = true;
    }

    public void bufferize(int n) throws UnsupportedOperation {
        this.buffer = new DelayedBuffer(this.kind, this, n);
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean bl) {
        this.autoRegister = bl;
    }

    public DataInfo getInformation(int n) {
        return this.info;
    }

    public Object getMin() throws UnsupportedOperation {
        if (!this.hasValue) {
            throw new UnsupportedOperation();
        }
        switch (this.kind) {
            case 1: {
                return new Byte(this.minByte);
            }
            case 2: {
                return new Short(this.minShort);
            }
            case 3: {
                return new Integer(this.minInteger);
            }
            case 4: {
                return new Long(this.minLong);
            }
            case 5: {
                return new Float(this.minFloat);
            }
            case 6: {
                return new Double(this.minDouble);
            }
            case 7: {
                return this.minObject;
            }
        }
        return null;
    }

    public Object getMax() throws UnsupportedOperation {
        if (!this.hasValue) {
            throw new UnsupportedOperation();
        }
        switch (this.kind) {
            case 1: {
                return new Byte(this.maxByte);
            }
            case 2: {
                return new Short(this.maxShort);
            }
            case 3: {
                return new Integer(this.maxInteger);
            }
            case 4: {
                return new Long(this.maxLong);
            }
            case 5: {
                return new Float(this.maxFloat);
            }
            case 6: {
                return new Double(this.maxDouble);
            }
            case 7: {
                return this.maxObject;
            }
        }
        return null;
    }

    public byte getByteMin() throws DataException {
        if (this.kind == 1) {
            return this.minByte;
        }
        return super.getByteMin();
    }

    public byte getByteMax() throws DataException {
        if (this.kind == 1) {
            return this.maxByte;
        }
        return super.getByteMax();
    }

    public short getShortMin() throws DataException {
        if (this.kind == 2) {
            return this.minShort;
        }
        return super.getShortMin();
    }

    public short getShortMax() throws DataException {
        if (this.kind == 2) {
            return this.maxShort;
        }
        return super.getShortMax();
    }

    public int getIntegerMin() throws DataException {
        if (this.kind == 3) {
            return this.minInteger;
        }
        return super.getIntegerMin();
    }

    public int getIntegerMax() throws DataException {
        if (this.kind == 3) {
            return this.maxInteger;
        }
        return super.getIntegerMax();
    }

    public long getLongMin() throws DataException {
        if (this.kind == 4) {
            return this.minLong;
        }
        return super.getLongMin();
    }

    public long getLongMax() throws DataException {
        if (this.kind == 4) {
            return this.maxLong;
        }
        return super.getLongMax();
    }

    public float getFloatMin() throws DataException {
        if (this.kind == 5) {
            return this.minFloat;
        }
        return super.getFloatMin();
    }

    public float getFloatMax() throws DataException {
        if (this.kind == 5) {
            return this.maxFloat;
        }
        return super.getFloatMax();
    }

    public double getDoubleMin() throws DataException {
        if (this.kind == 6) {
            return this.minDouble;
        }
        return super.getDoubleMin();
    }

    public double getDoubleMax() throws DataException {
        if (this.kind == 6) {
            return this.maxDouble;
        }
        return super.getDoubleMax();
    }

    public Object computeMin(int n) throws UnsupportedOperation {
        if (!this.hasValue) {
            throw new UnsupportedOperation();
        }
        if (this.buffer == null) {
            switch (this.kind) {
                case 1: {
                    this.minByte = this.cachedByte;
                    return new Byte(this.minByte);
                }
                case 2: {
                    this.minShort = this.cachedShort;
                    return new Short(this.minShort);
                }
                case 3: {
                    this.minInteger = this.cachedInteger;
                    return new Integer(this.minInteger);
                }
                case 4: {
                    this.minLong = this.cachedLong;
                    return new Long(this.minLong);
                }
                case 5: {
                    this.minFloat = this.cachedFloat;
                    return new Float(this.minFloat);
                }
                case 6: {
                    this.minDouble = this.cachedDouble;
                    return new Double(this.minDouble);
                }
                case 7: {
                    this.minObject = this.cachedObject;
                    return this.minObject;
                }
            }
            return null;
        }
        int n2 = this.sortedOrder();
        switch (this.kind) {
            case 1: {
                try {
                    this.minByte = n2 == 1 ? this.buffer.getByteValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getByteValue(this.buffer.getEndIndex()) : this.cachedByte);
                    return new Byte(this.minByte);
                }
                catch (DataException dataException) {
                    this.minByte = this.cachedByte;
                    return new Byte(this.minByte);
                }
            }
            case 2: {
                try {
                    this.minShort = n2 == 1 ? this.buffer.getShortValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getShortValue(this.buffer.getEndIndex()) : this.cachedShort);
                    return new Short(this.minShort);
                }
                catch (DataException dataException) {
                    this.minShort = this.cachedShort;
                    return new Short(this.minShort);
                }
            }
            case 3: {
                try {
                    this.minInteger = n2 == 1 ? this.buffer.getIntegerValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getIntegerValue(this.buffer.getEndIndex()) : this.cachedInteger);
                    return new Integer(this.minInteger);
                }
                catch (DataException dataException) {
                    this.minInteger = this.cachedInteger;
                    return new Integer(this.minInteger);
                }
            }
            case 4: {
                try {
                    this.minLong = n2 == 1 ? this.buffer.getLongValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getLongValue(this.buffer.getEndIndex()) : this.cachedLong);
                    return new Long(this.minLong);
                }
                catch (DataException dataException) {
                    this.minLong = this.cachedLong;
                    return new Long(this.minLong);
                }
            }
            case 5: {
                try {
                    this.minFloat = n2 == 1 ? this.buffer.getFloatValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getFloatValue(this.buffer.getEndIndex()) : this.cachedFloat);
                    return new Float(this.minFloat);
                }
                catch (DataException dataException) {
                    this.minFloat = this.cachedFloat;
                    return new Float(this.minFloat);
                }
            }
            case 6: {
                try {
                    this.minDouble = n2 == 1 ? this.buffer.getDoubleValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getDoubleValue(this.buffer.getEndIndex()) : this.cachedDouble);
                    return new Double(this.minDouble);
                }
                catch (DataException dataException) {
                    this.minDouble = this.cachedDouble;
                    return new Double(this.minDouble);
                }
            }
            case 7: {
                try {
                    this.minObject = n2 == 1 ? this.buffer.getObjectValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getObjectValue(this.buffer.getEndIndex()) : this.cachedObject);
                    return this.minObject;
                }
                catch (DataException dataException) {
                    this.minObject = this.cachedObject;
                    return this.minObject;
                }
            }
        }
        return null;
    }

    public Object computeMax(int n) throws UnsupportedOperation {
        if (!this.hasValue) {
            throw new UnsupportedOperation();
        }
        if (this.buffer == null) {
            switch (this.kind) {
                case 1: {
                    this.maxByte = this.cachedByte;
                    return new Byte(this.maxByte);
                }
                case 2: {
                    this.maxShort = this.cachedShort;
                    return new Short(this.maxShort);
                }
                case 3: {
                    this.maxInteger = this.cachedInteger;
                    return new Integer(this.maxInteger);
                }
                case 4: {
                    this.maxLong = this.cachedLong;
                    return new Long(this.maxLong);
                }
                case 5: {
                    this.maxFloat = this.cachedFloat;
                    return new Float(this.maxFloat);
                }
                case 6: {
                    this.maxDouble = this.cachedDouble;
                    return new Double(this.maxDouble);
                }
                case 7: {
                    this.maxObject = this.cachedObject;
                    return this.maxObject;
                }
            }
            return null;
        }
        int n2 = this.sortedOrder();
        switch (this.kind) {
            case 1: {
                try {
                    this.maxByte = n2 == 1 ? this.buffer.getByteValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getByteValue(this.buffer.getEndIndex()) : this.cachedByte);
                    return new Byte(this.maxByte);
                }
                catch (DataException dataException) {
                    this.maxByte = this.cachedByte;
                    return new Byte(this.maxByte);
                }
            }
            case 2: {
                try {
                    this.maxShort = n2 == 1 ? this.buffer.getShortValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getShortValue(this.buffer.getEndIndex()) : this.cachedShort);
                    return new Short(this.maxShort);
                }
                catch (DataException dataException) {
                    this.maxShort = this.cachedShort;
                    return new Short(this.maxShort);
                }
            }
            case 3: {
                try {
                    this.maxInteger = n2 == 1 ? this.buffer.getIntegerValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getIntegerValue(this.buffer.getEndIndex()) : this.cachedInteger);
                    return new Integer(this.maxInteger);
                }
                catch (DataException dataException) {
                    this.maxInteger = this.cachedInteger;
                    return new Integer(this.maxInteger);
                }
            }
            case 4: {
                try {
                    this.maxLong = n2 == 1 ? this.buffer.getLongValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getLongValue(this.buffer.getEndIndex()) : this.cachedLong);
                    return new Long(this.maxLong);
                }
                catch (DataException dataException) {
                    this.maxLong = this.cachedLong;
                    return new Long(this.maxLong);
                }
            }
            case 5: {
                try {
                    this.maxFloat = n2 == 1 ? this.buffer.getFloatValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getFloatValue(this.buffer.getEndIndex()) : this.cachedFloat);
                    return new Float(this.maxFloat);
                }
                catch (DataException dataException) {
                    this.maxFloat = this.cachedFloat;
                    return new Float(this.maxFloat);
                }
            }
            case 6: {
                try {
                    this.maxDouble = n2 == 1 ? this.buffer.getDoubleValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getDoubleValue(this.buffer.getEndIndex()) : this.cachedDouble);
                    return new Double(this.maxDouble);
                }
                catch (DataException dataException) {
                    this.maxDouble = this.cachedDouble;
                    return new Double(this.maxDouble);
                }
            }
            case 7: {
                try {
                    this.maxObject = n2 == 1 ? this.buffer.getObjectValue(this.buffer.getStartIndex()) : (n2 == -1 ? this.buffer.getObjectValue(this.buffer.getEndIndex()) : this.cachedObject);
                    return this.maxObject;
                }
                catch (DataException dataException) {
                    this.maxObject = this.cachedObject;
                    return this.maxObject;
                }
            }
        }
        return null;
    }

    public int sortedOrder(int n) {
        return 0;
    }

    public boolean isComparable(int n) {
        return false;
    }

    public long getStartIndex() {
        if (this.buffer == null) {
            return this.lastIndex;
        }
        return this.buffer.getStartIndex();
    }

    public long getLastIndex() {
        if (this.buffer == null) {
            return this.lastIndex;
        }
        return this.buffer.getEndIndex();
    }

    public long computeStartIndex() {
        return this.getStartIndex();
    }

    public long computeLastIndex() {
        return this.getLastIndex();
    }

    protected void changeInfo(DataInfo dataInfo) {
        this.info = dataInfo;
        this.notifyListenersForInfoChange(dataInfo);
    }

    protected void setByteValue(byte by) {
        this.currentByte = by;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setShortValue(short s) {
        this.currentShort = s;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setIntegerValue(int n) {
        this.currentInteger = n;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setLongValue(long l) {
        this.currentLong = l;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setFloatValue(float f) {
        this.currentFloat = f;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setDoubleValue(double d) {
        this.currentDouble = d;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void setObjectValue(Object object) {
        this.currentObject = object;
        if (this.autoRegister) {
            this.registerNewValue();
        }
    }

    protected void registerNewValue() {
        ++this.lastIndex;
        boolean bl = false;
        switch (this.kind) {
            case 1: {
                this.cachedByte = this.currentByte;
                if (this.buffer != null) {
                    try {
                        this.buffer.setByteValue(this.lastIndex, this.cachedByte);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minByte = this.maxByte = this.cachedByte;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedByte < this.minByte) {
                    this.minByte = this.cachedByte;
                    bl = true;
                }
                if (this.cachedByte <= this.maxByte) break;
                this.maxByte = this.cachedByte;
                bl = true;
                break;
            }
            case 2: {
                this.cachedShort = this.currentShort;
                if (this.buffer != null) {
                    try {
                        this.buffer.setShortValue(this.lastIndex, this.cachedShort);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minShort = this.maxShort = this.cachedShort;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedShort < this.minShort) {
                    this.minShort = this.cachedShort;
                    bl = true;
                }
                if (this.cachedShort <= this.maxShort) break;
                this.maxShort = this.cachedShort;
                bl = true;
                break;
            }
            case 3: {
                this.cachedInteger = this.currentInteger;
                if (this.buffer != null) {
                    try {
                        this.buffer.setIntegerValue(this.lastIndex, this.cachedInteger);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minInteger = this.maxInteger = this.cachedInteger;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedInteger < this.minInteger) {
                    this.minInteger = this.cachedInteger;
                    bl = true;
                }
                if (this.cachedInteger <= this.maxInteger) break;
                this.maxInteger = this.cachedInteger;
                bl = true;
                break;
            }
            case 4: {
                this.cachedLong = this.currentLong;
                if (this.buffer != null) {
                    try {
                        this.buffer.setLongValue(this.lastIndex, this.cachedLong);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minLong = this.maxLong = this.cachedLong;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedLong < this.minLong) {
                    this.minLong = this.cachedLong;
                    bl = true;
                }
                if (this.cachedLong <= this.maxLong) break;
                this.maxLong = this.cachedLong;
                bl = true;
                break;
            }
            case 5: {
                this.cachedFloat = this.currentFloat;
                if (this.buffer != null) {
                    try {
                        this.buffer.setFloatValue(this.lastIndex, this.cachedFloat);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minFloat = this.maxFloat = this.cachedFloat;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedFloat < this.minFloat) {
                    this.minFloat = this.cachedFloat;
                    bl = true;
                }
                if (!(this.cachedFloat > this.maxFloat)) break;
                this.maxFloat = this.cachedFloat;
                bl = true;
                break;
            }
            case 6: {
                this.cachedDouble = this.currentDouble;
                if (this.buffer != null) {
                    try {
                        this.buffer.setDoubleValue(this.lastIndex, this.cachedDouble);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minDouble = this.maxDouble = this.cachedDouble;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                if (this.cachedDouble < this.minDouble) {
                    this.minDouble = this.cachedDouble;
                    bl = true;
                }
                if (!(this.cachedDouble > this.maxDouble)) break;
                this.maxDouble = this.cachedDouble;
                bl = true;
                break;
            }
            case 7: {
                this.cachedObject = this.currentObject;
                if (this.buffer != null) {
                    try {
                        this.buffer.setValue(this.lastIndex, this.cachedObject);
                    }
                    catch (DataException dataException) {
                        // empty catch block
                    }
                }
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.minObject = this.maxObject = this.cachedObject;
                    bl = true;
                    break;
                }
                if (this.sortedOrder() != 0) {
                    try {
                        this.computeMin();
                        this.computeMax();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        // empty catch block
                    }
                    bl = true;
                    break;
                }
                try {
                    if (NumberStringComparator.numStringCompare(this.cachedObject, this.minObject) < 0) {
                        this.minObject = this.cachedObject;
                        bl = true;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                try {
                    if (NumberStringComparator.numStringCompare(this.cachedObject, this.maxObject) <= 0) break;
                    this.maxObject = this.cachedObject;
                    bl = true;
                    break;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            this.notifyListenersForValueRangeChange();
        }
        this.notifyListenersForIndexRangeChange(this.getStartIndex(), this.getLastIndex());
        this.notifyEndNotificationListeners();
    }

    public DataInfo getInformation() {
        return this.info;
    }

    public Object getValue(long l) throws DataException {
        if (l == this.lastIndex) {
            switch (this.kind) {
                case 1: {
                    return new Byte(this.cachedByte);
                }
                case 2: {
                    return new Short(this.cachedShort);
                }
                case 3: {
                    return new Integer(this.cachedInteger);
                }
                case 4: {
                    return new Long(this.cachedLong);
                }
                case 5: {
                    return new Float(this.cachedFloat);
                }
                case 6: {
                    return new Double(this.cachedDouble);
                }
            }
            return this.cachedObject;
        }
        if (this.buffer == null) {
            throw new NoSuchIndex(l);
        }
        long l2 = this.buffer.getStartIndex();
        long l3 = this.buffer.getEndIndex();
        if (l < l2 || l > l3) {
            throw new NoSuchIndex(l);
        }
        return this.buffer.getValue(l);
    }

    public int getKind() {
        return this.kind;
    }

    public Class valueClass() {
        switch (this.kind) {
            case 1: {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = DynamicDataSource.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            case 2: {
                return class$java$lang$Short == null ? (class$java$lang$Short = DynamicDataSource.class$("java.lang.Short")) : class$java$lang$Short;
            }
            case 3: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DynamicDataSource.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$java$lang$Long == null ? (class$java$lang$Long = DynamicDataSource.class$("java.lang.Long")) : class$java$lang$Long;
            }
            case 5: {
                return class$java$lang$Float == null ? (class$java$lang$Float = DynamicDataSource.class$("java.lang.Float")) : class$java$lang$Float;
            }
            case 6: {
                return class$java$lang$Double == null ? (class$java$lang$Double = DynamicDataSource.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = DynamicDataSource.class$("java.lang.Object")) : class$java$lang$Object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

