/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.DataSourceConsumer;
import jsynoptic.base.Linkable;
import jsynoptic.builtin.ui.AxePropertiesPanel;
import jsynoptic.builtin.ui.CurvePropertiesPanel;
import jsynoptic.builtin.ui.PlotPropertiesPanel;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.ShapesContainer;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisLabelFormatter;
import simtools.shapes.CurveShape;
import simtools.shapes.PlotShape;
import simtools.ui.CustomizedLocale;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MenuResourceBundle;

public class Plot
extends PlotShape
implements ContextualActionProvider,
Linkable,
DataSourceConsumer {
    static final long serialVersionUID = 4941787241403275071L;
    protected String link;
    protected static MenuResourceBundle resources;
    static Color[] defaultPalette;
    protected int paletteIndex = 0;
    protected transient DataSource primaryX = null;
    protected transient DataSource secondaryX = null;
    protected Vector primaryCurves = null;
    protected Vector secondaryCurves = null;
    protected boolean isPrimaryBounded;
    protected long primaryStartIndex;
    protected long primaryEndIndex;
    protected boolean isSecondaryBounded;
    protected long secondaryStartIndex;
    protected long secondaryEndIndex;
    protected double pxmin;
    protected double pxmax;
    protected double pxstep;
    protected String pxlabel;
    protected double pymin;
    protected double pymax;
    protected double pystep;
    protected String pylabel;
    protected double sxmin;
    protected double sxmax;
    protected double sxstep;
    protected String sxlabel;
    protected double symin;
    protected double symax;
    protected double systep;
    protected String sylabel;
    protected boolean pxvaluesOK = false;
    protected boolean pyvaluesOK = false;
    protected boolean sxvaluesOK = false;
    protected boolean syvaluesOK = false;
    protected boolean autopx = true;
    protected boolean autopy = true;
    protected boolean autosx = true;
    protected boolean autosy = true;
    protected transient double zoomX;
    protected transient double zoomY;
    protected transient int zoomState = 0;
    protected transient Vector zoomHistory = new Vector();
    protected transient boolean isNotifying = true;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public Plot(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected AbstractShape cloneShape() {
        int n;
        int n2;
        Plot plot = (Plot)super.cloneShape();
        if (this.primaryCurves != null) {
            plot.primaryCurves = new Vector();
            for (n2 = 0; n2 < this.primaryCurves.size(); ++n2) {
                n = this._curves.indexOf(this.getCurve((CurveShape)this.primaryCurves.get(n2)));
                plot.primaryCurves.add(((PlotShape.Curve)plot._curves.get((int)n)).shape);
            }
        }
        if (this.secondaryCurves != null) {
            plot.secondaryCurves = new Vector();
            for (n2 = 0; n2 < this.secondaryCurves.size(); ++n2) {
                n = this._curves.indexOf(this.getCurve((CurveShape)this.secondaryCurves.get(n2)));
                plot.secondaryCurves.add(((PlotShape.Curve)plot._curves.get((int)n)).shape);
            }
        }
        return plot;
    }

    public boolean setPrimaryX(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, true, bl);
    }

    public boolean addPrimaryY(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, true, true, bl);
    }

    public boolean setSecondaryX(DataSource dataSource, boolean bl) {
        return this.setX(dataSource, false, bl);
    }

    public boolean addSecondaryY(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, false, true, bl);
    }

    public boolean addSecondaryYForSecondaryX(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, false, false, bl);
    }

    public boolean addPrimaryYForSecondaryX(DataSource dataSource, boolean bl) {
        return this.addY(dataSource, true, false, bl);
    }

    protected boolean setX(DataSource dataSource, boolean bl, boolean bl2) {
        if (dataSource == null) {
            return false;
        }
        new LongAction(24L, new Object[]{dataSource, new Boolean(bl), new Boolean(bl2)}, new Object[]{dataSource, this}){

            protected void doAction() {
                CurveShape curveShape;
                DataSource dataSource;
                Object[] objectArray = (Object[])this.param;
                DataSource dataSource2 = (DataSource)objectArray[0];
                boolean bl = (Boolean)objectArray[1];
                boolean bl2 = (Boolean)objectArray[2];
                Rectangle rectangle = Plot.this.getBounds();
                try {
                    long l = dataSource2.computeStartIndex();
                    long l2 = dataSource2.computeLastIndex();
                    if (bl) {
                        Plot.this.isPrimaryBounded = true;
                        Plot.this.primaryStartIndex = l;
                        Plot.this.primaryEndIndex = l2;
                    } else {
                        Plot.this.isSecondaryBounded = true;
                        Plot.this.secondaryStartIndex = l;
                        Plot.this.secondaryEndIndex = l2;
                    }
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    if (bl) {
                        Plot.this.isPrimaryBounded = false;
                    }
                    Plot.this.isSecondaryBounded = false;
                }
                String string = DataInfo.getLabel(dataSource2);
                if (bl) {
                    dataSource = Plot.this.primaryX;
                    Plot.this.primaryX = dataSource2;
                    Plot.this.pxlabel = string;
                } else {
                    Plot.this.setSecondaryAxis(true, true);
                    dataSource = Plot.this.secondaryX;
                    Plot.this.secondaryX = dataSource2;
                    Plot.this.sxlabel = string;
                }
                if (Plot.this.primaryCurves != null) {
                    Iterator iterator = Plot.this.primaryCurves.iterator();
                    while (iterator.hasNext()) {
                        curveShape = (CurveShape)iterator.next();
                        if (curveShape.getXSource() != dataSource) continue;
                        curveShape.setData(dataSource2, curveShape.getYSource());
                        if (!Plot.this.isPrimaryBounded) continue;
                        curveShape.setSlice(Plot.this.primaryStartIndex, Plot.this.primaryEndIndex);
                    }
                }
                if (Plot.this.secondaryCurves != null) {
                    Iterator iterator = Plot.this.secondaryCurves.iterator();
                    while (iterator.hasNext()) {
                        curveShape = (CurveShape)iterator.next();
                        if (curveShape.getXSource() != dataSource) continue;
                        curveShape.setData(dataSource2, curveShape.getYSource());
                        if (!Plot.this.isSecondaryBounded) continue;
                        curveShape.setSlice(Plot.this.secondaryStartIndex, Plot.this.secondaryEndIndex);
                    }
                }
                Plot.this.repaintDiagram(rectangle);
            }
        }.start(bl2);
        return !bl2;
    }

    protected void doAddYAction(Object[] objectArray) {
        CurveShape curveShape;
        DataSource dataSource = (DataSource)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        boolean bl2 = (Boolean)objectArray[2];
        Rectangle rectangle = this.getBounds();
        if (bl2) {
            curveShape = new CurveShape(this.primaryX, dataSource);
            if (this.isPrimaryBounded) {
                curveShape.setSlice(this.primaryStartIndex, this.primaryEndIndex);
            }
        } else {
            curveShape = new CurveShape(this.secondaryX, dataSource);
            if (this.isSecondaryBounded) {
                curveShape.setSlice(this.secondaryStartIndex, this.secondaryEndIndex);
            }
        }
        String string = DataInfo.getLabel(dataSource);
        if (bl) {
            if (this.primaryCurves == null) {
                this.primaryCurves = new Vector();
            }
            this.primaryCurves.add(curveShape);
            this.insertCurve(curveShape, !bl2, false);
        } else {
            this.setSecondaryAxis(false, true);
            if (this.secondaryCurves == null) {
                this.secondaryCurves = new Vector();
            }
            this.secondaryCurves.add(curveShape);
            this.insertCurve(curveShape, !bl2, true);
        }
        if (this._curves.size() > 0) {
            this.setLegendVisible(true);
        }
        this.setCurveLabel(curveShape, string);
        this.setCurveColor(curveShape, defaultPalette[this.paletteIndex++]);
        if (this.paletteIndex >= defaultPalette.length) {
            this.paletteIndex = 0;
        }
        this.repaintDiagram(rectangle);
    }

    protected boolean addY(DataSource dataSource, boolean bl, boolean bl2, boolean bl3) {
        if (dataSource == null) {
            return false;
        }
        new LongAction(24L, new Object[]{dataSource, new Boolean(bl), new Boolean(bl2)}, new Object[]{dataSource, this}){

            protected void doAction() {
                Plot.this.doAddYAction((Object[])this.param);
            }
        }.start(bl3);
        return !bl3;
    }

    protected double computeStep(double d, double d2) {
        double d3 = Math.abs(d2 - d);
        double d4 = d3 / 9.0;
        double d5 = Math.log(10.0);
        double d6 = Math.floor(Math.log(d4 / 0.75) / d5);
        double d7 = Math.exp(d6 * d5);
        double d8 = d4 / d7;
        int n = 2;
        if (d8 < 1.5) {
            n = 1;
        } else if (d8 >= 3.5) {
            n = 5;
        }
        double d9 = (double)n * d7;
        return Math.rint(d9 * 1000000.0) / 1000000.0;
    }

    protected void repaintDiagram(Rectangle rectangle) {
        double d;
        double d2;
        int n;
        int n2;
        if (!this.pxvaluesOK && this.primaryX != null) {
            try {
                if (this.isPrimaryBounded) {
                    n2 = this.primaryX.sortedOrder();
                    if (n2 == 1) {
                        this.pxmin = this.primaryX.getDoubleValue(this.primaryStartIndex);
                        this.pxmax = this.primaryX.getDoubleValue(this.primaryEndIndex);
                    } else if (n2 == -1) {
                        this.pxmin = this.primaryX.getDoubleValue(this.primaryEndIndex);
                        this.pxmax = this.primaryX.getDoubleValue(this.primaryStartIndex);
                    } else {
                        this.pxmin = this.primaryX.getDoubleMin();
                        this.pxmax = this.primaryX.getDoubleMax();
                    }
                } else {
                    this.pxmin = this.primaryX.getDoubleMin();
                    this.pxmax = this.primaryX.getDoubleMax();
                }
                this.pxstep = this.computeStep(this.pxmin, this.pxmax);
                this.pxmin = Math.floor(this.pxmin / this.pxstep) * this.pxstep;
                this.pxmax = Math.ceil(this.pxmax / this.pxstep) * this.pxstep;
                this.pxvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.sxvaluesOK && this.secondaryX != null) {
            try {
                if (this.isSecondaryBounded) {
                    n2 = this.secondaryX.sortedOrder();
                    if (n2 == 1) {
                        this.sxmin = this.secondaryX.getDoubleValue(this.secondaryStartIndex);
                        this.sxmax = this.secondaryX.getDoubleValue(this.secondaryEndIndex);
                    } else if (n2 == -1) {
                        this.sxmin = this.secondaryX.getDoubleValue(this.secondaryEndIndex);
                        this.sxmax = this.secondaryX.getDoubleValue(this.secondaryStartIndex);
                    } else {
                        this.sxmin = this.secondaryX.getDoubleMin();
                        this.sxmax = this.secondaryX.getDoubleMax();
                    }
                } else {
                    this.sxmin = this.secondaryX.getDoubleMin();
                    this.sxmax = this.secondaryX.getDoubleMax();
                }
                this.sxstep = this.computeStep(this.sxmin, this.sxmax);
                this.sxmin = Math.floor(this.sxmin / this.sxstep) * this.sxstep;
                this.sxmax = Math.ceil(this.sxmax / this.sxstep) * this.sxstep;
                this.sxvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.pyvaluesOK && this.primaryCurves != null && this.primaryCurves.size() > 0) {
            try {
                DataSource dataSource = ((CurveShape)this.primaryCurves.get(0)).getYSource();
                this.pymin = dataSource.getDoubleMin();
                this.pymax = dataSource.getDoubleMax();
                for (n = 1; n < this.primaryCurves.size(); ++n) {
                    dataSource = ((CurveShape)this.primaryCurves.get(n)).getYSource();
                    d2 = dataSource.getDoubleMin();
                    d = dataSource.getDoubleMax();
                    if (d2 < this.pymin) {
                        this.pymin = d2;
                    }
                    if (!(d > this.pymax)) continue;
                    this.pymax = d;
                }
                this.pystep = this.computeStep(this.pymin, this.pymax);
                this.pymin = Math.floor(this.pymin / this.pystep) * this.pystep;
                this.pymax = Math.ceil(this.pymax / this.pystep) * this.pystep;
                this.pyvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (!this.syvaluesOK && this.secondaryCurves != null && this.secondaryCurves.size() > 0) {
            try {
                DataSource dataSource = ((CurveShape)this.secondaryCurves.get(0)).getYSource();
                this.symin = dataSource.getDoubleMin();
                this.symax = dataSource.getDoubleMax();
                for (n = 1; n < this.secondaryCurves.size(); ++n) {
                    dataSource = ((CurveShape)this.secondaryCurves.get(n)).getYSource();
                    d2 = dataSource.getDoubleMin();
                    d = dataSource.getDoubleMax();
                    if (d2 < this.symin) {
                        this.symin = d2;
                    }
                    if (!(d > this.symax)) continue;
                    this.symax = d;
                }
                this.systep = this.computeStep(this.symin, this.symax);
                this.symin = Math.floor(this.symin / this.systep) * this.systep;
                this.symax = Math.ceil(this.symax / this.systep) * this.systep;
                this.syvaluesOK = true;
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        if (this.pxvaluesOK) {
            this.setX(this.pxmin, this.pxmax, this.pxstep);
        }
        this.setLabel(this.pxlabel, true, false);
        if (this.pyvaluesOK) {
            this.setY(this.pymin, this.pymax, this.pystep);
        }
        this.setLabel(this.pylabel, false, false);
        if (this.sxvaluesOK) {
            this.setSecondaryX(this.sxmin, this.sxmax, this.sxstep);
        }
        this.setLabel(this.sxlabel, true, true);
        if (this.syvaluesOK) {
            this.setSecondaryY(this.symin, this.symax, this.systep);
        }
        this.setLabel(this.sylabel, false, true);
        if (rectangle != null) {
            rectangle.add(this.getBounds());
        }
        this.notifyChange(rectangle);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return new String[]{"mouseOver"};
        }
        if (n == 4) {
            return new String[]{"mouseOut"};
        }
        if (n == 5) {
            MouseEvent mouseEvent = (MouseEvent)object;
            if ((mouseEvent.getModifiers() & 0x10) != 16) {
                return null;
            }
            if (this.zoomState == 1) {
                return new String[]{"zoomTopLeft"};
            }
            if (this.zoomState == 2) {
                return new String[]{"zoomBottomRight"};
            }
            return null;
        }
        Vector<String> vector = new Vector<String>();
        if (object instanceof DataSource) {
            vector.add(resources.getStringValue("setX"));
            if (this.primaryX != null) {
                vector.add(resources.getStringValue("addY"));
                vector.add(resources.getStringValue("addSecY"));
                vector.add(resources.getStringValue("setSecX"));
                if (this.secondaryX != null) {
                    vector.add(resources.getStringValue("addYSecX"));
                    vector.add(resources.getStringValue("addSecYSecX"));
                }
            }
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getStringValue("setXY1Yn"));
            if (this.primaryX != null) {
                vector.add(resources.getStringValue("addY1Yn"));
                vector.add(resources.getStringValue("addSecY1Yn"));
                vector.add(resources.getStringValue("setSecXY1Yn"));
                if (this.secondaryX != null) {
                    vector.add(resources.getStringValue("addSecY1YnForSecX"));
                }
            }
        }
        if (vector.size() == 0) {
            JSynoptic.setStatus(resources.getStringValue("noSource"));
        }
        if (n == 1 && this.zoomState == 0) {
            vector.add(0, resources.getStringValue("properties"));
            if (this.primaryCurves != null && this.primaryCurves.size() != 0 || this.secondaryCurves != null && this.secondaryCurves.size() != 0) {
                vector.add(resources.getStringValue("autoscale"));
                vector.add(resources.getStringValue("zoomBox"));
                if (this.zoomHistory != null && this.zoomHistory.size() > 1) {
                    vector.add(resources.getStringValue("zoomOut"));
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        if (string == null) {
            return false;
        }
        if (string.equals("mouseOver") || string.equals("mouseOut") || string.equals("zoomTopLeft") || string.equals("zoomBottomRight") || string.equals(resources.getStringValue("properties")) || string.equals(resources.getStringValue("zoomBox")) || string.equals(resources.getStringValue("zoomOut")) || string.equals(resources.getStringValue("autoscale"))) {
            return true;
        }
        if (object instanceof DataSource || object instanceof DataSourceCollection) {
            if (JSynoptic.gui == null) {
                return false;
            }
            if (JSynoptic.gui.getSourcePanel().getSourceTree().isLocked(object)) {
                return false;
            }
        }
        return true;
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        Object object2;
        if (string == null) {
            return false;
        }
        if (string.equals("mouseOver")) {
            if (this.zoomState == 1) {
                JSynoptic.setStatus(resources.getStringValue("zoomTopLeftMessage"));
                return true;
            }
            if (this.zoomState == 2) {
                JSynoptic.setStatus(resources.getStringValue("zoomBottomRightMessage"));
                return true;
            }
            String string2 = "";
            if (this._asx1 != null) {
                string2 = this.pxlabel != null ? string2 + this.pxlabel : string2 + "x";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asx1.getMin() + (d - (double)this._ox) / this._asx1.getScale());
            }
            if (this._asy1 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.pylabel != null ? string2 + this.pylabel : string2 + "y";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asy1.getMin() + ((double)this._oy - d2) / this._asy1.getScale());
            }
            if (this._asx2 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.sxlabel != null ? string2 + this.sxlabel : string2 + "x'";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asx2.getMin() + (d - (double)this._ox) / this._asx2.getScale());
            }
            if (this._asy2 != null) {
                if (!string2.equals("")) {
                    string2 = string2 + "   ";
                }
                string2 = this.sylabel != null ? string2 + this.sylabel : string2 + "y'";
                string2 = string2 + "=" + AxisLabelFormatter.labelFormat(this._asy2.getMin() + ((double)this._oy - d2) / this._asy2.getScale());
            }
            if (!string2.equals("")) {
                JSynoptic.setStatus(string2);
            }
            return true;
        }
        if (string.equals("mouseOut")) {
            JSynoptic.setStatus("");
            return true;
        }
        if (string.equals(resources.getStringValue("properties"))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    CompoundEdit compoundEdit;
                    JPropertiesPanel jPropertiesPanel = Plot.this.createPanel();
                    jPropertiesPanel.setProperties(Plot.this);
                    int n = JOptionPane.showConfirmDialog(null, jPropertiesPanel, resources.getString("propertiesTitle"), 2, -1);
                    if (n == 0 && Plot.this.setProperties(jPropertiesPanel, compoundEdit = new CompoundEdit())) {
                        compoundEdit.end();
                        ShapesContainer.ShapesComponent shapesComponent = (ShapesContainer.ShapesComponent)JSynoptic.gui.getActiveDiagram();
                        shapesComponent.fireUndoableEditUpdate(new UndoableEditEvent(shapesComponent, compoundEdit));
                        shapesComponent.repaint();
                    }
                }
            }.start();
            return true;
        }
        if (string.equals("zoomTopLeft")) {
            if (this.zoomState != 1) {
                return false;
            }
            this.zoomX = d;
            this.zoomY = d2;
            this.zoomState = 2;
            JSynoptic.setStatus(resources.getStringValue("zoomBottomRightMessage"));
            return true;
        }
        if (string.equals("zoomBottomRight")) {
            if (this.zoomState != 2) {
                return false;
            }
            double[] dArray = new double[]{this.pxmin, this.pxmax, this.pxstep, this.pymin, this.pymax, this.pystep, this.sxmin, this.sxmax, this.sxstep, this.symin, this.symax, this.systep};
            boolean[] blArray = new boolean[]{this.pxvaluesOK, this.pyvaluesOK, this.sxvaluesOK, this.syvaluesOK};
            this.zoomHistory.add(dArray);
            this.zoomHistory.add(blArray);
            if (this._asx1 != null) {
                this.pxmin = this._asx1.getMin() + (this.zoomX - (double)this._ox) / this._asx1.getScale();
                this.pxmax = this._asx1.getMin() + (d - (double)this._ox) / this._asx1.getScale();
                this.pxstep = this.computeStep(this.pxmin, this.pxmax);
                this.pxmin = Math.floor(this.pxmin / this.pxstep) * this.pxstep;
                this.pxmax = Math.ceil(this.pxmax / this.pxstep) * this.pxstep;
                this.pxvaluesOK = true;
            } else {
                this.pxvaluesOK = false;
            }
            if (this._asy1 != null) {
                this.pymin = this._asy1.getMin() + ((double)this._oy - this.zoomY) / this._asy1.getScale();
                this.pymax = this._asy1.getMin() + ((double)this._oy - d2) / this._asy1.getScale();
                this.pystep = this.computeStep(this.pymin, this.pymax);
                this.pymin = Math.floor(this.pymin / this.pystep) * this.pystep;
                this.pymax = Math.ceil(this.pymax / this.pystep) * this.pystep;
                this.pyvaluesOK = true;
            } else {
                this.pyvaluesOK = false;
            }
            if (this._asx2 != null) {
                this.sxmin = this._asx2.getMin() + (this.zoomX - (double)this._ox) / this._asx2.getScale();
                this.sxmax = this._asx2.getMin() + (d - (double)this._ox) / this._asx2.getScale();
                this.sxstep = this.computeStep(this.sxmin, this.sxmax);
                this.sxmin = Math.floor(this.sxmin / this.sxstep) * this.sxstep;
                this.sxmax = Math.ceil(this.sxmax / this.sxstep) * this.sxstep;
                this.sxvaluesOK = true;
            } else {
                this.sxvaluesOK = false;
            }
            if (this._asy2 != null) {
                this.symin = this._asy2.getMin() + ((double)this._oy - this.zoomY) / this._asy2.getScale();
                this.symax = this._asy2.getMin() + ((double)this._oy - d2) / this._asy2.getScale();
                this.systep = this.computeStep(this.symin, this.symax);
                this.symin = Math.floor(this.symin / this.systep) * this.systep;
                this.symax = Math.ceil(this.symax / this.systep) * this.systep;
                this.syvaluesOK = true;
            } else {
                this.syvaluesOK = false;
            }
            this.zoomState = 0;
            JSynoptic.setStatus("");
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (string.equals(resources.getStringValue("zoomBox"))) {
            if (this.zoomState != 0) {
                return false;
            }
            this.zoomState = 1;
            JSynoptic.setStatus(resources.getStringValue("zoomTopLeftMessage"));
            return true;
        }
        if (string.equals(resources.getStringValue("zoomOut"))) {
            int n = this.zoomHistory.size();
            if (n < 2) {
                return false;
            }
            Object e = this.zoomHistory.remove(n - 1);
            Object e2 = this.zoomHistory.remove(n - 2);
            if (!(e instanceof boolean[])) {
                return false;
            }
            if (!(e2 instanceof double[])) {
                return false;
            }
            boolean[] blArray = (boolean[])e;
            double[] dArray = (double[])e2;
            this.pxmin = dArray[0];
            this.pxmax = dArray[1];
            this.pxstep = dArray[2];
            this.pxvaluesOK = blArray[0];
            this.pymin = dArray[3];
            this.pymax = dArray[4];
            this.pystep = dArray[5];
            this.pyvaluesOK = blArray[1];
            this.sxmin = dArray[6];
            this.sxmax = dArray[7];
            this.sxstep = dArray[8];
            this.sxvaluesOK = blArray[2];
            this.symin = dArray[9];
            this.symax = dArray[10];
            this.systep = dArray[11];
            this.syvaluesOK = blArray[3];
            this.zoomState = 0;
            JSynoptic.setStatus("");
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (string.equals(resources.getStringValue("autoscale"))) {
            this.pxvaluesOK = false;
            this.sxvaluesOK = false;
            this.pyvaluesOK = false;
            this.syvaluesOK = false;
            this.repaintDiagram(this.getBounds());
            return true;
        }
        if (object instanceof DataSource) {
            object2 = (DataSource)object;
            if (string.equals(resources.getStringValue("setX"))) {
                return this.setPrimaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addY"))) {
                return this.addPrimaryY((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addYSecX"))) {
                return this.addPrimaryYForSecondaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addSecY"))) {
                return this.addSecondaryY((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("setSecX"))) {
                return this.setSecondaryX((DataSource)object2, true);
            }
            if (string.equals(resources.getStringValue("addSecYSecX"))) {
                return this.addSecondaryYForSecondaryX((DataSource)object2, true);
            }
        }
        if (object instanceof DataSourceCollection) {
            object2 = (DataSourceCollection)object;
            if (string.equals(resources.getStringValue("setXY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        Plot.this.setPrimaryX((DataSource)dataSourceCollection.get(0), false);
                        boolean bl = Plot.this.pyvaluesOK;
                        Plot.this.pyvaluesOK = true;
                        for (int i = 1; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.pyvaluesOK = bl;
                        if (dataSourceCollection.size() > 1) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        Plot.this.setTitle(DataInfo.getLabel(dataSourceCollection));
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.pyvaluesOK;
                        Plot.this.pyvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.pyvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addPrimaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addSecY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 1) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("setSecXY1Yn"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        Plot.this.setSecondaryX((DataSource)dataSourceCollection.get(0), false);
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 1; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 1) {
                            Plot.this.addSecondaryY((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 2) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
            if (string.equals(resources.getStringValue("addSecY1YnForSecX"))) {
                if (((Vector)object2).size() < 1) {
                    return false;
                }
                new LongAction(0L, (Object)new Object[]{object2, string}){

                    protected void doAction() {
                        DataSourceCollection dataSourceCollection = (DataSourceCollection)((Object[])this.param)[0];
                        String string = (String)((Object[])this.param)[1];
                        boolean bl = Plot.this.syvaluesOK;
                        boolean bl2 = Plot.this.sylabel != null;
                        Plot.this.syvaluesOK = true;
                        for (int i = 0; i < dataSourceCollection.size() - 1; ++i) {
                            Plot.this.addSecondaryYForSecondaryX((DataSource)dataSourceCollection.get(i), false);
                        }
                        Plot.this.syvaluesOK = bl;
                        if (dataSourceCollection.size() > 0) {
                            Plot.this.addSecondaryYForSecondaryX((DataSource)dataSourceCollection.get(dataSourceCollection.size() - 1), false);
                        }
                        Rectangle rectangle = Plot.this.getBounds();
                        if (!bl2 && dataSourceCollection.size() > 1) {
                            Plot.this.sylabel = null;
                            Plot.this.setLegendVisible(true);
                        }
                        Plot.this.repaintDiagram(rectangle);
                    }
                }.start();
                return false;
            }
        }
        return false;
    }

    public boolean addDataSource(DataSource dataSource) {
        if (this.primaryX == null) {
            this.setPrimaryX(dataSource, true);
        } else {
            this.addPrimaryY(dataSource, true);
        }
        return true;
    }

    public boolean canAddDataSource(DataSource dataSource) {
        return true;
    }

    public void notificationEnd(Object object) {
        if (this.autopx) {
            this.pxvaluesOK = false;
        }
        if (this.autopy) {
            this.pyvaluesOK = false;
        }
        if (this.autosx) {
            this.sxvaluesOK = false;
        }
        if (this.autosy) {
            this.syvaluesOK = false;
        }
        if (this.primaryX != null) {
            try {
                this.primaryStartIndex = this.primaryX.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            try {
                this.primaryEndIndex = this.primaryX.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
        }
        if (this.secondaryX != null) {
            try {
                this.secondaryStartIndex = this.secondaryX.getStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
            try {
                this.secondaryEndIndex = this.secondaryX.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                // empty catch block
            }
        }
        this.isNotifying = false;
        super.notificationEnd(object);
        this.isNotifying = true;
        this.repaintDiagram(this.getBounds());
    }

    protected synchronized void notifyChange() {
        if (this.isNotifying) {
            super.notifyChange();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.primaryX);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.secondaryX);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        long l;
        long l2;
        objectInputStream.defaultReadObject();
        this.primaryX = DataSourcePool.global.readDataSource(objectInputStream);
        this.secondaryX = DataSourcePool.global.readDataSource(objectInputStream);
        this.zoomState = 0;
        this.zoomHistory = new Vector();
        if (this.isPrimaryBounded && this.primaryX != null) {
            try {
                l2 = this.primaryX.getStartIndex();
                l = this.primaryX.getLastIndex();
                if (l2 > this.primaryStartIndex) {
                    this.primaryStartIndex = l2;
                }
                if (l < this.primaryEndIndex) {
                    this.primaryEndIndex = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.isPrimaryBounded = false;
            }
        }
        if (this.isSecondaryBounded && this.secondaryX != null) {
            try {
                l2 = this.secondaryX.getStartIndex();
                l = this.secondaryX.getLastIndex();
                if (l2 > this.secondaryStartIndex) {
                    this.secondaryStartIndex = l2;
                }
                if (l < this.secondaryEndIndex) {
                    this.secondaryEndIndex = l;
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.isSecondaryBounded = false;
            }
        }
        this.isNotifying = true;
        for (int i = 0; i < 2; ++i) {
            Vector vector;
            Vector vector2 = vector = i == 0 ? this.primaryCurves : this.secondaryCurves;
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                CurveShape curveShape = (CurveShape)vector.get(j);
                PlotShape.Curve curve = this.getCurve(curveShape);
                if (curve != null) continue;
                System.err.print("Try to fix wrong curve shape ...");
                for (int k = 0; k < this._curves.size(); ++k) {
                    curve = (PlotShape.Curve)this._curves.get(k);
                    if (curve.shape.getXSource() != curveShape.getXSource() || curve.shape.getYSource() != curveShape.getYSource()) continue;
                    curve.shape = curveShape;
                    System.err.print(" OK");
                    break;
                }
                System.err.println("");
            }
        }
    }

    public JPropertiesPanel createPanel() {
        return new PlotPropertiesPanel(this.primaryCurves != null ? this.primaryCurves.size() : 0, this.secondaryCurves != null ? this.secondaryCurves.size() : 0);
    }

    public String[] getPropertyNames() {
        return PlotPropertiesPanel.getPropertyNames(this.primaryCurves != null ? this.primaryCurves.size() : 0, this.secondaryCurves != null ? this.secondaryCurves.size() : 0);
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        boolean bl = false;
        if (string.equalsIgnoreCase("PLOT_TITLE")) {
            if (object instanceof String) {
                this.setTitle((String)object);
            } else {
                this.setTitle(null);
            }
        } else if (string.equalsIgnoreCase("PLOT_LEGEND") && object instanceof Boolean) {
            this.setLegendVisible((Boolean)object);
        } else if (string.startsWith("PLOT_AXE_")) {
            String[] stringArray = new String[]{"primX", "primY", "secX", "secY"};
            for (int i = 0; i < stringArray.length; ++i) {
                double d;
                boolean bl2;
                if (!string.startsWith(AxePropertiesPanel.getPrefix(stringArray[i]))) continue;
                if (string.endsWith("_OK") && object instanceof Boolean) {
                    bl2 = (Boolean)object;
                    if (i == 0) {
                        this.pxvaluesOK = bl2;
                        continue;
                    }
                    if (i == 1) {
                        this.pyvaluesOK = bl2;
                        continue;
                    }
                    if (i == 2) {
                        this.sxvaluesOK = bl2;
                        continue;
                    }
                    this.syvaluesOK = bl2;
                    continue;
                }
                if (string.endsWith("_GRID") && object instanceof Boolean) {
                    bl2 = (Boolean)object;
                    if (i == 0 && this._asx1 != null) {
                        this._asx1.setWithGridlines(bl2);
                        continue;
                    }
                    if (i == 1 && this._asy1 != null) {
                        this._asy1.setWithGridlines(bl2);
                        continue;
                    }
                    if (i == 2 && this._asx2 != null) {
                        this._asx2.setWithGridlines(bl2);
                        continue;
                    }
                    if (this._asy2 == null) continue;
                    this._asy2.setWithGridlines(bl2);
                    continue;
                }
                if (string.endsWith("_AUTO") && object instanceof Boolean) {
                    bl2 = (Boolean)object;
                    if (i == 0) {
                        this.autopx = bl2;
                        continue;
                    }
                    if (i == 1) {
                        this.autopy = bl2;
                        continue;
                    }
                    if (i == 2) {
                        this.autosx = bl2;
                        continue;
                    }
                    this.autosy = bl2;
                    continue;
                }
                if (string.endsWith("_MIN") && object instanceof Double) {
                    d = (Double)object;
                    if (i == 0) {
                        this.pxmin = d;
                        continue;
                    }
                    if (i == 1) {
                        this.pymin = d;
                        continue;
                    }
                    if (i == 2) {
                        this.sxmin = d;
                        continue;
                    }
                    this.symin = d;
                    continue;
                }
                if (string.endsWith("_MAX") && object instanceof Double) {
                    d = (Double)object;
                    if (i == 0) {
                        this.pxmax = d;
                        continue;
                    }
                    if (i == 1) {
                        this.pymax = d;
                        continue;
                    }
                    if (i == 2) {
                        this.sxmax = d;
                        continue;
                    }
                    this.symax = d;
                    continue;
                }
                if (string.endsWith("_STEP") && object instanceof Double) {
                    d = (Double)object;
                    if (i == 0) {
                        this.pxstep = d;
                        continue;
                    }
                    if (i == 1) {
                        this.pystep = d;
                        continue;
                    }
                    if (i == 2) {
                        this.sxstep = d;
                        continue;
                    }
                    this.systep = d;
                    continue;
                }
                if (!string.endsWith("_LABEL")) continue;
                String string2 = object instanceof String ? (String)object : null;
                if (i == 0) {
                    this.pxlabel = string2;
                    continue;
                }
                if (i == 1) {
                    this.pylabel = string2;
                    continue;
                }
                if (i == 2) {
                    this.sxlabel = string2;
                    continue;
                }
                this.sylabel = string2;
            }
        } else {
            bl = string.startsWith(CurvePropertiesPanel.getPrefix("prim"));
            if (bl || string.startsWith(CurvePropertiesPanel.getPrefix("sec"))) {
                Vector vector;
                String string3 = bl ? "prim" : "sec";
                Vector vector2 = vector = bl ? this.primaryCurves : this.secondaryCurves;
                if (string.equalsIgnoreCase(CurvePropertiesPanel.getPrefix(string3) + "_LIST") && object instanceof Vector && !this.getCurveParameters(vector).equals(object)) {
                    this.setCurveParamters(bl, (Vector)object);
                }
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        boolean bl = false;
        if (string.equalsIgnoreCase("PLOT_TITLE")) {
            object = this.getTitle();
        } else if (string.equalsIgnoreCase("PLOT_LEGEND")) {
            object = new Boolean(this.isLegendVisible());
        } else if (string.startsWith("PLOT_AXE_")) {
            String[] stringArray = new String[]{"primX", "primY", "secX", "secY"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.startsWith(AxePropertiesPanel.getPrefix(stringArray[i]))) continue;
                if (string.endsWith("_OK")) {
                    if (i == 0) {
                        object = new Boolean(this.pxvaluesOK);
                        continue;
                    }
                    if (i == 1) {
                        object = new Boolean(this.pyvaluesOK);
                        continue;
                    }
                    if (i == 2) {
                        object = new Boolean(this.sxvaluesOK);
                        continue;
                    }
                    object = new Boolean(this.syvaluesOK);
                    continue;
                }
                if (string.endsWith("_GRID")) {
                    if (i == 0) {
                        object = new Boolean(this._asx1 != null ? this._asx1.isWithGridlines() : false);
                        continue;
                    }
                    if (i == 1) {
                        object = new Boolean(this._asy1 != null ? this._asy1.isWithGridlines() : false);
                        continue;
                    }
                    if (i == 2) {
                        object = new Boolean(this._asx2 != null ? this._asx2.isWithGridlines() : false);
                        continue;
                    }
                    object = new Boolean(this._asy2 != null ? this._asy2.isWithGridlines() : false);
                    continue;
                }
                if (string.endsWith("_AUTO")) {
                    if (i == 0) {
                        object = new Boolean(this.autopx);
                        continue;
                    }
                    if (i == 1) {
                        object = new Boolean(this.autopy);
                        continue;
                    }
                    if (i == 2) {
                        object = new Boolean(this.autosx);
                        continue;
                    }
                    object = new Boolean(this.autosy);
                    continue;
                }
                if (string.endsWith("_MIN")) {
                    if (i == 0) {
                        object = new Double(this.pxmin);
                        continue;
                    }
                    if (i == 1) {
                        object = new Double(this.pymin);
                        continue;
                    }
                    if (i == 2) {
                        object = new Double(this.sxmin);
                        continue;
                    }
                    object = new Double(this.symin);
                    continue;
                }
                if (string.endsWith("_MAX")) {
                    if (i == 0) {
                        object = new Double(this.pxmax);
                        continue;
                    }
                    if (i == 1) {
                        object = new Double(this.pymax);
                        continue;
                    }
                    if (i == 2) {
                        object = new Double(this.sxmax);
                        continue;
                    }
                    object = new Double(this.symax);
                    continue;
                }
                if (string.endsWith("_STEP")) {
                    if (i == 0) {
                        object = new Double(this.pxstep);
                        continue;
                    }
                    if (i == 1) {
                        object = new Double(this.pystep);
                        continue;
                    }
                    if (i == 2) {
                        object = new Double(this.sxstep);
                        continue;
                    }
                    object = new Double(this.systep);
                    continue;
                }
                if (!string.endsWith("_LABEL")) continue;
                object = i == 0 ? this.pxlabel : (i == 1 ? this.pylabel : (i == 2 ? this.sxlabel : this.sylabel));
            }
        } else {
            bl = string.startsWith(CurvePropertiesPanel.getPrefix("prim"));
            if (bl || string.startsWith(CurvePropertiesPanel.getPrefix("sec"))) {
                Vector vector;
                String string2 = bl ? "prim" : "sec";
                Vector vector2 = vector = bl ? this.primaryCurves : this.secondaryCurves;
                if (string.equalsIgnoreCase(CurvePropertiesPanel.getPrefix(string2) + "_LIST")) {
                    object = this.getCurveParameters(vector);
                }
            }
        }
        return object;
    }

    protected Vector getCurveParameters(Vector vector) {
        Vector<CurvePropertiesPanel.CurveParameters> vector2 = new Vector<CurvePropertiesPanel.CurveParameters>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CurveShape curveShape = (CurveShape)vector.get(i);
                PlotShape.Curve curve = this.getCurve(curveShape);
                CurvePropertiesPanel.CurveParameters curveParameters = new CurvePropertiesPanel.CurveParameters();
                curveParameters.xds = curveShape.getXSource();
                curveParameters.yds = curveShape.getYSource();
                curveParameters.points = curve.showPoints;
                curveParameters.dashes = new CurvePropertiesPanel.DashParameters(curve.dashParam1, curve.dashParam2);
                curveParameters.color = curve.color;
                vector2.add(curveParameters);
            }
        }
        return vector2;
    }

    protected void setCurveParamters(boolean bl, Vector vector) {
        Iterator iterator = this._curves.iterator();
        while (iterator.hasNext()) {
            PlotShape.Curve curve = (PlotShape.Curve)iterator.next();
            if (curve.secondaryYaxis != !bl) continue;
            iterator.remove();
        }
        if (bl) {
            this.primaryCurves = null;
        } else {
            this.secondaryCurves = null;
        }
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            CurveShape curveShape;
            CurvePropertiesPanel.CurveParameters curveParameters = (CurvePropertiesPanel.CurveParameters)vector.get(i);
            if (i == 0 && !bl && this.primaryCurves != null && this.primaryCurves.size() > 0 && (curveShape = (CurveShape)this.primaryCurves.get(0)).getXSource() == curveParameters.xds) {
                bl2 = true;
            }
            this.doAddYAction(new Object[]{curveParameters.yds, new Boolean(bl), new Boolean(bl | bl2)});
            curveShape = (CurveShape)(bl ? this.primaryCurves.get(i) : this.secondaryCurves.get(i));
            PlotShape.Curve curve = this.getCurve(curveShape);
            curve.setShowPoints(curveParameters.points);
            curve.setDashParameters(curveParameters.dashes.param1, curveParameters.dashes.param2);
            curve.color = curveParameters.color;
        }
    }

    static {
        try {
            resources = (MenuResourceBundle)ResourceBundle.getBundle("jsynoptic.builtin.resources.PlotResources", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load Plot resources");
            System.exit(0);
        }
        defaultPalette = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.cyan, Color.orange, Color.pink, Color.black, Color.yellow};
    }
}

