/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.ui.ImagePropertiesPanel;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.BasicMessageWriter;
import simtools.ui.ImageMapper;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;
import simtools.util.ImageSerializer;

public class ImageShape
extends Abstract1DShape {
    static final long serialVersionUID = 8701487979765549739L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImageShape.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImageShape.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    protected transient BufferedImage image;
    protected transient BufferedImage dynamicImage = null;
    protected ImageMapper mapper;
    protected transient DataSource source;
    protected transient long index;
    protected transient boolean dirtyImage = false;
    protected File currentFile = null;
    protected boolean autoFit;
    static /* synthetic */ Class class$jsynoptic$builtin$ImageShape;

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean bl) {
        this.autoFit = bl;
    }

    public ImageShape(File file, int n, int n2) {
        super(n, n2, 100, 100);
        try {
            this.image = ImageIO.read(file);
            this._w = this.image.getWidth();
            this._h = this.image.getHeight();
        }
        catch (IOException iOException) {
            this.image = null;
        }
        this.autoFit = false;
    }

    public ImageShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.image = null;
    }

    protected Shape getDelegateShape() {
        return new Rectangle(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
    }

    protected AbstractShape cloneShape() {
        try {
            ImageShape imageShape = (ImageShape)super.clone();
            if (imageShape.source != null) {
                imageShape.source.addListener(imageShape);
                imageShape.source.addEndNotificationListener(imageShape);
            }
            return imageShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
        BufferedImage bufferedImage;
        if (bl) {
            return;
        }
        BufferedImage bufferedImage2 = bufferedImage = this.dynamicImage != null ? this.dynamicImage : this.image;
        if (bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, this._ox, this._oy - this._h, this._w, this._h, null);
        }
    }

    public JPropertiesPanel createPanel() {
        return new ImagePropertiesPanel();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyImage) {
            ImageMapper.ImageFile imageFile;
            boolean bl = false;
            Object object2 = null;
            if (this.mapper != null && (imageFile = (ImageMapper.ImageFile)this.mapper.getMapping(this.source, this.index)) != null) {
                object2 = imageFile.image;
            }
            bl = object2 == null ? this.dynamicImage != null : !object2.equals(this.dynamicImage);
            this.dynamicImage = object2;
            if (bl) {
                int n = this._w;
                int n2 = this._h;
                if (!this.autoFit) {
                    if (this.dynamicImage != null) {
                        this._w = this.dynamicImage.getWidth();
                        this._h = this.dynamicImage.getHeight();
                    } else if (this.image != null) {
                        this._w = this.image.getWidth();
                        this._h = this.image.getHeight();
                    }
                    n = Math.max(n, this._w);
                    n2 = Math.max(n2, this._h);
                }
                this.dirtyRectangle = new Rectangle(this._ox, this._oy - n2, n, n2);
                this.dirty = true;
            }
            this.dirtyImage = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source)) {
            this.index = l2;
            this.dirtyImage = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source) && this.index >= l && this.index <= l2) {
            this.dirtyImage = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
        ImageSerializer.write(objectOutputStream, this.image);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ImageMapper.ImageFile imageFile;
        objectInputStream.defaultReadObject();
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        this.image = ImageSerializer.read(objectInputStream);
        if (this.source != null) {
            try {
                this.source.addListener(this);
                this.source.addEndNotificationListener(this);
                this.index = this.source.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.index = 0L;
            }
        }
        if (this.mapper != null && (imageFile = (ImageMapper.ImageFile)this.mapper.getMapping(this.source, this.index)) != null) {
            this.dynamicImage = imageFile.image;
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("IMAGE_FIT_TO_OBJECT")) {
            object = new Boolean(this.autoFit);
        } else if (string.equalsIgnoreCase("IMAGE_FILE")) {
            object = this.currentFile;
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER")) {
            object = this.mapper;
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER_SOURCE")) {
            object = this.source;
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (this.source != null) {
            this.source.removeEndNotificationListener(this);
            this.source.removeListener(this);
        }
        if (string.equalsIgnoreCase("IMAGE_FIT_TO_OBJECT")) {
            if (object instanceof Boolean) {
                this.autoFit = (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("IMAGE_FILE")) {
            if (object instanceof File) {
                this.currentFile = (File)object;
                try {
                    this.image = ImageIO.read(this.currentFile);
                }
                catch (IOException iOException) {
                    this.image = null;
                }
            } else {
                this.currentFile = null;
                this.image = null;
            }
            this.dirty = true;
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER")) {
            this.mapper = object instanceof ImageMapper ? (ImageMapper)object : null;
        } else if (string.equalsIgnoreCase("IMAGE_MAPPER_SOURCE")) {
            if (this.source != null) {
                this.source.removeListener(this);
                this.source.removeEndNotificationListener(this);
            }
            if (object instanceof DataSource) {
                this.source = (DataSource)object;
                try {
                    this.index = this.source.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.index = 0L;
                }
                this.source.addListener(this);
                this.source.addEndNotificationListener(this);
            } else {
                this.source = null;
            }
            this.dynamicImage = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

