/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.Linkable;
import jsynoptic.builtin.ui.PropertiesPanel1D;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.ShapesContainer;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;
import simtools.util.NamedProperties;

public abstract class Abstract1DShape
extends AbstractShape
implements Resizable,
DataSourceListener,
EndNotificationListener,
ContextualActionProvider,
Linkable {
    static final long serialVersionUID = 1292256994785217201L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$Abstract1DShape == null ? (class$jsynoptic$builtin$Abstract1DShape = Abstract1DShape.class$("jsynoptic.builtin.Abstract1DShape")) : class$jsynoptic$builtin$Abstract1DShape);
    public static int MIN_SIZE = 20;
    protected Color drawColor = Color.black;
    protected transient Color drawDynamicColor = null;
    protected ColorMapper drawMapper;
    protected transient DataSource drawMapperSource;
    protected transient long drawMapperIndex;
    protected boolean allowResize;
    protected boolean fixedRatio;
    protected double ratio;
    protected String link;
    protected transient boolean dirtyDrawColor = false;
    protected transient boolean dirty = false;
    protected transient Rectangle dirtyRectangle = null;
    private transient NamedProperties properties = null;
    static /* synthetic */ Class class$jsynoptic$builtin$Abstract1DShape;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public Abstract1DShape(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._w = n3;
        this._h = n4;
    }

    protected AbstractShape cloneShape() {
        try {
            Abstract1DShape abstract1DShape = (Abstract1DShape)super.clone();
            if (abstract1DShape.drawMapperSource != null) {
                abstract1DShape.drawMapperSource.addListener(abstract1DShape);
                abstract1DShape.drawMapperSource.addEndNotificationListener(abstract1DShape);
            }
            return abstract1DShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected abstract Shape getDelegateShape();

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.getDelegateShape().getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getDelegateShape().getPathIterator(affineTransform, d);
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
    }

    public void draw(Graphics2D graphics2D) {
        Color color;
        Color color2 = graphics2D.getColor();
        Color color3 = graphics2D.getBackground();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AbstractShape.ANTI_ALIASING ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawHook(graphics2D, false);
        Color color4 = color = this.drawDynamicColor != null ? this.drawDynamicColor : this.drawColor;
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.draw(this.getDelegateShape());
        }
        this.drawHook(graphics2D, true);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setBackground(color3);
        graphics2D.setColor(color2);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("properties"));
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("properties"))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    CompoundEdit compoundEdit;
                    JPropertiesPanel jPropertiesPanel = Abstract1DShape.this.createPanel();
                    jPropertiesPanel.setProperties(Abstract1DShape.this);
                    int n = JOptionPane.showConfirmDialog(null, jPropertiesPanel, resources.getString("propertiesTitle"), 2, -1);
                    if (n == 0 && Abstract1DShape.this.setProperties(jPropertiesPanel, compoundEdit = new CompoundEdit())) {
                        compoundEdit.end();
                        ShapesContainer.ShapesComponent shapesComponent = (ShapesContainer.ShapesComponent)JSynoptic.gui.getActiveDiagram();
                        shapesComponent.fireUndoableEditUpdate(new UndoableEditEvent(shapesComponent, compoundEdit));
                        shapesComponent.repaint();
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public JPropertiesPanel createPanel() {
        return new PropertiesPanel1D();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyDrawColor) {
            this.dirtyDrawColor = false;
            Color color = null;
            if (this.drawMapper != null) {
                color = (Color)this.drawMapper.getPaint(this.drawMapperSource, this.drawMapperIndex);
            }
            this.dirtyDrawColor = color == null ? this.drawDynamicColor != null : !color.equals(this.drawDynamicColor);
            this.drawDynamicColor = color;
            this.dirty |= this.dirtyDrawColor;
            this.dirtyDrawColor = false;
        }
        if (this.dirty) {
            this.notifyChange(this.dirtyRectangle);
            this.dirtyRectangle = null;
            this.dirty = false;
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.drawMapperSource)) {
            this.drawMapperIndex = l2;
            this.dirtyDrawColor = true;
        }
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.drawMapperSource)) {
            if (this.drawMapperIndex < l || this.drawMapperIndex > l2) {
                return;
            }
            this.dirtyDrawColor = true;
        }
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void resize(int n, int n2) {
        if (!this.allowResize) {
            return;
        }
        if (!this.fixedRatio) {
            this._w += n;
            this._h += n2;
            if (this._w < MIN_SIZE) {
                this._w = MIN_SIZE;
            }
            if (this._h < MIN_SIZE) {
                this._h = MIN_SIZE;
            }
            return;
        }
        this._w += n;
        this._h += n2;
        double d = Math.max((double)this._w, (double)this._h * this.ratio);
        this._w = (int)d;
        this._h = (int)(d / this.ratio);
        if (this._w < MIN_SIZE) {
            this._w = MIN_SIZE;
        }
        if (this._h < MIN_SIZE) {
            this._h = MIN_SIZE;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.drawMapperSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.drawMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.drawMapperSource != null) {
            try {
                this.drawMapperSource.addListener(this);
                this.drawMapperSource.addEndNotificationListener(this);
                this.drawMapperIndex = this.drawMapperSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.drawMapperIndex = 0L;
            }
        }
        this.drawDynamicColor = this.drawMapper != null ? (Color)this.drawMapper.getPaint(this.drawMapperSource, this.drawMapperIndex) : null;
    }

    public String[] getPropertyNames() {
        if (this.properties == null) {
            this.properties = this.createPanel();
        }
        return this.properties.getPropertyNames();
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("STROKE_COLOR")) {
            this.drawColor = object instanceof Color ? (Color)object : null;
        } else if (string.equalsIgnoreCase("ALLOW_RESIZE")) {
            if (object instanceof Boolean) {
                this.allowResize = (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("FIXED_RATIO")) {
            if (object instanceof Boolean) {
                this.fixedRatio = (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("WIDTH")) {
            if (object instanceof Integer) {
                this._w = (Integer)object;
            }
        } else if (string.equalsIgnoreCase("HEIGHT")) {
            if (object instanceof Integer) {
                this._h = (Integer)object;
            }
        } else if (string.equalsIgnoreCase("DRAW_MAPPER")) {
            this.drawMapper = object instanceof ColorMapper ? (ColorMapper)object : null;
        } else if (string.equalsIgnoreCase("DRAW_MAPPER_SOURCE")) {
            if (this.drawMapperSource != null) {
                this.drawMapperSource.removeListener(this);
                this.drawMapperSource.removeEndNotificationListener(this);
            }
            if (object instanceof DataSource) {
                this.drawMapperSource = (DataSource)object;
                try {
                    this.drawMapperIndex = this.drawMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.drawMapperIndex = 0L;
                }
                this.drawMapperSource.addListener(this);
                this.drawMapperSource.addEndNotificationListener(this);
            } else {
                this.drawMapperSource = null;
            }
            this.drawDynamicColor = null;
        }
        this.notifyChange(null);
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("STROKE_COLOR")) {
            object = this.drawColor;
        } else if (string.equalsIgnoreCase("ALLOW_RESIZE")) {
            object = new Boolean(this.allowResize);
        } else if (string.equalsIgnoreCase("FIXED_RATIO")) {
            object = new Boolean(this.fixedRatio);
        } else if (string.equalsIgnoreCase("WIDTH")) {
            object = new Integer(this._w);
        } else if (string.equalsIgnoreCase("HEIGHT")) {
            object = new Integer(this._h);
        } else if (string.equalsIgnoreCase("DRAW_MAPPER")) {
            object = this.drawMapper;
        } else if (string.equalsIgnoreCase("DRAW_MAPPER_SOURCE")) {
            object = this.drawMapperSource;
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

