/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.plugins.jfreechart.ChartShape;
import jsynoptic.plugins.jfreechart.DatasetDelegatedMeterPlot;
import jsynoptic.plugins.jfreechart.SourceMeterDataset;
import jsynoptic.plugins.jfreechart.StandardPlotShape;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.data.Range;
import simtools.data.DataSource;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionCheckBox;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class MeterShape
extends ChartShape
implements ContextualActionProvider {
    static final long serialVersionUID = -8566344700538941237L;
    public static ResourceBundle resources = ResourceFinder.get((Class)(class$jsynoptic$plugins$jfreechart$MeterShape == null ? (class$jsynoptic$plugins$jfreechart$MeterShape = MeterShape.class$("jsynoptic.plugins.jfreechart.MeterShape")) : class$jsynoptic$plugins$jfreechart$MeterShape), (ResourceBundle)StandardPlotShape.resources);
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$MeterShape;

    public MeterShape(JFreeChart jFreeChart) {
        this(jFreeChart, 0, 0, 200, 200);
    }

    public MeterShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(jFreeChart, n, n2, n3, n4);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        if (object instanceof DataSource) {
            vector.add(resources.getString("SetSource"));
        }
        if (vector.size() == 0) {
            JSynoptic.setStatus((String)resources.getString("noSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    int n;
                    ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(MeterShape.this.chart);
                    JTabbedPane jTabbedPane = MeterShape.this.findTab((Container)chartPropertyEditPanel);
                    BoundsPanel boundsPanel = null;
                    if (jTabbedPane != null) {
                        boundsPanel = new BoundsPanel();
                        jTabbedPane.add((Component)boundsPanel, 0);
                    }
                    if ((n = JOptionPane.showConfirmDialog(null, chartPropertyEditPanel, resources.getString("ChartProperties"), 2, -1)) == 0) {
                        chartPropertyEditPanel.updateChartProperties(MeterShape.this.chart);
                        if (boundsPanel != null) {
                            boundsPanel.updateChartProperties();
                        }
                    }
                    MeterShape.this.notifyChange();
                }
            }.start();
            return true;
        }
        if (string.equals(resources.getString("SetSource"))) {
            try {
                MeterPlot meterPlot = (MeterPlot)this.chart.getPlot();
                SourceMeterDataset sourceMeterDataset = (SourceMeterDataset)meterPlot.getDataset();
                sourceMeterDataset.setSource((DataSource)object);
                this.chart.setTitle(sourceMeterDataset.getName());
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSource"));
            }
        }
        return true;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    protected AbstractShape cloneShape() {
        ChartShape chartShape = (ChartShape)super.cloneShape();
        DatasetDelegatedMeterPlot datasetDelegatedMeterPlot = (DatasetDelegatedMeterPlot)this.chart.getPlot();
        SourceMeterDataset sourceMeterDataset = (SourceMeterDataset)datasetDelegatedMeterPlot.getDataset();
        ((DatasetDelegatedMeterPlot)chartShape.chart.getPlot()).setDataset(sourceMeterDataset.cloneSet());
        return chartShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class BoundsPanel
    extends JPanel {
        ActionCheckBox cbautorange;
        ActionCheckBox cbnrange;
        ActionCheckBox cbwrange;
        ActionCheckBox cbcrange;
        NumberField tfrangemin;
        NumberField tfrangemax;
        NumberField tfnrangemin;
        NumberField tfnrangemax;
        NumberField tfwrangemin;
        NumberField tfwrangemax;
        NumberField tfcrangemin;
        NumberField tfcrangemax;
        JLabel lrangemin;
        JLabel lrangemax;
        JLabel lnrangemin;
        JLabel lnrangemax;
        JLabel lwrangemin;
        JLabel lwrangemax;
        JLabel lcrangemin;
        JLabel lcrangemax;
        JTextField tfTitle;

        public BoundsPanel() {
            this.setLayout(new BoxLayout(this, 3));
            Box box = new Box(1);
            this.setName(resources.getString("Properties"));
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("PlotTitle:")));
            this.tfTitle = new JTextField();
            box2.add(this.tfTitle);
            this.tfTitle.setText(MeterShape.this.chart.getTitle().getText());
            box.add(box2);
            DatasetDelegatedMeterPlot datasetDelegatedMeterPlot = (DatasetDelegatedMeterPlot)MeterShape.this.chart.getPlot();
            SourceMeterDataset sourceMeterDataset = (SourceMeterDataset)datasetDelegatedMeterPlot.getDataset();
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("OverallRange")));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbautorange = new ActionCheckBox(this, resources.getString("Auto-update"), datasetDelegatedMeterPlot.isAutorange()){
                private final /* synthetic */ BoundsPanel this$1;
                {
                    this.this$1 = boundsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.lrangemin.setEnabled(!this.isSelected());
                    this.this$1.lrangemax.setEnabled(!this.isSelected());
                    this.this$1.tfrangemin.setEnabled(!this.isSelected());
                    this.this$1.tfrangemax.setEnabled(!this.isSelected());
                }
            };
            jPanel.add((Component)this.cbautorange);
            this.lrangemin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lrangemin);
            this.tfrangemin = new NumberField(10);
            jPanel.add((Component)this.tfrangemin);
            this.tfrangemin.setValue(datasetDelegatedMeterPlot.getRange().getLowerBound());
            this.lrangemax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lrangemax);
            this.tfrangemax = new NumberField(10);
            jPanel.add((Component)this.tfrangemax);
            this.tfrangemax.setValue(datasetDelegatedMeterPlot.getRange().getUpperBound());
            box2.add(jPanel);
            this.cbautorange.apply();
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("'Normal'Range")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbnrange = new ActionCheckBox(this, resources.getString("Enable"), datasetDelegatedMeterPlot.getNormalRange() != null){
                private final /* synthetic */ BoundsPanel this$1;
                {
                    this.this$1 = boundsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.lnrangemin.setEnabled(this.isSelected());
                    this.this$1.lnrangemax.setEnabled(this.isSelected());
                    this.this$1.tfnrangemin.setEnabled(this.isSelected());
                    this.this$1.tfnrangemax.setEnabled(this.isSelected());
                }
            };
            jPanel.add((Component)this.cbnrange);
            this.lnrangemin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lnrangemin);
            this.tfnrangemin = new NumberField(10);
            jPanel.add((Component)this.tfnrangemin);
            if (datasetDelegatedMeterPlot.getNormalRange() != null) {
                this.tfnrangemin.setValue(datasetDelegatedMeterPlot.getNormalRange().getLowerBound());
            }
            this.lnrangemax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lnrangemax);
            this.tfnrangemax = new NumberField(10);
            jPanel.add((Component)this.tfnrangemax);
            if (datasetDelegatedMeterPlot.getNormalRange() != null) {
                this.tfnrangemax.setValue(datasetDelegatedMeterPlot.getNormalRange().getUpperBound());
            }
            box2.add(jPanel);
            this.cbnrange.apply();
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("'Warning'Range")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbwrange = new ActionCheckBox(this, resources.getString("Enable"), datasetDelegatedMeterPlot.getWarningRange() != null){
                private final /* synthetic */ BoundsPanel this$1;
                {
                    this.this$1 = boundsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.lwrangemin.setEnabled(this.isSelected());
                    this.this$1.lwrangemax.setEnabled(this.isSelected());
                    this.this$1.tfwrangemin.setEnabled(this.isSelected());
                    this.this$1.tfwrangemax.setEnabled(this.isSelected());
                }
            };
            jPanel.add((Component)this.cbwrange);
            this.lwrangemin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lwrangemin);
            this.tfwrangemin = new NumberField(10);
            jPanel.add((Component)this.tfwrangemin);
            if (datasetDelegatedMeterPlot.getWarningRange() != null) {
                this.tfwrangemin.setValue(datasetDelegatedMeterPlot.getWarningRange().getLowerBound());
            }
            this.lwrangemax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lwrangemax);
            this.tfwrangemax = new NumberField(10);
            jPanel.add((Component)this.tfwrangemax);
            if (datasetDelegatedMeterPlot.getWarningRange() != null) {
                this.tfwrangemax.setValue(datasetDelegatedMeterPlot.getWarningRange().getUpperBound());
            }
            box2.add(jPanel);
            this.cbwrange.apply();
            box.add(box2);
            box2 = new Box(1);
            box2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("'Critical'Range")));
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0));
            this.cbcrange = new ActionCheckBox(this, resources.getString("Enable"), datasetDelegatedMeterPlot.getCriticalRange() != null){
                private final /* synthetic */ BoundsPanel this$1;
                {
                    this.this$1 = boundsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.lcrangemin.setEnabled(this.isSelected());
                    this.this$1.lcrangemax.setEnabled(this.isSelected());
                    this.this$1.tfcrangemin.setEnabled(this.isSelected());
                    this.this$1.tfcrangemax.setEnabled(this.isSelected());
                }
            };
            jPanel.add((Component)this.cbcrange);
            this.lcrangemin = new JLabel(resources.getString("minLabel"));
            jPanel.add(this.lcrangemin);
            this.tfcrangemin = new NumberField(10);
            jPanel.add((Component)this.tfcrangemin);
            if (datasetDelegatedMeterPlot.getCriticalRange() != null) {
                this.tfcrangemin.setValue(datasetDelegatedMeterPlot.getCriticalRange().getLowerBound());
            }
            this.lcrangemax = new JLabel(resources.getString("maxLabel"));
            jPanel.add(this.lcrangemax);
            this.tfcrangemax = new NumberField(10);
            jPanel.add((Component)this.tfcrangemax);
            if (datasetDelegatedMeterPlot.getCriticalRange() != null) {
                this.tfcrangemax.setValue(datasetDelegatedMeterPlot.getCriticalRange().getUpperBound());
            }
            box2.add(jPanel);
            this.cbcrange.apply();
            box.add(box2);
            this.add(box);
        }

        protected void updateChartProperties() {
            MeterShape.this.chart.setTitle(this.tfTitle.getText());
            DatasetDelegatedMeterPlot datasetDelegatedMeterPlot = (DatasetDelegatedMeterPlot)MeterShape.this.chart.getPlot();
            SourceMeterDataset sourceMeterDataset = (SourceMeterDataset)datasetDelegatedMeterPlot.getDataset();
            datasetDelegatedMeterPlot.setAutorange(this.cbautorange.isSelected());
            if (this.tfrangemin.isEnabled() && this.tfrangemax.isEnabled()) {
                datasetDelegatedMeterPlot.setRange(new Range(this.tfrangemin.getDoubleValue(), this.tfrangemax.getDoubleValue()));
            }
            if (this.tfnrangemin.isEnabled() && this.tfnrangemax.isEnabled()) {
                datasetDelegatedMeterPlot.setNormalRange(new Range(this.tfnrangemin.getDoubleValue(), this.tfnrangemax.getDoubleValue()));
            } else {
                datasetDelegatedMeterPlot.setNormalRange(null);
            }
            if (this.tfwrangemin.isEnabled() && this.tfwrangemax.isEnabled()) {
                datasetDelegatedMeterPlot.setWarningRange(new Range(this.tfwrangemin.getDoubleValue(), this.tfwrangemax.getDoubleValue()));
            } else {
                datasetDelegatedMeterPlot.setWarningRange(null);
            }
            if (this.tfcrangemin.isEnabled() && this.tfcrangemax.isEnabled()) {
                datasetDelegatedMeterPlot.setCriticalRange(new Range(this.tfcrangemin.getDoubleValue(), this.tfcrangemax.getDoubleValue()));
            } else {
                datasetDelegatedMeterPlot.setCriticalRange(null);
            }
        }
    }
}

