/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class SignJar
extends Task {
    protected File jar;
    protected String alias;
    protected File keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected File sigfile;
    protected File signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;
    protected Vector filesets = new Vector();
    protected boolean lazy;

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeystore(File keystore) {
        this.keystore = keystore;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setSigfile(File sigfile) {
        this.sigfile = sigfile;
    }

    public void setSignedjar(File signedjar) {
        this.signedjar = signedjar;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setInternalsf(boolean internalsf) {
        this.internalsf = internalsf;
    }

    public void setSectionsonly(boolean sectionsonly) {
        this.sectionsonly = sectionsonly;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        if (null == this.jar && null == this.filesets) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (null != this.jar) {
            this.doOneJar(this.jar, this.signedjar);
            return;
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] jarFiles = ds.getIncludedFiles();
            int j = 0;
            while (j < jarFiles.length) {
                this.doOneJar(new File(fs.getDir(this.project), jarFiles[j]), null);
                ++j;
            }
            ++i;
        }
    }

    private void doOneJar(File jarSource, File jarTarget) throws BuildException {
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (null == this.alias) {
            throw new BuildException("alias attribute must be set");
        }
        if (null == this.storepass) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate(jarSource, jarTarget)) {
            return;
        }
        ExecTask cmd = (ExecTask)this.project.createTask("exec");
        cmd.setExecutable("jarsigner");
        if (null != this.keystore) {
            cmd.createArg().setValue("-keystore");
            cmd.createArg().setValue(this.keystore.toString());
        }
        if (null != this.storepass) {
            cmd.createArg().setValue("-storepass");
            cmd.createArg().setValue(this.storepass);
        }
        if (null != this.storetype) {
            cmd.createArg().setValue("-storetype");
            cmd.createArg().setValue(this.storetype);
        }
        if (null != this.keypass) {
            cmd.createArg().setValue("-keypass");
            cmd.createArg().setValue(this.keypass);
        }
        if (null != this.sigfile) {
            cmd.createArg().setValue("-sigfile");
            cmd.createArg().setValue(this.sigfile.toString());
        }
        if (null != jarTarget) {
            cmd.createArg().setValue("-signedjar");
            cmd.createArg().setValue(jarTarget.toString());
        }
        if (this.verbose) {
            cmd.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            cmd.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            cmd.createArg().setValue("-sectionsonly");
        }
        cmd.createArg().setValue(jarSource.toString());
        cmd.createArg().setValue(this.alias);
        this.log("Signing Jar : " + jarSource.getAbsolutePath());
        cmd.setFailonerror(true);
        cmd.setTaskName(this.getTaskName());
        cmd.execute();
    }

    protected boolean isUpToDate(File jarFile, File signedjarFile) {
        if (null == jarFile) {
            return false;
        }
        if (null != signedjarFile) {
            if (!jarFile.exists()) {
                return false;
            }
            if (!signedjarFile.exists()) {
                return false;
            }
            if (jarFile.equals(signedjarFile)) {
                return false;
            }
            if (signedjarFile.lastModified() > jarFile.lastModified()) {
                return true;
            }
        } else if (this.lazy) {
            return this.isSigned(jarFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(File file) {
        SIG_START = "META-INF/";
        SIG_END = ".SF";
        if (!file.exists()) {
            return false;
        }
        jarFile = null;
        try {
            try {
                jarFile = new ZipFile(file);
                if (null == this.alias) {
                    block13: {
                        entries = jarFile.entries();
                        do {
                            if (!entries.hasMoreElements()) break block13;
                        } while (!(name = entries.nextElement().getName()).startsWith("META-INF/") || !name.endsWith(".SF"));
                        var7_11 = true;
                        var9_12 = null;
                        if (jarFile == null) return var7_11;
                        try {
                            jarFile.close();
                            return var7_11;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var7_11;
                    }
                    var6_9 = false;
                    var9_13 = null;
                    if (jarFile == null) return var6_9;
                    ** try [egrp 2[TRYBLOCK] [6 : 186->194)] { 
lbl30:
                    // 1 sources

                    jarFile.close();
                    return var6_9;
lbl32:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return var6_9;
                }
                entries = jarFile.getEntry("META-INF/" + this.alias.toUpperCase() + ".SF") != null;
            }
            catch (IOException e) {
                var6_10 = false;
                var9_15 = null;
                if (jarFile == null) return var6_10;
                ** try [egrp 2[TRYBLOCK] [6 : 186->194)] { 
lbl44:
                // 1 sources

                jarFile.close();
                return var6_10;
lbl46:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var6_10;
            }
        }
        catch (Throwable var8_22) {
            var9_16 = null;
            if (jarFile == null) throw var8_22;
            try {}
            catch (IOException e) {
                throw var8_22;
            }
            jarFile.close();
            throw var8_22;
        }
        var9_14 = null;
        if (jarFile == null) return entries;
        ** try [egrp 2[TRYBLOCK] [6 : 186->194)] { 
lbl62:
        // 1 sources

        jarFile.close();
        return entries;
lbl64:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return entries;
    }
}

