/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class TailFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final String LINES_KEY = "lines";
    private long linesRead = 0L;
    private long lines = 10L;
    private char[] buffer = new char[4096];
    private int returnedCharPos = -1;
    private boolean completedReadAhead = false;
    private int bufferPos = 0;

    public TailFilter() {
    }

    public TailFilter(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        if (!this.completedReadAhead) {
            int ch = -1;
            while ((ch = this.in.read()) != -1) {
                if (this.buffer.length == this.bufferPos) {
                    if (this.returnedCharPos != -1) {
                        char[] tmpBuffer = new char[this.buffer.length];
                        System.arraycopy(this.buffer, this.returnedCharPos + 1, tmpBuffer, 0, this.buffer.length - (this.returnedCharPos + 1));
                        this.buffer = tmpBuffer;
                        this.bufferPos -= this.returnedCharPos + 1;
                        this.returnedCharPos = -1;
                    } else {
                        char[] tmpBuffer = new char[this.buffer.length * 2];
                        System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.bufferPos);
                        this.buffer = tmpBuffer;
                    }
                }
                if (ch == 10 || ch == -1) {
                    ++this.linesRead;
                    if (this.linesRead == this.lines) {
                        int i = 0;
                        i = this.returnedCharPos + 1;
                        while (this.buffer[i] != '\u0000' && this.buffer[i] != '\n') {
                            ++i;
                        }
                        this.returnedCharPos = i;
                        --this.linesRead;
                    }
                }
                if (ch == -1) break;
                this.buffer[this.bufferPos] = (char)ch;
                ++this.bufferPos;
            }
            this.completedReadAhead = true;
        }
        ++this.returnedCharPos;
        if (this.returnedCharPos >= this.bufferPos) {
            return -1;
        }
        return this.buffer[this.returnedCharPos];
    }

    public final void setLines(long lines) {
        this.lines = lines;
    }

    private final long getLines() {
        return this.lines;
    }

    public final Reader chain(Reader rdr) {
        TailFilter newFilter = new TailFilter(rdr);
        newFilter.setLines(this.getLines());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (LINES_KEY.equals(params[i].getName())) {
                    this.setLines(new Long(params[i].getValue()));
                    break;
                }
                ++i;
            }
        }
    }

    static {
        LINES_KEY = LINES_KEY;
    }
}

