/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.util.Stack;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParseException;

public class StdXMLBuilder
implements IXMLBuilder {
    private Stack stack = null;
    private XMLElement root = null;

    protected void finalize() throws Throwable {
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    public void startBuilding(String systemID, int lineNr) {
        this.stack = new Stack();
        this.root = null;
    }

    public void newProcessingInstruction(String target, Reader reader) {
    }

    public void startElement(String name, String nsPrefix, String nsSystemID, String systemID, int lineNr) {
        XMLElement elt = new XMLElement(name, systemID, lineNr);
        if (this.stack.empty()) {
            this.root = elt;
        } else {
            XMLElement top = (XMLElement)this.stack.peek();
            top.addChild(elt);
        }
        this.stack.push(elt);
    }

    public void elementAttributesProcessed(String name, String nsPrefix, String nsSystemID) {
    }

    public void endElement(String name, String nsPrefix, String nsSystemID) {
        XMLElement child;
        XMLElement elt = (XMLElement)this.stack.pop();
        if (elt.getChildrenCount() == 1 && (child = elt.getChildAtIndex(0)).getName() == null) {
            elt.setContent(child.getContent());
            elt.removeChildAtIndex(0);
        }
    }

    public void addAttribute(String key, String nsPrefix, String nsSystemID, String value, String type) throws Exception {
        XMLElement top = (XMLElement)this.stack.peek();
        if (top.hasAttribute(key)) {
            throw new XMLParseException(top.getSystemID(), top.getLineNr(), "Duplicate attribute: " + key);
        }
        top.setAttribute(key, value);
    }

    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        int bufSize = 2048;
        int sizeRead = 0;
        StringBuffer str = new StringBuffer(bufSize);
        char[] buf = new char[bufSize];
        while (true) {
            int size;
            if (sizeRead >= bufSize) {
                str.ensureCapacity(bufSize *= 2);
            }
            if ((size = reader.read(buf)) < 0) break;
            str.append(buf, 0, size);
            sizeRead += size;
        }
        XMLElement elt = new XMLElement(null, systemID, lineNr);
        elt.setContent(str.toString());
        if (!this.stack.empty()) {
            XMLElement top = (XMLElement)this.stack.peek();
            top.addChild(elt);
        }
    }

    public Object getResult() {
        return this.root;
    }
}

