/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.PackagerListener;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class IzPackTask
extends Task
implements PackagerListener {
    private String input = null;
    private String basedir = null;
    private String output = null;
    private InstallerType installerType = null;
    private String izPackDir = null;

    public void packagerMsg(String str) {
        this.log(str);
    }

    public void packagerStart() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_starting"), 4);
    }

    public void packagerStop() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_ended"), 4);
    }

    public void execute() throws BuildException {
        if (this.input == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("input_must_be_specified"));
        }
        if (this.output == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("output_must_be_specified"));
        }
        if (this.basedir == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("basedir_must_be_specified"));
        }
        String kind = this.installerType == null ? null : this.installerType.getValue();
        Compiler c = new Compiler(this.input, this.basedir, kind, this.output);
        Compiler.IZPACK_HOME = this.izPackDir;
        c.setPackagerListener(this);
        try {
            c.executeCompiler();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInstallerType(InstallerType installerType) {
        this.installerType = installerType;
    }

    public void setIzPackDir(String izPackDir) {
        if (!izPackDir.endsWith("/")) {
            izPackDir = izPackDir + "/";
        }
        this.izPackDir = izPackDir;
    }

    public static class InstallerType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"standard", "web"};
        }
    }
}

