/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.TimePeriod;
import org.jfree.date.MonthConstants;

public abstract class RegularTimePeriod
implements TimePeriod,
Comparable,
MonthConstants {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final Calendar WORKING_CALENDAR = Calendar.getInstance(DEFAULT_TIME_ZONE);

    public abstract RegularTimePeriod previous();

    public abstract RegularTimePeriod next();

    public abstract long getSerialIndex();

    public Date getStart() {
        return new Date(this.getFirstMillisecond());
    }

    public Date getEnd() {
        return new Date(this.getLastMillisecond());
    }

    public long getFirstMillisecond() {
        return this.getFirstMillisecond(DEFAULT_TIME_ZONE);
    }

    public long getFirstMillisecond(TimeZone timeZone) {
        WORKING_CALENDAR.setTimeZone(timeZone);
        return this.getFirstMillisecond(WORKING_CALENDAR);
    }

    public abstract long getFirstMillisecond(Calendar var1);

    public long getLastMillisecond() {
        return this.getLastMillisecond(DEFAULT_TIME_ZONE);
    }

    public long getLastMillisecond(TimeZone timeZone) {
        WORKING_CALENDAR.setTimeZone(timeZone);
        return this.getLastMillisecond(WORKING_CALENDAR);
    }

    public abstract long getLastMillisecond(Calendar var1);

    public long getMiddleMillisecond() {
        long l = this.getFirstMillisecond() / 2L + this.getLastMillisecond() / 2L;
        return l;
    }

    public long getMiddleMillisecond(TimeZone timeZone) {
        long l = this.getFirstMillisecond(timeZone) / 2L + this.getLastMillisecond(timeZone) / 2L;
        return l;
    }

    public long getMiddleMillisecond(Calendar calendar) {
        long l = this.getFirstMillisecond(calendar) / 2L + this.getLastMillisecond(calendar) / 2L;
        return l;
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }
}

