/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.Marker;
import org.jfree.chart.MarkerLabelPosition;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.XYDataset;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private XYPlot plot;
    private XYToolTipGenerator toolTipGenerator;
    private XYURLGenerator urlGenerator;

    protected AbstractXYItemRenderer() {
        this.toolTipGenerator = null;
        this.urlGenerator = null;
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator) {
        this(xYToolTipGenerator, null);
    }

    protected AbstractXYItemRenderer(XYURLGenerator xYURLGenerator) {
        this(null, xYURLGenerator);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.urlGenerator = xYURLGenerator;
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = new XYItemRendererState(plotRenderingInfo);
        return xYItemRendererState;
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        XYToolTipGenerator xYToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = xYToolTipGenerator;
        this.firePropertyChanged("renderer.ToolTipGenerator", xYToolTipGenerator2, xYToolTipGenerator);
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        XYURLGenerator xYURLGenerator2 = this.urlGenerator;
        this.urlGenerator = xYURLGenerator;
        this.firePropertyChanged("renderer.URLGenerator", xYURLGenerator2, xYURLGenerator);
    }

    public RangeType getRangeType() {
        return RangeType.STANDARD;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = n == 0 ? xYPlot.getDataset() : xYPlot.getSecondaryDataset(n - 1)) != null) {
            String string;
            String string2 = string = xYDataset.getSeriesName(n2);
            Shape shape = this.getSeriesShape(n2);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesStroke(n2);
            legendItem = new LegendItem(string, string2, shape, paint, paint2, stroke);
        }
        return legendItem;
    }

    public void fillDomainGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.translateValueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, rectangle2D.getMinY(), d4 - d3, rectangle2D.getMaxY() - rectangle2D.getMinY());
        Paint paint = xYPlot.getDomainTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void fillRangeGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.translateValueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getWidth(), d3 - d4);
        Paint paint = xYPlot.getRangeTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = xYPlot.getRangeGridlinePaint();
        Stroke stroke = xYPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        String string = marker.getLabel();
        MarkerLabelPosition markerLabelPosition = marker.getLabelPosition();
        if (string != null) {
            Font font = marker.getLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(marker.getLabelPaint());
            double[] dArray = this.calculateDomainMarkerTextPosition(graphics2D, plotOrientation, rectangle2D, d2, string, font, markerLabelPosition);
            graphics2D.drawString(string, (int)dArray[0], (int)dArray[1]);
        }
    }

    private double[] calculateDomainMarkerTextPosition(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, double d, String string, Font font, MarkerLabelPosition markerLabelPosition) {
        double[] dArray = new double[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            }
        }
        return dArray;
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        String string = marker.getLabel();
        MarkerLabelPosition markerLabelPosition = marker.getLabelPosition();
        if (string != null) {
            Font font = marker.getLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(marker.getLabelPaint());
            double[] dArray = this.calculateRangeMarkerTextPosition(graphics2D, plotOrientation, rectangle2D, d2, string, font, markerLabelPosition);
            graphics2D.drawString(string, (int)dArray[0], (int)dArray[1]);
        }
    }

    private double[] calculateRangeMarkerTextPosition(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, double d, String string, Font font, MarkerLabelPosition markerLabelPosition) {
        double[] dArray = new double[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMinY() + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = d - rectangle2D2.getWidth() - 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = d + 2.0;
                dArray[1] = rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            }
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            if (markerLabelPosition == MarkerLabelPosition.TOP_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.TOP_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_LEFT) {
                dArray[0] = rectangle2D.getMinX() + 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            } else if (markerLabelPosition == MarkerLabelPosition.BOTTOM_RIGHT) {
                dArray[0] = rectangle2D.getMaxX() - rectangle2D2.getWidth() - 2.0;
                dArray[1] = d + rectangle2D2.getHeight();
            }
        }
        return dArray;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)super.clone();
        if (this.toolTipGenerator != null && this.toolTipGenerator instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)this.toolTipGenerator;
            abstractXYItemRenderer.toolTipGenerator = (XYToolTipGenerator)publicCloneable.clone();
        }
        return abstractXYItemRenderer;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractXYItemRenderer) {
            AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object;
            if (super.equals(object)) {
                boolean bl = ObjectUtils.equal((Object)this.toolTipGenerator, (Object)abstractXYItemRenderer.toolTipGenerator);
                boolean bl2 = ObjectUtils.equal((Object)this.urlGenerator, (Object)abstractXYItemRenderer.urlGenerator);
                return bl && bl2;
            }
            return false;
        }
        return false;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null) {
            drawingSupplier = xYPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }
}

