/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtils;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PaintList;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtils;
import org.jfree.util.StrokeList;

public abstract class AbstractRenderer
implements Cloneable,
Serializable {
    public static final Double ZERO = new Double(0.0);
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = Color.black;
    private transient Paint paint = null;
    private PaintList paintList = new PaintList();
    private transient Paint basePaint = DEFAULT_PAINT;
    private transient Paint outlinePaint = null;
    private PaintList outlinePaintList = new PaintList();
    private transient Paint baseOutlinePaint = DEFAULT_OUTLINE_PAINT;
    private transient Stroke stroke = null;
    private StrokeList strokeList = new StrokeList();
    private transient Stroke baseStroke = DEFAULT_STROKE;
    private transient Stroke outlineStroke = null;
    private StrokeList outlineStrokeList = new StrokeList();
    private transient Stroke baseOutlineStroke = DEFAULT_OUTLINE_STROKE;
    private transient Shape shape = null;
    private ShapeList shapeList = new ShapeList();
    private transient Shape baseShape = DEFAULT_SHAPE;
    private Boolean itemLabelsVisible = null;
    private BooleanList itemLabelsVisibleList = new BooleanList();
    private Boolean baseItemLabelsVisible = Boolean.FALSE;
    private Font itemLabelFont = null;
    private ObjectList itemLabelFontList = new ObjectList();
    private Font baseItemLabelFont = new Font("SansSerif", 0, 10);
    private transient Paint itemLabelPaint = null;
    private PaintList itemLabelPaintList = new PaintList();
    private transient Paint baseItemLabelPaint = Color.black;
    private ItemLabelPosition positiveItemLabelPosition = null;
    private ObjectList positiveItemLabelPositionList = new ObjectList();
    private ItemLabelPosition basePositiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER, TextAnchor.BOTTOM_CENTER, 0.0);
    private ItemLabelPosition negativeItemLabelPosition = null;
    private ObjectList negativeItemLabelPositionList = new ObjectList();
    private ItemLabelPosition baseNegativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER, TextAnchor.TOP_CENTER, 0.0);
    private transient EventListenerList listenerList = new EventListenerList();
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$jfree$chart$event$RendererChangeListener;

    public abstract DrawingSupplier getDrawingSupplier();

    public Paint getItemPaint(int n, int n2) {
        return this.getSeriesPaint(n);
    }

    public Paint getSeriesPaint(int n) {
        if (this.paint != null) {
            return this.paint;
        }
        Paint paint = this.paintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextPaint();
                this.paintList.setPaint(n, paint);
            } else {
                paint = this.basePaint;
            }
        }
        return paint;
    }

    public void setPaint(Paint paint) {
        this.setPaint(paint, true);
    }

    public void setPaint(Paint paint, boolean bl) {
        this.paint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.setSeriesPaint(n, paint, true);
    }

    public void setSeriesPaint(int n, Paint paint, boolean bl) {
        this.paintList.setPaint(n, paint);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getBasePaint() {
        return this.basePaint;
    }

    public void setBasePaint(Paint paint) {
        this.setBasePaint(paint, true);
    }

    public void setBasePaint(Paint paint, boolean bl) {
        this.basePaint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getItemOutlinePaint(int n, int n2) {
        return this.getSeriesOutlinePaint(n);
    }

    public Paint getSeriesOutlinePaint(int n) {
        if (this.outlinePaint != null) {
            return this.outlinePaint;
        }
        Paint paint = this.outlinePaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextOutlinePaint();
                this.outlinePaintList.setPaint(n, paint);
            } else {
                paint = this.baseOutlinePaint;
            }
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.setSeriesOutlinePaint(n, paint, true);
    }

    public void setSeriesOutlinePaint(int n, Paint paint, boolean bl) {
        this.outlinePaintList.setPaint(n, paint);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setOutlinePaint(Paint paint) {
        this.setOutlinePaint(paint, true);
    }

    public void setOutlinePaint(Paint paint, boolean bl) {
        this.outlinePaint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getBaseOutlinePaint() {
        return this.baseOutlinePaint;
    }

    public void setBaseOutlinePaint(Paint paint) {
        this.setBaseOutlinePaint(paint, true);
    }

    public void setBaseOutlinePaint(Paint paint, boolean bl) {
        this.baseOutlinePaint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Stroke getItemStroke(int n, int n2) {
        return this.getSeriesStroke(n);
    }

    public Stroke getSeriesStroke(int n) {
        if (this.stroke != null) {
            return this.stroke;
        }
        Stroke stroke = this.strokeList.getStroke(n);
        if (stroke == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextStroke();
                this.strokeList.setStroke(n, stroke);
            } else {
                stroke = this.baseStroke;
            }
        }
        return stroke;
    }

    public void setStroke(Stroke stroke) {
        this.setStroke(stroke, true);
    }

    public void setStroke(Stroke stroke, boolean bl) {
        this.stroke = stroke;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.setSeriesStroke(n, stroke, true);
    }

    public void setSeriesStroke(int n, Stroke stroke, boolean bl) {
        this.strokeList.setStroke(n, stroke);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Stroke getBaseStroke() {
        return this.baseStroke;
    }

    public void setBaseStroke(Stroke stroke) {
        this.setBaseStroke(stroke, true);
    }

    public void setBaseStroke(Stroke stroke, boolean bl) {
        this.baseStroke = stroke;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Stroke getItemOutlineStroke(int n, int n2) {
        return this.getSeriesOutlineStroke(n);
    }

    public Stroke getSeriesOutlineStroke(int n) {
        if (this.outlineStroke != null) {
            return this.outlineStroke;
        }
        Stroke stroke = this.outlineStrokeList.getStroke(n);
        if (stroke == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextStroke();
                this.strokeList.setStroke(n, stroke);
            } else {
                stroke = this.baseOutlineStroke;
            }
        }
        return stroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.setOutlineStroke(stroke, true);
    }

    public void setOutlineStroke(Stroke stroke, boolean bl) {
        this.outlineStroke = stroke;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.setSeriesOutlineStroke(n, stroke, true);
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke, boolean bl) {
        this.outlineStrokeList.setStroke(n, stroke);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Stroke getBaseOutlineStroke() {
        return this.baseOutlineStroke;
    }

    public void setBaseOutlineStroke(Stroke stroke) {
        this.setBaseOutlineStroke(stroke, true);
    }

    public void setBaseOutlineStroke(Stroke stroke, boolean bl) {
        this.baseOutlineStroke = stroke;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Shape getItemShape(int n, int n2) {
        return this.getSeriesShape(n);
    }

    public Shape getSeriesShape(int n) {
        if (this.shape != null) {
            return this.shape;
        }
        Shape shape = this.shapeList.getShape(n);
        if (shape == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                shape = drawingSupplier.getNextShape();
                this.shapeList.setShape(n, shape);
            } else {
                shape = this.baseShape;
            }
        }
        return shape;
    }

    public void setShape(Shape shape) {
        this.setShape(shape, true);
    }

    public void setShape(Shape shape, boolean bl) {
        this.shape = shape;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesShape(int n, Shape shape) {
        this.setSeriesShape(n, shape, true);
    }

    public void setSeriesShape(int n, Shape shape, boolean bl) {
        this.shapeList.setShape(n, shape);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Shape getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Shape shape) {
        this.setBaseShape(shape, true);
    }

    public void setBaseShape(Shape shape, boolean bl) {
        this.baseShape = shape;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    protected synchronized Shape createTransformedShape(Shape shape, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public boolean isItemLabelVisible(int n, int n2) {
        return this.isSeriesItemLabelsVisible(n);
    }

    public boolean isSeriesItemLabelsVisible(int n) {
        if (this.itemLabelsVisible != null) {
            return this.itemLabelsVisible;
        }
        Boolean bl = this.itemLabelsVisibleList.getBoolean(n);
        if (bl == null) {
            bl = this.baseItemLabelsVisible;
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public void setItemLabelsVisible(boolean bl) {
        this.setItemLabelsVisible(BooleanUtils.valueOf((boolean)bl));
    }

    public void setItemLabelsVisible(Boolean bl) {
        this.setItemLabelsVisible(bl, true);
    }

    public void setItemLabelsVisible(Boolean bl, boolean bl2) {
        this.itemLabelsVisible = bl;
        if (bl2) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesItemLabelsVisible(int n, Boolean bl) {
        this.setSeriesItemLabelsVisible(n, bl, true);
    }

    public void setSeriesItemLabelsVisible(int n, Boolean bl, boolean bl2) {
        this.itemLabelsVisibleList.setBoolean(n, bl);
        if (bl2) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Boolean getBaseItemLabelsVisible() {
        return this.baseItemLabelsVisible;
    }

    public void setBaseItemLabelsVisible(Boolean bl) {
        this.setBaseItemLabelsVisible(bl, true);
    }

    public void setBaseItemLabelsVisible(Boolean bl, boolean bl2) {
        this.baseItemLabelsVisible = bl;
        if (bl2) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Font getItemLabelFont(int n, int n2) {
        return this.getSeriesItemLabelFont(n);
    }

    public Font getSeriesItemLabelFont(int n) {
        if (this.itemLabelFont != null) {
            return this.itemLabelFont;
        }
        Font font = (Font)this.itemLabelFontList.get(n);
        if (font == null) {
            font = this.baseItemLabelFont;
        }
        return font;
    }

    public void setItemLabelFont(Font font) {
        this.setItemLabelFont(font, true);
    }

    public void setItemLabelFont(Font font, boolean bl) {
        this.itemLabelFont = font;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesItemLabelFont(int n, Font font) {
        this.setSeriesItemLabelFont(n, font, true);
    }

    public void setSeriesItemLabelFont(int n, Font font, boolean bl) {
        this.itemLabelFontList.set(n, (Object)font);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Font getBaseItemLabelFont() {
        return this.baseItemLabelFont;
    }

    public void setBaseItemLabelFont(Font font) {
        this.setBaseItemLabelFont(font, true);
    }

    public void setBaseItemLabelFont(Font font, boolean bl) {
        this.baseItemLabelFont = font;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getItemLabelPaint(int n, int n2) {
        return this.getSeriesItemLabelPaint(n);
    }

    public Paint getSeriesItemLabelPaint(int n) {
        if (this.itemLabelPaint != null) {
            return this.itemLabelPaint;
        }
        Paint paint = this.itemLabelPaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseItemLabelPaint;
        }
        return paint;
    }

    public void setItemLabelPaint(Paint paint) {
        this.setItemLabelPaint(paint, true);
    }

    public void setItemLabelPaint(Paint paint, boolean bl) {
        this.itemLabelPaint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesItemLabelPaint(int n, Paint paint) {
        this.setSeriesItemLabelPaint(n, paint, true);
    }

    public void setSeriesItemLabelPaint(int n, Paint paint, boolean bl) {
        this.itemLabelPaintList.setPaint(n, paint);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public Paint getBaseItemLabelPaint() {
        return this.baseItemLabelPaint;
    }

    public void setBaseItemLabelPaint(Paint paint) {
        this.setBaseItemLabelPaint(paint, true);
    }

    public void setBaseItemLabelPaint(Paint paint, boolean bl) {
        this.baseItemLabelPaint = paint;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition(int n, int n2) {
        return this.getSeriesPositiveItemLabelPosition(n);
    }

    public ItemLabelPosition getSeriesPositiveItemLabelPosition(int n) {
        if (this.positiveItemLabelPosition != null) {
            return this.positiveItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = (ItemLabelPosition)this.positiveItemLabelPositionList.get(n);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.basePositiveItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public ItemLabelPosition getPositiveItemLabelPosition() {
        return this.positiveItemLabelPosition;
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setPositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setPositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.positiveItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesPositiveItemLabelPosition(int n, ItemLabelPosition itemLabelPosition) {
        this.setSeriesPositiveItemLabelPosition(n, itemLabelPosition, true);
    }

    public void setSeriesPositiveItemLabelPosition(int n, ItemLabelPosition itemLabelPosition, boolean bl) {
        this.positiveItemLabelPositionList.set(n, (Object)itemLabelPosition);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public ItemLabelPosition getBasePositiveItemLabelPosition() {
        return this.basePositiveItemLabelPosition;
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBasePositiveItemLabelPosition(itemLabelPosition, true);
    }

    public void setBasePositiveItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.basePositiveItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition(int n, int n2) {
        return this.getSeriesNegativeItemLabelPosition(n);
    }

    public ItemLabelPosition getSeriesNegativeItemLabelPosition(int n) {
        if (this.negativeItemLabelPosition != null) {
            return this.negativeItemLabelPosition;
        }
        ItemLabelPosition itemLabelPosition = (ItemLabelPosition)this.negativeItemLabelPositionList.get(n);
        if (itemLabelPosition == null) {
            itemLabelPosition = this.baseNegativeItemLabelPosition;
        }
        return itemLabelPosition;
    }

    public ItemLabelPosition getNegativeItemLabelPosition() {
        return this.negativeItemLabelPosition;
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.negativeItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void setSeriesNegativeItemLabelPosition(int n, ItemLabelPosition itemLabelPosition) {
        this.setSeriesNegativeItemLabelPosition(n, itemLabelPosition, true);
    }

    public void setSeriesNegativeItemLabelPosition(int n, ItemLabelPosition itemLabelPosition, boolean bl) {
        this.negativeItemLabelPositionList.set(n, (Object)itemLabelPosition);
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public ItemLabelPosition getBaseNegativeItemLabelPosition() {
        return this.baseNegativeItemLabelPosition;
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition) {
        this.setBaseNegativeItemLabelPosition(itemLabelPosition, true);
    }

    public void setBaseNegativeItemLabelPosition(ItemLabelPosition itemLabelPosition, boolean bl) {
        this.baseNegativeItemLabelPosition = itemLabelPosition;
        if (bl) {
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public void addChangeListener(RendererChangeListener rendererChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$RendererChangeListener == null ? (class$org$jfree$chart$event$RendererChangeListener = AbstractRenderer.class$("org.jfree.chart.event.RendererChangeListener")) : class$org$jfree$chart$event$RendererChangeListener, rendererChangeListener);
    }

    public void removeChangeListener(RendererChangeListener rendererChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$RendererChangeListener == null ? (class$org$jfree$chart$event$RendererChangeListener = AbstractRenderer.class$("org.jfree.chart.event.RendererChangeListener")) : class$org$jfree$chart$event$RendererChangeListener, rendererChangeListener);
    }

    public void notifyListeners(RendererChangeEvent rendererChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jfree$chart$event$RendererChangeListener == null ? AbstractRenderer.class$("org.jfree.chart.event.RendererChangeListener") : class$org$jfree$chart$event$RendererChangeListener)) continue;
            ((RendererChangeListener)objectArray[i + 1]).rendererChanged(rendererChangeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractRenderer) {
            AbstractRenderer abstractRenderer = (AbstractRenderer)object;
            boolean bl = ObjectUtils.equal((Object)this.paint, (Object)abstractRenderer.paint);
            boolean bl2 = ObjectUtils.equal((Object)this.paintList, (Object)abstractRenderer.paintList);
            boolean bl3 = ObjectUtils.equal((Object)this.basePaint, (Object)abstractRenderer.basePaint);
            boolean bl4 = ObjectUtils.equal((Object)this.outlinePaint, (Object)abstractRenderer.outlinePaint);
            boolean bl5 = ObjectUtils.equal((Object)this.outlinePaintList, (Object)abstractRenderer.outlinePaintList);
            boolean bl6 = ObjectUtils.equal((Object)this.baseOutlinePaint, (Object)abstractRenderer.baseOutlinePaint);
            boolean bl7 = ObjectUtils.equal((Object)this.stroke, (Object)abstractRenderer.stroke);
            boolean bl8 = ObjectUtils.equal((Object)this.strokeList, (Object)abstractRenderer.strokeList);
            boolean bl9 = ObjectUtils.equal((Object)this.baseStroke, (Object)abstractRenderer.baseStroke);
            boolean bl10 = ObjectUtils.equal((Object)this.outlineStroke, (Object)abstractRenderer.outlineStroke);
            boolean bl11 = ObjectUtils.equal((Object)this.outlineStrokeList, (Object)abstractRenderer.outlineStrokeList);
            boolean bl12 = ObjectUtils.equal((Object)this.baseOutlineStroke, (Object)abstractRenderer.baseOutlineStroke);
            boolean bl13 = ObjectUtils.equal((Object)this.shape, (Object)abstractRenderer.shape);
            boolean bl14 = ObjectUtils.equal((Object)this.shapeList, (Object)abstractRenderer.shapeList);
            boolean bl15 = ObjectUtils.equal((Object)this.baseShape, (Object)abstractRenderer.baseShape);
            boolean bl16 = ObjectUtils.equal((Object)this.itemLabelsVisible, (Object)abstractRenderer.itemLabelsVisible);
            boolean bl17 = ObjectUtils.equal((Object)this.itemLabelsVisibleList, (Object)abstractRenderer.itemLabelsVisibleList);
            boolean bl18 = ObjectUtils.equal((Object)this.baseItemLabelsVisible, (Object)abstractRenderer.baseItemLabelsVisible);
            boolean bl19 = ObjectUtils.equal((Object)this.itemLabelFont, (Object)abstractRenderer.itemLabelFont);
            boolean bl20 = ObjectUtils.equal((Object)this.itemLabelFontList, (Object)abstractRenderer.itemLabelFontList);
            boolean bl21 = ObjectUtils.equal((Object)this.baseItemLabelFont, (Object)abstractRenderer.baseItemLabelFont);
            boolean bl22 = ObjectUtils.equal((Object)this.itemLabelPaint, (Object)abstractRenderer.itemLabelPaint);
            boolean bl23 = ObjectUtils.equal((Object)this.itemLabelPaintList, (Object)abstractRenderer.itemLabelPaintList);
            boolean bl24 = ObjectUtils.equal((Object)this.baseItemLabelPaint, (Object)abstractRenderer.baseItemLabelPaint);
            boolean bl25 = ObjectUtils.equal((Object)this.positiveItemLabelPosition, (Object)abstractRenderer.positiveItemLabelPosition);
            boolean bl26 = ObjectUtils.equal((Object)this.positiveItemLabelPositionList, (Object)abstractRenderer.positiveItemLabelPositionList);
            boolean bl27 = ObjectUtils.equal((Object)this.basePositiveItemLabelPosition, (Object)abstractRenderer.basePositiveItemLabelPosition);
            boolean bl28 = ObjectUtils.equal((Object)this.negativeItemLabelPosition, (Object)abstractRenderer.negativeItemLabelPosition);
            boolean bl29 = ObjectUtils.equal((Object)this.negativeItemLabelPositionList, (Object)abstractRenderer.negativeItemLabelPositionList);
            boolean bl30 = ObjectUtils.equal((Object)this.baseNegativeItemLabelPosition, (Object)abstractRenderer.baseNegativeItemLabelPosition);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl23 && bl24 && bl25 && bl26 && bl27 && bl28 && bl29 && bl30;
        }
        return false;
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + ObjectUtils.hashCode((Object)this.stroke);
        n = 37 * n + ObjectUtils.hashCode((Object)this.baseStroke);
        n = 37 * n + ObjectUtils.hashCode((Object)this.outlineStroke);
        n = 37 * n + ObjectUtils.hashCode((Object)this.baseOutlineStroke);
        return n;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractRenderer abstractRenderer = (AbstractRenderer)super.clone();
        if (this.paintList != null) {
            abstractRenderer.paintList = (PaintList)this.paintList.clone();
        }
        if (this.outlinePaintList != null) {
            abstractRenderer.outlinePaintList = (PaintList)this.outlinePaintList.clone();
        }
        if (this.strokeList != null) {
            abstractRenderer.strokeList = (StrokeList)this.strokeList.clone();
        }
        if (this.outlineStrokeList != null) {
            abstractRenderer.outlineStrokeList = (StrokeList)this.outlineStrokeList.clone();
        }
        if (this.shape != null) {
            abstractRenderer.shape = ShapeUtils.clone((Shape)this.shape);
        }
        if (this.baseShape != null) {
            abstractRenderer.baseShape = ShapeUtils.clone((Shape)this.baseShape);
        }
        if (this.itemLabelsVisibleList != null) {
            abstractRenderer.itemLabelsVisibleList = (BooleanList)this.itemLabelsVisibleList.clone();
        }
        if (this.itemLabelFontList != null) {
            abstractRenderer.itemLabelFontList = (ObjectList)this.itemLabelFontList.clone();
        }
        if (this.itemLabelPaintList != null) {
            abstractRenderer.itemLabelPaintList = (PaintList)this.itemLabelPaintList.clone();
        }
        if (this.positiveItemLabelPositionList != null) {
            abstractRenderer.positiveItemLabelPositionList = (ObjectList)this.positiveItemLabelPositionList.clone();
        }
        if (this.negativeItemLabelPositionList != null) {
            abstractRenderer.negativeItemLabelPositionList = (ObjectList)this.negativeItemLabelPositionList.clone();
        }
        return abstractRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.basePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.stroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.shape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.baseShape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.itemLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseItemLabelPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.basePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.stroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.shape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.baseShape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseItemLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }

    public ItemLabelAnchor getItemLabelAnchor(int n, int n2) {
        return this.getSeriesItemLabelAnchor(n);
    }

    public ItemLabelAnchor getSeriesItemLabelAnchor(int n) {
        ItemLabelAnchor itemLabelAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getSeriesPositiveItemLabelPosition(n);
        if (itemLabelPosition != null) {
            itemLabelAnchor = itemLabelPosition.getItemLabelAnchor();
        }
        return itemLabelAnchor;
    }

    public void setItemLabelAnchor(ItemLabelAnchor itemLabelAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setItemLabelAnchor is deprecated.");
    }

    public void setSeriesItemLabelAnchor(int n, ItemLabelAnchor itemLabelAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setSeriesItemLabelAnchor is deprecated.");
    }

    public ItemLabelAnchor getBaseItemLabelAnchor() {
        ItemLabelAnchor itemLabelAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getBasePositiveItemLabelPosition();
        if (itemLabelPosition != null) {
            return itemLabelPosition.getItemLabelAnchor();
        }
        return itemLabelAnchor;
    }

    public void setBaseItemLabelAnchor(ItemLabelAnchor itemLabelAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setBaseItemLabelAnchor is deprecated.");
    }

    public TextAnchor getItemLabelTextAnchor(int n, int n2) {
        return this.getSeriesItemLabelTextAnchor(n);
    }

    public TextAnchor getSeriesItemLabelTextAnchor(int n) {
        TextAnchor textAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getSeriesPositiveItemLabelPosition(n);
        if (itemLabelPosition != null) {
            textAnchor = itemLabelPosition.getTextAnchor();
        }
        return textAnchor;
    }

    public void setItemLabelTextAnchor(TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setItemLabelTextAnchor is deprecated.");
    }

    public void setSeriesItemLabelTextAnchor(int n, TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setSeriesItemLabelTextAnchor is deprecated.");
    }

    public TextAnchor getBaseItemLabelTextAnchor() {
        TextAnchor textAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getBasePositiveItemLabelPosition();
        if (itemLabelPosition != null) {
            textAnchor = itemLabelPosition.getTextAnchor();
        }
        return textAnchor;
    }

    public void setBaseItemLabelTextAnchor(TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setBaseItemLabelTextAnchor is deprecated.");
    }

    public TextAnchor getItemLabelRotationAnchor(int n, int n2) {
        return this.getSeriesItemLabelRotationAnchor(n);
    }

    public TextAnchor getSeriesItemLabelRotationAnchor(int n) {
        TextAnchor textAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getSeriesPositiveItemLabelPosition(n);
        if (itemLabelPosition != null) {
            textAnchor = itemLabelPosition.getRotationAnchor();
        }
        return textAnchor;
    }

    public void setItemLabelRotationAnchor(TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setItemLabelRotationAnchor is deprecated.");
    }

    public void setSeriesItemLabelRotationAnchor(int n, TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setSeriesItemLabelRotationAnchor is deprecated.");
    }

    public TextAnchor getBaseItemLabelRotationAnchor() {
        TextAnchor textAnchor = null;
        ItemLabelPosition itemLabelPosition = this.getBasePositiveItemLabelPosition();
        if (itemLabelPosition != null) {
            textAnchor = itemLabelPosition.getRotationAnchor();
        }
        return textAnchor;
    }

    public void setBaseItemLabelRotationAnchor(TextAnchor textAnchor) {
        throw new UnsupportedOperationException("AbstractRenderer.setBaseItemLabelRotationAnchor is deprecated.");
    }

    public Number getItemLabelAngle(int n, int n2) {
        return this.getSeriesItemLabelAngle(n);
    }

    public Number getSeriesItemLabelAngle(int n) {
        Double d = null;
        ItemLabelPosition itemLabelPosition = this.getSeriesPositiveItemLabelPosition(n);
        if (itemLabelPosition != null) {
            d = new Double(itemLabelPosition.getAngle());
        }
        return d;
    }

    public void setItemLabelAngle(Number number) {
        throw new UnsupportedOperationException("AbstractRenderer.setItemLabelAngle is deprecated.");
    }

    public void setSeriesAngle(int n, Number number) {
        throw new UnsupportedOperationException("AbstractRenderer.setSeriesAngle is deprecated.");
    }

    public Number getBaseItemLabelAngle() {
        Double d = null;
        ItemLabelPosition itemLabelPosition = this.getBasePositiveItemLabelPosition();
        if (itemLabelPosition != null) {
            d = new Double(itemLabelPosition.getAngle());
        }
        return d;
    }

    public void setBaseAngle(Number number) {
        throw new UnsupportedOperationException("AbstractRenderer.setBaseAngle is deprecated.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

