/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.MarkerLabelPosition;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtils;

public class Marker
implements Serializable,
Cloneable {
    private double value;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private transient Paint paint;
    private float alpha;
    private String label = null;
    private Font labelFont;
    private transient Paint labelPaint;
    private MarkerLabelPosition labelPosition = MarkerLabelPosition.TOP_LEFT;

    public Marker(double d) {
        this(d, Color.gray, new BasicStroke(0.5f), Color.gray, 0.8f);
    }

    public Marker(double d, Paint paint) {
        this(d, paint, new BasicStroke(0.5f), Color.red, 0.8f);
    }

    public Marker(double d, Paint paint, Stroke stroke, Paint paint2, float f) {
        if (paint == null) {
            throw new IllegalArgumentException("Marker(...) : null outlinePaint not permitted.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Marker(...) : null outlineStroke not permitted.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Marker(...) : null paint not permitted.");
        }
        this.value = d;
        this.outlinePaint = paint;
        this.outlineStroke = stroke;
        this.paint = paint2;
        this.alpha = f;
        this.labelFont = new Font("SansSerif", 0, 9);
        this.labelPaint = Color.black;
    }

    public double getValue() {
        return this.value;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (this.paint == null) {
            throw new IllegalArgumentException("Marker.setLabelFont(...): null not permitted.");
        }
        this.labelFont = font;
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Marker.setLabelPaint(...): null not permitted.");
        }
        this.labelPaint = paint;
    }

    public MarkerLabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(MarkerLabelPosition markerLabelPosition) {
        this.labelPosition = markerLabelPosition;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Marker) {
            Marker marker = (Marker)object;
            boolean bl = this.value == marker.value;
            boolean bl2 = ObjectUtils.equal((Object)this.outlinePaint, (Object)marker.outlinePaint);
            boolean bl3 = ObjectUtils.equal((Object)this.outlineStroke, (Object)marker.outlineStroke);
            boolean bl4 = ObjectUtils.equal((Object)this.paint, (Object)marker.paint);
            boolean bl5 = this.alpha == marker.alpha;
            boolean bl6 = ObjectUtils.equal((Object)this.label, (Object)marker.label);
            boolean bl7 = ObjectUtils.equal((Object)this.labelFont, (Object)marker.labelFont);
            boolean bl8 = ObjectUtils.equal((Object)this.labelPaint, (Object)marker.labelPaint);
            boolean bl9 = this.labelPosition == marker.labelPosition;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

