/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class KunststoffTextAreaUI
extends BasicTextAreaUI {
    protected JComponent myComponent;

    public KunststoffTextAreaUI(JComponent jComponent) {
        this.myComponent = jComponent;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new KunststoffTextAreaUI(jComponent);
    }

    protected void paintBackground(Graphics graphics) {
        Serializable serializable;
        Color color;
        super.paintBackground(graphics);
        Rectangle rectangle = this.getVisibleEditorRect();
        ColorUIResource colorUIResource = KunststoffLookAndFeel.getTextComponentGradientColorReflection();
        if (colorUIResource != null) {
            color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
            serializable = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2);
            KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, true);
        }
        if ((color = KunststoffLookAndFeel.getTextComponentGradientColorShadow()) != null) {
            serializable = KunststoffUtilities.getTranslucentColor(color, 0);
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height / 2);
            KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle2, true);
        }
    }
}

