# pygsear
# Copyright (C) 2003 Lee Harr
#
#
# This file is part of pygsear.
#
# pygsear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# pygsear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pygsear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import random

from twisted.internet import reactor
from twisted.spread import pb

from pygsear.Network import TwoPlayerConnection

class Connection(TwoPlayerConnection):
    # Connections are made and saved
    # Server gets client's Connection,
    # and sends a copy of the World
    def remote_give_connection(self, connection):
        TwoPlayerConnection.remote_give_connection(self, connection)
        self.give_world()
        return self

    # Client gets server's connection, and
    # and waits for world
    def got_connection(self, connection):
        TwoPlayerConnection.got_connection(self, connection)
        print 'TC: connected'


    # SYNCHRONIZE WORLD
    def give_world(self):
        worldinfo = self.game.world.get_worldinfo()
        self.connection.callRemote("give_world", worldinfo)
        self.update()
        self.update_active_screen()

    def remote_give_world(self, worldinfo):
        self.game.world.sync(worldinfo)
        self.game.t1.set_random_screen()
        self.update()
        self.update_active_screen()


    # REMOTE TANK POSITION
    def update(self):
        if hasattr(self, 'connection'):
            tank = self.game.t1
            pos = tank.get_position()
            rot = tank.get_rotation()
            vel = tank.path.get_velocity()
            acc = tank.path.get_acceleration()
            self.connection.callRemote('update', pos, rot, vel, acc)
        reactor.callLater(0.1, self.update)

    def remote_update(self, pos, rot, vel, acc):
        tank = self.game.his_tank
        tank.r_update(pos, rot, vel, acc)

    def update_active_screen(self):
        screen_name = self.game.t1.screen_name
        self.r_set_active_screen(screen_name)
        reactor.callLater(1, self.update_active_screen)

    def r_set_active_screen(self, screen_name):
        if hasattr(self, 'connection'):
            self.connection.callRemote('set_active_screen', screen_name)

    def remote_set_active_screen(self, screen_name):
        #print 'i am at', self.game.t1.screen_name
        #print 'he was at', self.game.his_tank.screen_name
        #print 'he reports', screen_name
        self.game.his_tank.r_set_active_screen(screen_name)


    # REMOTE TANK SHOTS
    def r_shoot(self):
        if hasattr(self, 'connection'):
            self.connection.callRemote('shoot')

    def remote_shoot(self):
        self.game.his_tank.shoot()
    
    def r_reload(self):
        if hasattr(self, 'connection'):
            self.connection.callRemote('reload')
    
    def remote_reload(self):
        self.game.his_tank.reload()
    

    
    
if __name__ == '__main__':
    class DummyGame:
        pass
    
    game = DummyGame()
    game.host = 'localhost'
    game.port = 8778
    
    connection = Connection(game)
    
    
    reactor.run()
