#!/usr/bin/python

#   Copyright (C) 2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *
from PixmapSet import *

class Stretcher:
    def stretchPixSet( self,
                       pixmapSet,
                       orientation,
                       stretchPoint,
                       stretchSize,
                       wantedSize ):
        oldPix = pixmapSet.getState(DISABLED)

        if orientation == "x":
            return self.stretchX(pixmapSet,
                                 stretchPoint,
                                 stretchSize,
                                 wantedSize,
                                 oldPix)
        elif orientation == "y":
            return self.stretchY(pixmapSet,
                                 stretchPoint,
                                 stretchSize,
                                 wantedSize,
                                 oldPix)
        else:
            raise Exception("Super weird orientation : %s" % orientation)

        
    def stretchX(self,
                 pixmapSet,
                 stretchPoint,
                 stretchSize,
                 wantedSize,
                 oldPix):
        newSize = oldPix.width()
        while (newSize <= wantedSize):
            newSize += stretchSize
        newSize -= stretchSize

        if oldPix.width() == newSize:
            return pixmapSet

        newPix = QPixmap( newSize,
                          oldPix.height(),
                          oldPix.depth(),
                          oldPix.optimization() )

        stretchFactor = (newSize - oldPix.width()) / stretchSize

        bitBlt( newPix,
                0, 0,
                oldPix,
                0, 0,
                stretchPoint, oldPix.height(),
                Qt.CopyROP,
                1 )
        for i in range(stretchFactor):
            bitBlt( newPix,
                stretchPoint + stretchSize*i, 0,
                oldPix,
                stretchPoint, 0,
                stretchSize, oldPix.height(),
                Qt.CopyROP,
                1 )
        bitBlt( newPix,
                stretchPoint + stretchSize*stretchFactor, 0,
                oldPix,
                stretchPoint, 0,
                oldPix.width() - stretchPoint,
                oldPix.height(),
                Qt.CopyROP, 1 )

        newSet = PixmapSet()
        newPix.setMask(newPix.createHeuristicMask())
        newSet.addState(newPix, DISABLED)
        return newSet


    def stretchY(self,
                 pixmapSet,
                 stretchPoint,
                 stretchSize,
                 wantedSize,
                 oldPix):
        newSize = oldPix.height()
        while (newSize <= wantedSize):
            newSize += stretchSize
        newSize -= stretchSize

        if oldPix.height() == newSize:
            return PixmapSet

        newPix = QPixmap( oldPix.width(),
                          newSize,
                          oldPix.depth(),
                          oldPix.optimization() )

        stretchFactor = (newSize - oldPix.height()) / stretchSize

        bitBlt( newPix,
                0, 0,
                oldPix,
                0, 0,
                oldPix.width(), stretchPoint,
                Qt.CopyROP,
                1 )

        for i in range(stretchFactor):
            bitBlt( newPix,
                    0, (stretchPoint + stretchSize*i),
                    oldPix,
                    0, stretchPoint,
                    oldPix.width(), stretchSize,
                    Qt.CopyROP,
                    1 )
        bitBlt( newPix,
                 0, stretchPoint + stretchSize*stretchFactor,
                 oldPix,
                 0, stretchPoint,
                 oldPix.width(),
                 oldPix.height() - stretchPoint,
                 Qt.CopyROP, 1 )

        newSet = PixmapSet()
        newPix.setMask(newPix.createHeuristicMask())
        newSet.addState(newPix, DISABLED)
        return newSet
