#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from wave import *
from pygame import mixer
from soundPath import *
from OBBConstants import *
from os import *

class SoundDevice:
    def __init__(self):
        self.sampleFile = None
        mixer.init(44100)
        nbChannels = mixer.get_num_channels()
        if nbChannels > 2:
            mixer.set_reserved(nbChannels)
        else:
            raise Exception("Insuficient number of available channels.")
#       In every man's life comes a time of
#       confusion and then comes redemption
#                               --VBarbin

    def Play(self, sample, times = 0, volume = 80):
        if access(sample, R_OK):
            sampleChannel = mixer.find_channel()
            sampleChannel.set_volume(volume/100)
            sampleChannel.play(mixer.Sound(sample), times)
        else:
            raise Exception("wav file %s not found." % (sample))



    def PlayLoadedSample(self, sample = None, times = 0, volume = 80):
        if sample == None:
            sample = self.sampleFile

        if sample != None:
            sampleChannel = mixer.find_channel()
            sampleChannel.set_volume(volume/100)
            sampleChannel.play(sample, times)


    def Load(self, sample):
        if access(sample, R_OK):
            wfile = openfp(sample, 'r')
            if wfile.getnframes() > 0:
                self.sampleFile = mixer.Sound(sample)
            else:
                #raise Exception
                print "wav file %s empty." % (sample)
            wfile.close()
        else:
            raise Exception("wav file %s not found." % (sample))


    def HandleHit(self, hitId):
        if hitId == 0:
            self.PlayLoadedSample()

    def HandleLoadSample(self, samplePath):
        print "Load"
        self.Load(samplePath)
        remove(samplePath)

    def stop(self, duration = 500):
        if duration == 0:
            mixer.stop()
        else:
            mixer.fadeout(duration)


if __name__ == "__main__":
    import time
    SD = SoundDevice()
    for i in range(4):
        SD.Play("../../sounds/hat03.wav", times = i)
    time.sleep(1)
