#ifndef MOBIUS_CRYPT_CIPHER_3DES_H
#define MOBIUS_CRYPT_CIPHER_3DES_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/cipher_block.h>
#include <mobius/crypt/cipher_des.h>
#include <mobius/bytearray.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Triple DES cipher cryptographic algorithm
//! \author Eduardo Aguiar
//! \see http://csrc.nist.gov/publications/fips/fips46-3/fips46-3.pdf
//! \see https://tools.ietf.org/html/rfc1851
//! \see https://en.wikipedia.org/wiki/Triple_DES
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_3des : public cipher_block
{
public:
  explicit cipher_3des (const mobius::bytearray&, const std::string& = "ecb", const mobius::bytearray& = {0, 0, 0, 0, 0, 0, 0, 0});
  void encrypt_block (mobius::bytearray&) noexcept override;
  void decrypt_block (mobius::bytearray&) noexcept override;

private:
  cipher_des des_1_;
  cipher_des des_2_;
  cipher_des des_3_;
};

} // namespace crypt
} // namespace mobius

#endif
