#!/usr/bin/env python3

import mobius
import datetime
import sys

def show_entry (r, path='/', level=0):
  indent = ' ' * (level * 2)

  if not r.exists ():
    print '%s? %s' % (indent, path)
    return

  # show metadata
  print ()
  print ('%s%s %s' % (indent, '+' if r.is_folder () else '.', path))
  print ('%s  User: %s (%d)' % (indent, r.user_name, r.user_id))
  print ('%s  Group: %s (%d)' % (indent, r.group_name, r.group_id))
  print ('%s  Permissions: %o' % (indent, r.permissions))
  print ('%s  Last access time (atime): %s' % (indent, r.access_time))
  print ('%s  Last modification time (mtime): %s' % (indent, r.modification_time))
  print ('%s  Last metadata time (ctime): %s' % (indent, r.metadata_time))

  # if resource is a file, show some bytes...
  if r.is_file ():
    print ('%s  size: %d' % (indent, r.size))

    if r.is_regular_file ():
      try:
        reader = r.new_reader ()
        data = reader.read (16)
        print ('%s  first 16 bytes: %s' % (indent, mobius.encoder.hexstring (data, ' ')))
      except Exception as e:
        print ('%s  <Warning: %s>' % (indent, e))
  
  # otherwise resource is a folder, so recurse into it
  else:
    try:
      for child in r.get_children ():
        if path == '/':
          cpath = path + child.name
        else:
          cpath = path + '/' + child.name
        show_entry (child, cpath, level+1)
    except Exception as e:
      print ('%s  <Warning: %s>' % (indent, e))

for path in sys.argv[1:]:
  entry = mobius.io.new_entry_by_path (path)
  show_entry (entry)  
