# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import CSharedSource
import CXMLElement

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Tristate constants
# @see ShareazaOM.h
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
TRI_UNKNOWN, TRI_FALSE, TRI_TRUE = range (3)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode CLibraryFile structure
# @see SharedFile.cpp - CLibraryFile::Serialize (UNCHECKED)
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (decoder, version, parent):
  f = dataholder ()
  f.name = decoder.get_string ()
  f.index = decoder.get_dword ()
  f.virtual_size = 0
  f.virtual_base = 0
  f.hash_tiger = None
  f.hash_md5 = None
  f.hash_ed2k = None
  f.hash_bth = None
  f.b_verify = 0
  f.rating = None
  f.comments = None
  f.share_tags = None
  f.sources = []
  f.pxml = None
    
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # f.size
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  if version >= 17:
    f.size = decoder.get_qword ()
  else:
    f.size = decoder.get_dword ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # f.last_modification_time
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  f.last_modification_time = decoder.get_nt_time ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # f.b_shared (True/False)
  # @see SharedFile.cpp - CLibraryFile::IsShared
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  if version >= 5:
    b_shared = decoder.get_dword ()
  else:
    b_shared = TRI_UNKNOWN if decoder.get_bool () else TRI_FALSE

  if b_shared == TRI_UNKNOWN:
    f.b_shared = parent.b_shared

  else:
    f.b_shared = (b_shared == TRI_TRUE)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # f.virtual_size
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  if version >= 21:
    f.virtual_size = decoder.get_qword ()
      
    if f.virtual_size > 0:
      f.virtual_base = decoder.get_qword ()

  f.hash_sha1 = decoder.get_hex_string (20)

  if version >= 8:
    f.hash_tiger = decoder.get_hex_string (24)

  if version >= 11:
    f.hash_md5 = decoder.get_hex_string (16)
    f.hash_ed2k = decoder.get_hex_string (16)

  if version >= 26:
    f.hash_bth = decoder.get_hex_string (20)

  if version >= 4:
    f.b_verify = decoder.get_dword ()

  f.uri = decoder.get_string ()
    
  if f.uri:
    if version < 27:
      f.b_metadata_auto = decoder.get_bool ()
        
      if not f.b_metadata_auto:
        f.metadata_time = decoder.get_nt_time ()

    f.pxml = CXMLElement.decode (decoder)
      
  if version >= 13:
    f.rating = decoder.get_int ()
    f.comments = decoder.get_string ()

    if version >= 16:
      f.share_tags = decoder.get_string ()

    if version >= 27:
      f.b_metadata_auto = decoder.get_bool ();
      f.metadata_time = decoder.get_nt_time ()

    elif f.b_metadata_auto and (f.rating or comment):
      f.metadata_time = decoder.get_nt_time ()

  f.hits_total = decoder.get_dword ()
    
  # @see WndMain.cpp - CMainWnd::OnNowUploading
  f.uploads_started = decoder.get_dword ()

  if version >= 14:
    f.b_cached_preview = decoder.get_bool ()

  if version >= 20:
    f.b_bogus = decoder.get_bool ()

  if version >= 2:
    count = decoder.get_count ()

    for i in xrange (count):
      source = CSharedSource.decode (decoder, version)
      f.sources.append (source)

  return f
