// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "cipher_block_mode.h"
#include "cipher_block_mode_impl_cbc.h"
#include "cipher_block_mode_impl_ecb.h"
#include "cipher_block.h"
#include <mobius/exception.inc>
#include <stdexcept>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief constructor
//! \param cipher cipher_block reference
//! \param mode cipher block mode
//! \param iv initialization vector
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
cipher_block_mode::cipher_block_mode (
  cipher_block& cipher,
  const std::string& mode,
  const mobius::bytearray& iv)
{
  if (mode == "ecb")
    impl_ = std::make_shared <cipher_block_mode_impl_ecb> (cipher);

  else if (mode == "cbc")
    {
      if (iv)
        impl_ = std::make_shared <cipher_block_mode_impl_cbc> (cipher, iv);
      else
        impl_ = std::make_shared <cipher_block_mode_impl_cbc> (cipher, mobius::bytearray (cipher.get_block_size ()));
    }

  else
    throw std::invalid_argument (MOBIUS_EXCEPTION_MSG ("Invalid cipher block mode"));
}


} // namespace crypt
} // namespace mobius
