// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "filesystem_vfat.h"
#include "filesystem.h"
#include "api_metadata.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (filesystem_filesystem_vfat_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: oem_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_oem_name (filesystem_filesystem_vfat_o *self)
{
  return PyString_from_std_string (self->obj->get_oem_name ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: sector_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sector_size (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sector_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: sectors_per_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors_per_cluster (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: reserved_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_reserved_sectors (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_reserved_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: fats getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_fats (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_fats ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: root_dir_entries getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_root_dir_entries (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_root_dir_entries ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: media_descriptor getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_media_descriptor (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_media_descriptor ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: sectors_per_fat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors_per_fat (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors_per_fat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: sectors_per_track getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors_per_track (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_track ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: heads getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_heads (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_heads ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: hidden_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_hidden_sectors (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_hidden_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: logical_drive_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_logical_drive_number (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_logical_drive_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: volume_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_id (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: volume_label getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_label (filesystem_filesystem_vfat_o *self)
{
  return PyString_from_std_string (self->obj->get_volume_label ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: flags getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_flags (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_flags ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_version (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: root_dir_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_root_dir_cluster (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_root_dir_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: fs_info_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_fs_info_sector (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_fs_info_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: backup_boot_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_backup_boot_sector (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_backup_boot_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: fat_entry_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_fat_entry_size (filesystem_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_fat_entry_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef tp_getset[] =
{
  {
    (char *) "oem_name",
    (getter) tp_getter_oem_name,
    (setter) 0,
    (char *) "OEM name", NULL
  },
  {
    (char *) "sector_size",
    (getter) tp_getter_sector_size,
    (setter) 0,
    (char *) "sector size in bytes", NULL
  },
  {
    (char *) "sectors_per_cluster",
    (getter) tp_getter_sectors_per_cluster,
    (setter) 0,
    (char *) "sectors per cluster", NULL
  },
  {
    (char *) "reserved_sectors",
    (getter) tp_getter_reserved_sectors,
    (setter) 0,
    (char *) "number of reserved sectors", NULL
  },
  {
    (char *) "fats",
    (getter) tp_getter_fats,
    (setter) 0,
    (char *) "number of FATs", NULL
  },
  {
    (char *) "root_dir_entries",
    (getter) tp_getter_root_dir_entries,
    (setter) 0,
    (char *) "number of entries in root directory", NULL
  },
  {
    (char *) "sectors",
    (getter) tp_getter_sectors,
    (setter) 0,
    (char *) "number of sectors", NULL
  },
  {
    (char *) "media_descriptor",
    (getter) tp_getter_media_descriptor,
    (setter) 0,
    (char *) "media descriptor type", NULL
  },
  {
    (char *) "sectors_per_fat",
    (getter) tp_getter_sectors_per_fat,
    (setter) 0,
    (char *) "sectors per FAT", NULL
  },
  {
    (char *) "sectors_per_track",
    (getter) tp_getter_sectors_per_track,
    (setter) 0,
    (char *) "sectors per track", NULL
  },
  {
    (char *) "heads",
    (getter) tp_getter_heads,
    (setter) 0,
    (char *) "number of heads", NULL
  },
  {
    (char *) "hidden_sectors",
    (getter) tp_getter_hidden_sectors,
    (setter) 0,
    (char *) "number of hidden sectors", NULL
  },
  {
    (char *) "logical_drive_number",
    (getter) tp_getter_logical_drive_number,
    (setter) 0,
    (char *) "logical drive number", NULL
  },
  {
    (char *) "volume_id",
    (getter) tp_getter_volume_id,
    (setter) 0,
    (char *) "volume ID", NULL
  },
  {
    (char *) "volume_label",
    (getter) tp_getter_volume_label,
    (setter) 0,
    (char *) "volume label", NULL
  },
  {
    (char *) "flags",
    (getter) tp_getter_flags,
    (setter) 0,
    (char *) "flags", NULL
  },
  {
    (char *) "version",
    (getter) tp_getter_version,
    (setter) 0,
    (char *) "filesystem version", NULL
  },
  {
    (char *) "root_dir_cluster",
    (getter) tp_getter_root_dir_cluster,
    (setter) 0,
    (char *) "root directory cluster", NULL
  },
  {
    (char *) "fs_info_sector",
    (getter) tp_getter_fs_info_sector,
    (setter) 0,
    (char *) "filesystem information sector", NULL
  },
  {
    (char *) "backup_boot_sector",
    (getter) tp_getter_backup_boot_sector,
    (setter) 0,
    (char *) "backup boot sector", NULL
  },
  {
    (char *) "fat_entry_size",
    (getter) tp_getter_fat_entry_size,
    (setter) 0,
    (char *) "FAT entry size in bits", NULL
  },
  {NULL, NULL, 0, NULL, NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_vfat: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject filesystem_filesystem_vfat_t =
{
  PyVarObject_HEAD_INIT (NULL, 0)
  "mobius.filesystem.filesystem_vfat",         		// tp_name
  sizeof (filesystem_filesystem_vfat_o),  		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) tp_dealloc,	                     	// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_vfat class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                  	         	// tp_methods
  0,                                          		// tp_members
  tp_getset,             	                      	// tp_getset
  &filesystem_filesystem_t,              		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0,                                          		// tp_new
  0,                                       		// tp_free
  0,                                       		// tp_is_gc
  0,                                       		// tp_bases
  0,                                       		// tp_mro
  0,                                       		// tp_cache
  0,                                       		// tp_subclasses
  0,                                       		// tp_weaklist
  0,                                       		// tp_del
  0,                                       		// tp_version_tag
};
