// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "filesystem.h"
#include "disk/disk.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief function get_filesystems
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject*
func_get_filesystems (PyObject *, PyObject *args)
{
  // parse arguments
  PyObject *arg_disk;

  if (!PyArg_ParseTuple (args, "O!", &disk_disk_t, &arg_disk))
    return nullptr;

  mobius::disk::disk *disk_p = ((disk_disk_o *) arg_disk)->obj;

  // create list
  PyObject *ret = PyList_New (0);

  if (ret == nullptr)
    return nullptr;

  // run C++ code
  try
    {
      auto filesystems = mobius::filesystem::get_filesystems (*disk_p);

      for (const auto& fs : filesystems)
        {
          PyObject *item = PyMobius_Filesystem_Filesystem_from_cpp (fs);

          if (item)        // append object to the list
            {
              PyList_Append (ret, (PyObject *) item);
              Py_DECREF (item);
            }
          else
            {
              Py_CLEAR (ret);
              return nullptr;
            }
        }
    }
  catch (const std::runtime_error& e)
    {
      PyErr_SetString (PyExc_Exception, e.what ());
      Py_CLEAR (ret);
      ret = nullptr;
    }

  return ret;
}
