// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief  C++ API module wrapper
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "api_filesystem_ext2.h"
#include "api_filesystem_hfs.h"
#include "api_filesystem_iso.h"
#include "api_filesystem_ntfs.h"
#include "api_filesystem_vfat.h"
#include "api_dataholder.h"
#include <mobius/filesystem/filesystem_get_metadata.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief function mobius.api.get_filesystem_metadata
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject*
func_get_filesystem_metadata (PyObject *, PyObject *args)
{
  // parse arguments
  PyObject *arg_filesystem;

  if (!PyArg_ParseTuple (args, "O", &arg_filesystem))
    return nullptr;

  mobius::filesystem::filesystem fs;
  
  if (arg_filesystem->ob_type == &api_filesystem_ext2_t)
    fs = *(((api_filesystem_ext2_o *) arg_filesystem)->obj);

  else if (arg_filesystem->ob_type == &api_filesystem_hfs_t)
    fs = *(((api_filesystem_hfs_o *) arg_filesystem)->obj);

  else if (arg_filesystem->ob_type == &api_filesystem_iso_t)
    fs = *(((api_filesystem_iso_o *) arg_filesystem)->obj);

  else if (arg_filesystem->ob_type == &api_filesystem_ntfs_t)
    fs = *(((api_filesystem_ntfs_o *) arg_filesystem)->obj);

  else if (arg_filesystem->ob_type == &api_filesystem_vfat_t)
    fs = *(((api_filesystem_vfat_o *) arg_filesystem)->obj);

  else
    {
      PyErr_SetString (PyExc_TypeError, "invalid filesystem type");  
      return nullptr;
    }

  // create list
  PyObject *ret = PyList_New (0);
  if (!ret)
    return nullptr;

  // populate list
  for (auto data : mobius::filesystem::get_metadata (fs))
    {
      // create attr object
      api_dataholder_o *pyobj = api_dataholder_new ();
      if (!pyobj)
        {
          Py_CLEAR (ret);
          return nullptr;
        }

      api_dataholder_setattr (pyobj, "name", std::get<0>(data));
      api_dataholder_setattr (pyobj, "description", std::get<1>(data));
      api_dataholder_setattr (pyobj, "datatype", std::get<2>(data));
      api_dataholder_setattr (pyobj, "value", std::get<3>(data));
      PyList_Append (ret, (PyObject *) pyobj);
    }

  return ret;
}
