// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "api_filesystem_ntfs.h"
#include "api_datetime.h"
#include <mobius/filesystem/filesystem_ntfs.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief api_filesystem_ntfs: tp_new
//! \param type type object
//! \param args argument list
//! \param kwds keywords dict
//! \return new api.filesystem_ntfs object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_tp_new (PyTypeObject *type, PyObject *args, PyObject *)
{
  // if (!PyArg_ParseTuple (args, "|s", &arg_uri))
  //   return nulptr;

  api_filesystem_ntfs_o *self = (api_filesystem_ntfs_o *) type->tp_alloc (type, 0);
  if (self)
    {
  //  try
  //    {
  //      if (arg_uri)
  //        self->obj = new mobius::filesystem::filesystem_ntfs (arg_uri);
  //      else
  //        self->obj = new mobius::filesystem::filesystem_ntfs ();
  //    }
  //  catch (const std::runtime_error& e)
  //    {
  //      Py_DECREF (self);
  //      PyErr_SetString (PyExc_IOError, e.what ());
  //      self = nulptr;
  //    }
    }

  return (PyObject *) self;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_filesystem_ntfs_tp_dealloc (api_filesystem_ntfs_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_offset (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_size (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_name (api_filesystem_ntfs_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: fs_type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_fs_type (api_filesystem_ntfs_o *self)
{
  return PyString_FromString (self->obj->get_fs_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: oem_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_oem_name (api_filesystem_ntfs_o *self)
{
  return PyString_FromString (self->obj->get_oem_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_sectors (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: sector_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_sector_size (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sector_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: sectors_per_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_sectors_per_cluster (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: cluster_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_cluster_size (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_cluster_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: reserved_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_reserved_sectors (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_reserved_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: media_descriptor getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_media_descriptor (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_media_descriptor ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: sectors_per_track getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_sectors_per_track (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_track ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: heads getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_heads (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_heads ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: hidden_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_hidden_sectors (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_hidden_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: mft_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_mft_cluster (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: mft_mirror_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_mft_mirror_cluster (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_mirror_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: mft_offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_mft_offset (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: mft_mirror_offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_mft_mirror_offset (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_mirror_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: clusters_per_frs getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_clusters_per_frs (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_frs ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: frs_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_frs_size (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_frs_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: clusters_per_index_block getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_clusters_per_index_block (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_index_block ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: volume_serial_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_volume_serial_number (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_volume_serial_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: checksum getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ntfs_getter_checksum (api_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_checksum ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_filesystem_ntfs_getsetters[] =
{
  {
    (char *) "offset",
    (getter) api_filesystem_ntfs_getter_offset,
    (setter) 0,
    (char *) "offset in bytes", NULL
  },
  {
    (char *) "size",
    (getter) api_filesystem_ntfs_getter_size,
    (setter) 0,
    (char *) "filesystem size in bytes", NULL
  },
  {
    (char *) "name",
    (getter) api_filesystem_ntfs_getter_name,
    (setter) 0,
    (char *) "filesystem name", NULL
  },
  {
    (char *) "fs_type",
    (getter) api_filesystem_ntfs_getter_fs_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "oem_name",
    (getter) api_filesystem_ntfs_getter_oem_name,
    (setter) 0,
    (char *) "OEM name", NULL
  },
  {
    (char *) "sectors",
    (getter) api_filesystem_ntfs_getter_sectors,
    (setter) 0,
    (char *) "number of sectors", NULL
  },
  {
    (char *) "sector_size",
    (getter) api_filesystem_ntfs_getter_sector_size,
    (setter) 0,
    (char *) "sector size in bytes", NULL
  },
  {
    (char *) "sectors_per_cluster",
    (getter) api_filesystem_ntfs_getter_sectors_per_cluster,
    (setter) 0,
    (char *) "sectors per cluster", NULL
  },
  {
    (char *) "cluster_size",
    (getter) api_filesystem_ntfs_getter_cluster_size,
    (setter) 0,
    (char *) "cluster size in bytes", NULL
  },
  {
    (char *) "reserved_sectors",
    (getter) api_filesystem_ntfs_getter_reserved_sectors,
    (setter) 0,
    (char *) "number of reserved sectors", NULL
  },
  {
    (char *) "media_descriptor",
    (getter) api_filesystem_ntfs_getter_media_descriptor,
    (setter) 0,
    (char *) "media descriptor", NULL
  },
  {
    (char *) "sectors_per_track",
    (getter) api_filesystem_ntfs_getter_sectors_per_track,
    (setter) 0,
    (char *) "sectors per track", NULL
  },
  {
    (char *) "heads",
    (getter) api_filesystem_ntfs_getter_heads,
    (setter) 0,
    (char *) "number of heads", NULL
  },
  {
    (char *) "hidden_sectors",
    (getter) api_filesystem_ntfs_getter_hidden_sectors,
    (setter) 0,
    (char *) "number of hidden sectors", NULL
  },
  {
    (char *) "mft_cluster",
    (getter) api_filesystem_ntfs_getter_mft_cluster,
    (setter) 0,
    (char *) "$MFT cluster", NULL
  },
  {
    (char *) "mft_mirror_cluster",
    (getter) api_filesystem_ntfs_getter_mft_mirror_cluster,
    (setter) 0,
    (char *) "$MFTMirr cluster", NULL
  },
  {
    (char *) "mft_offset",
    (getter) api_filesystem_ntfs_getter_mft_offset,
    (setter) 0,
    (char *) "$MFT offset", NULL
  },
  {
    (char *) "mft_mirror_offset",
    (getter) api_filesystem_ntfs_getter_mft_mirror_offset,
    (setter) 0,
    (char *) "$MFTMirr offset", NULL
  },
  {
    (char *) "clusters_per_frs",
    (getter) api_filesystem_ntfs_getter_clusters_per_frs,
    (setter) 0,
    (char *) "clusters per file record segment", NULL
  },
  {
    (char *) "frs_size",
    (getter) api_filesystem_ntfs_getter_frs_size,
    (setter) 0,
    (char *) "file record segment size in bytes", NULL
  },
  {
    (char *) "clusters_per_index_block",
    (getter) api_filesystem_ntfs_getter_clusters_per_index_block,
    (setter) 0,
    (char *) "clusters per index block", NULL
  },
  {
    (char *) "volume_serial_number",
    (getter) api_filesystem_ntfs_getter_volume_serial_number,
    (setter) 0,
    (char *) "volume serial number", NULL
  },
  {
    (char *) "checksum",
    (getter) api_filesystem_ntfs_getter_checksum,
    (setter) 0,
    (char *) "checksum", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ntfs: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_filesystem_ntfs_t =
{
  PyObject_HEAD_INIT (0)
  0,                                          		// ob_size
  "api.filesystem_ntfs",                      		// tp_name
  sizeof (api_filesystem_ntfs_o),             		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) api_filesystem_ntfs_tp_dealloc,		// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_ntfs class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                          		// tp_methods
  0,                                          		// tp_members
  api_filesystem_ntfs_getsetters,             		// tp_getset
  0,                                          		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0                                           		// tp_new
};
