// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "api_filesystem_ext2.h"
#include "api_datetime.h"
#include <mobius/filesystem/filesystem_ext2.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_filesystem_ext2_tp_dealloc (api_filesystem_ext2_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_offset (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_size (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_name (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: fs_type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_fs_type (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_fs_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: volume_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_volume_uuid (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_volume_uuid ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: volume_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_volume_name (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_volume_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: creator_os getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_creator_os (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_creator_os ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: inodes_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_inodes_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inodes_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_blocks_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: root_blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_root_blocks_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_root_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: free_blocks_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_free_blocks_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_free_blocks_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: free_inodes_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_free_inodes_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_free_inodes_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: first_data_block getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_first_data_block (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_first_data_block ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_block_size (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: cluster_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_cluster_size (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_cluster_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: blocks_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_blocks_per_group (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_blocks_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: clusters_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_clusters_per_group (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: inodes_per_group getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_inodes_per_group (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inodes_per_group ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_creation_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: last_mount_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_last_mount_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_mount_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: last_write_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_last_write_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_write_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: last_check_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_last_check_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_check_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: first_error_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_first_error_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_first_error_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: last_error_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_last_error_time (api_filesystem_ext2_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_error_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_mount_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: max_mount_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_max_mount_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_max_mount_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: state getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_state (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_state ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: errors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_errors (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_errors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: error_count getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_error_count (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_error_count ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: minor_revision_level getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_minor_revision_level (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_minor_revision_level ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: check_interval getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_check_interval (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_check_interval ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: revision_level getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_revision_level (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_revision_level ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: def_resuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_def_resuid (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_def_resuid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: def_resgid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_def_resgid (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_def_resgid ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: first_inode getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_first_inode (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_first_inode ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: inode_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_inode_size (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_inode_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: block_group_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_block_group_number (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_block_group_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: feature_compat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_feature_compat (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_compat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: feature_incompat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_feature_incompat (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_incompat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: feature_read_only getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_feature_read_only (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_feature_read_only ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: last_mount_point getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_last_mount_point (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_last_mount_point ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: journal_uuid getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_journal_uuid (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_journal_uuid ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: journal_inode getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_journal_inode (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_journal_inode ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: journal_device getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_journal_device (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_journal_device ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: default_hash_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_default_hash_version (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_default_hash_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: default_mount_options getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_default_mount_options (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_default_mount_options ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: mount_options getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_mount_options (api_filesystem_ext2_o *self)
{
  return PyString_FromString (self->obj->get_mount_options ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: kib_written getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_kib_written (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_kib_written ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: checksum getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_ext2_getter_checksum (api_filesystem_ext2_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_checksum ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_filesystem_ext2_getsetters[] =
{
  {
    (char *) "offset",
    (getter) api_filesystem_ext2_getter_offset,
    (setter) 0,
    (char *) "offset in bytes", NULL
  },
  {
    (char *) "size",
    (getter) api_filesystem_ext2_getter_size,
    (setter) 0,
    (char *) "filesystem size in bytes", NULL
  },
  {
    (char *) "name",
    (getter) api_filesystem_ext2_getter_name,
    (setter) 0,
    (char *) "filesystem name", NULL
  },
  {
    (char *) "fs_type",
    (getter) api_filesystem_ext2_getter_fs_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "volume_uuid",
    (getter) api_filesystem_ext2_getter_volume_uuid,
    (setter) 0,
    (char *) "volume UUID", NULL
  },
  {
    (char *) "volume_name",
    (getter) api_filesystem_ext2_getter_volume_name,
    (setter) 0,
    (char *) "volume name", NULL
  },
  {
    (char *) "creator_os",
    (getter) api_filesystem_ext2_getter_creator_os,
    (setter) 0,
    (char *) "creator operating system", NULL
  },
  {
    (char *) "inodes_count",
    (getter) api_filesystem_ext2_getter_inodes_count,
    (setter) 0,
    (char *) "total inode count", NULL
  },
  {
    (char *) "blocks_count",
    (getter) api_filesystem_ext2_getter_blocks_count,
    (setter) 0,
    (char *) "total block count", NULL
  },
  {
    (char *) "root_blocks_count",
    (getter) api_filesystem_ext2_getter_root_blocks_count,
    (setter) 0,
    (char *) "number of blocks allocated by root", NULL
  },
  {
    (char *) "free_blocks_count",
    (getter) api_filesystem_ext2_getter_free_blocks_count,
    (setter) 0,
    (char *) "free blocks count", NULL
  },
  {
    (char *) "free_inodes_count",
    (getter) api_filesystem_ext2_getter_free_inodes_count,
    (setter) 0,
    (char *) "free inode count", NULL
  },
  {
    (char *) "first_data_block",
    (getter) api_filesystem_ext2_getter_first_data_block,
    (setter) 0,
    (char *) "first data block", NULL
  },
  {
    (char *) "block_size",
    (getter) api_filesystem_ext2_getter_block_size,
    (setter) 0,
    (char *) "block size in bytes", NULL
  },
  {
    (char *) "cluster_size",
    (getter) api_filesystem_ext2_getter_cluster_size,
    (setter) 0,
    (char *) "cluster size in bytes", NULL
  },
  {
    (char *) "blocks_per_group",
    (getter) api_filesystem_ext2_getter_blocks_per_group,
    (setter) 0,
    (char *) "blocks per group", NULL
  },
  {
    (char *) "clusters_per_group",
    (getter) api_filesystem_ext2_getter_clusters_per_group,
    (setter) 0,
    (char *) "clusters per group", NULL
  },
  {
    (char *) "inodes_per_group",
    (getter) api_filesystem_ext2_getter_inodes_per_group,
    (setter) 0,
    (char *) "inodes per group", NULL
  },
  {
    (char *) "creation_time",
    (getter) api_filesystem_ext2_getter_creation_time,
    (setter) 0,
    (char *) "filesystem creation date/time", NULL
  },
  {
    (char *) "last_mount_time",
    (getter) api_filesystem_ext2_getter_last_mount_time,
    (setter) 0,
    (char *) "last mount date/time", NULL
  },
  {
    (char *) "last_write_time",
    (getter) api_filesystem_ext2_getter_last_write_time,
    (setter) 0,
    (char *) "last write date/time", NULL
  },
  {
    (char *) "last_check_time",
    (getter) api_filesystem_ext2_getter_last_check_time,
    (setter) 0,
    (char *) "last check date/time", NULL
  },
  {
    (char *) "first_error_time",
    (getter) api_filesystem_ext2_getter_first_error_time,
    (setter) 0,
    (char *) "first error date/time", NULL
  },
  {
    (char *) "last_error_time",
    (getter) api_filesystem_ext2_getter_last_error_time,
    (setter) 0,
    (char *) "last error date/time", NULL
  },
  {
    (char *) "mount_count",
    (getter) api_filesystem_ext2_getter_mount_count,
    (setter) 0,
    (char *) "number of mounts since the last fsck", NULL
  },
  {
    (char *) "max_mount_count",
    (getter) api_filesystem_ext2_getter_max_mount_count,
    (setter) 0,
    (char *) "number of mounts for mandatory fsck", NULL
  },
  {
    (char *) "state",
    (getter) api_filesystem_ext2_getter_state,
    (setter) 0,
    (char *) "file system state", NULL
  },
  {
    (char *) "errors",
    (getter) api_filesystem_ext2_getter_errors,
    (setter) 0,
    (char *) "action when detecting errors", NULL
  },
  {
    (char *) "error_count",
    (getter) api_filesystem_ext2_getter_error_count,
    (setter) 0,
    (char *) "number of errors", NULL
  },
  {
    (char *) "minor_revision_level",
    (getter) api_filesystem_ext2_getter_minor_revision_level,
    (setter) 0,
    (char *) "minor revision level", NULL
  },
  {
    (char *) "check_interval",
    (getter) api_filesystem_ext2_getter_check_interval,
    (setter) 0,
    (char *) "max check interval time in seconds", NULL
  },
  {
    (char *) "revision_level",
    (getter) api_filesystem_ext2_getter_revision_level,
    (setter) 0,
    (char *) "revision level", NULL
  },
  {
    (char *) "def_resuid",
    (getter) api_filesystem_ext2_getter_def_resuid,
    (setter) 0,
    (char *) "default uid for reserved blocks", NULL
  },
  {
    (char *) "def_resgid",
    (getter) api_filesystem_ext2_getter_def_resgid,
    (setter) 0,
    (char *) "default gid for reserved blocks", NULL
  },
  {
    (char *) "first_inode",
    (getter) api_filesystem_ext2_getter_first_inode,
    (setter) 0,
    (char *) "first non-reserved inode", NULL
  },
  {
    (char *) "inode_size",
    (getter) api_filesystem_ext2_getter_inode_size,
    (setter) 0,
    (char *) "inode size in bytes", NULL
  },
  {
    (char *) "block_group_number",
    (getter) api_filesystem_ext2_getter_block_group_number,
    (setter) 0,
    (char *) "block group number of this superblock", NULL
  },
  {
    (char *) "feature_compat",
    (getter) api_filesystem_ext2_getter_feature_compat,
    (setter) 0,
    (char *) "compatible features flags", NULL
  },
  {
    (char *) "feature_incompat",
    (getter) api_filesystem_ext2_getter_feature_incompat,
    (setter) 0,
    (char *) "incompatible features flags", NULL
  },
  {
    (char *) "feature_read_only",
    (getter) api_filesystem_ext2_getter_feature_read_only,
    (setter) 0,
    (char *) "readonly compatible features flags", NULL
  },
  {
    (char *) "last_mount_point",
    (getter) api_filesystem_ext2_getter_last_mount_point,
    (setter) 0,
    (char *) "last mounting point", NULL
  },
  {
    (char *) "journal_uuid",
    (getter) api_filesystem_ext2_getter_journal_uuid,
    (setter) 0,
    (char *) "journal superblock UUID", NULL
  },
  {
    (char *) "journal_inode",
    (getter) api_filesystem_ext2_getter_journal_inode,
    (setter) 0,
    (char *) "journal inode number", NULL
  },
  {
    (char *) "journal_device",
    (getter) api_filesystem_ext2_getter_journal_device,
    (setter) 0,
    (char *) "journal device number", NULL
  },
  {
    (char *) "default_hash_version",
    (getter) api_filesystem_ext2_getter_default_hash_version,
    (setter) 0,
    (char *) "default hash algorithm", NULL
  },
  {
    (char *) "default_mount_options",
    (getter) api_filesystem_ext2_getter_default_mount_options,
    (setter) 0,
    (char *) "default mount options", NULL
  },
  {
    (char *) "mount_options",
    (getter) api_filesystem_ext2_getter_mount_options,
    (setter) 0,
    (char *) "mount options", NULL
  },
  {
    (char *) "kib_written",
    (getter) api_filesystem_ext2_getter_kib_written,
    (setter) 0,
    (char *) "KiB written into this filesystem", NULL
  },
  {
    (char *) "checksum",
    (getter) api_filesystem_ext2_getter_checksum,
    (setter) 0,
    (char *) "superblock checksum", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_ext2: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_filesystem_ext2_t =
{
  PyObject_HEAD_INIT (0)
  0,                                          		// ob_size
  "api.filesystem_ext2",                      		// tp_name
  sizeof (api_filesystem_ext2_o),             		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) api_filesystem_ext2_tp_dealloc,		// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_ext2 class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                          		// tp_methods
  0,                                          		// tp_members
  api_filesystem_ext2_getsetters,             		// tp_getset
  0,                                          		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0                                           		// tp_new
};
