/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.parser;

import java.util.Hashtable;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.parser.AuthorizationParser;
import sip4me.gov.nist.siplite.parser.CSeqParser;
import sip4me.gov.nist.siplite.parser.CallIDParser;
import sip4me.gov.nist.siplite.parser.ContactParser;
import sip4me.gov.nist.siplite.parser.ContentLengthParser;
import sip4me.gov.nist.siplite.parser.ContentTypeParser;
import sip4me.gov.nist.siplite.parser.DateParser;
import sip4me.gov.nist.siplite.parser.EventParser;
import sip4me.gov.nist.siplite.parser.ExpiresParser;
import sip4me.gov.nist.siplite.parser.FromParser;
import sip4me.gov.nist.siplite.parser.HeaderParser;
import sip4me.gov.nist.siplite.parser.Lexer;
import sip4me.gov.nist.siplite.parser.MaxForwardsParser;
import sip4me.gov.nist.siplite.parser.ProxyAuthenticateParser;
import sip4me.gov.nist.siplite.parser.ProxyAuthorizationParser;
import sip4me.gov.nist.siplite.parser.RecordRouteParser;
import sip4me.gov.nist.siplite.parser.RouteParser;
import sip4me.gov.nist.siplite.parser.ToParser;
import sip4me.gov.nist.siplite.parser.ViaParser;
import sip4me.gov.nist.siplite.parser.WWWAuthenticateParser;

public class ParserFactory {
    private static Hashtable parserTable = new Hashtable();
    private static Class[] constructorArgs = new Class[1];

    static {
        ParserFactory.constructorArgs[0] = new String().getClass();
        parserTable.put("t", new ToParser().getClass());
        parserTable.put("To".toLowerCase(), new ToParser().getClass());
        parserTable.put("From".toLowerCase(), new FromParser().getClass());
        parserTable.put("f", new FromParser().getClass());
        parserTable.put("CSeq".toLowerCase(), new CSeqParser().getClass());
        parserTable.put("Via".toLowerCase(), new ViaParser().getClass());
        parserTable.put("v", new ViaParser().getClass());
        parserTable.put("Contact".toLowerCase(), new ContactParser().getClass());
        parserTable.put("m", new ContactParser().getClass());
        parserTable.put("Content-Type".toLowerCase(), new ContentTypeParser().getClass());
        parserTable.put("c", new ContentTypeParser().getClass());
        parserTable.put("Content-Length".toLowerCase(), new ContentLengthParser().getClass());
        parserTable.put("l", new ContentLengthParser().getClass());
        parserTable.put("Authorization".toLowerCase(), new AuthorizationParser().getClass());
        parserTable.put("WWW-Authenticate".toLowerCase(), new WWWAuthenticateParser().getClass());
        parserTable.put("Call-Id".toLowerCase(), new CallIDParser().getClass());
        parserTable.put("i", new CallIDParser().getClass());
        parserTable.put("Route".toLowerCase(), new RouteParser().getClass());
        parserTable.put("Record-Route".toLowerCase(), new RecordRouteParser().getClass());
        parserTable.put("Date".toLowerCase(), new DateParser().getClass());
        parserTable.put("Proxy-Authorization".toLowerCase(), new ProxyAuthorizationParser().getClass());
        parserTable.put("Proxy-Authenticate".toLowerCase(), new ProxyAuthenticateParser().getClass());
        parserTable.put("Max-Forwards".toLowerCase(), new MaxForwardsParser().getClass());
        parserTable.put("Expires".toLowerCase(), new ExpiresParser().getClass());
        parserTable.put("Event".toLowerCase(), new EventParser().getClass());
        parserTable.put("o", new EventParser().getClass());
    }

    public static HeaderParser createParser(String line) throws ParseException {
        String headerName = Lexer.getHeaderName(line);
        String headerValue = Lexer.getHeaderValue(line);
        if (headerName == null || headerValue == null) {
            throw new ParseException("The header name or value is null", 0);
        }
        Class parserClass = (Class)parserTable.get(headerName.toLowerCase());
        if (parserClass != null) {
            try {
                HeaderParser retval = (HeaderParser)parserClass.newInstance();
                retval.setHeaderToParse(line);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return null;
            }
        }
        return new HeaderParser(line);
    }
}

