/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.InternalErrorHandler;
import sip4me.gov.nist.core.NameValueList;
import sip4me.gov.nist.siplite.address.Address;
import sip4me.gov.nist.siplite.header.ParametersHeader;

public abstract class AddressParametersHeader
extends ParametersHeader {
    protected Address address;

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    protected AddressParametersHeader(String name) {
        super(name);
    }

    public Object getValue() {
        return this.address;
    }

    public String getDisplayName() {
        return this.address.getDisplayName();
    }

    public String getUserAtHostPort() {
        return this.address.getUserAtHostPort();
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        Address otherAddress = ((AddressParametersHeader)other).getAddress();
        if (otherAddress == null) {
            return false;
        }
        if (!otherAddress.equals(this.address)) {
            return false;
        }
        return this.parameters.equals(((AddressParametersHeader)other).parameters);
    }

    public String encodeBody() {
        if (this.address == null) {
            throw new RuntimeException("No body!");
        }
        StringBuffer retval = new StringBuffer();
        if (this.address.getAddressType() != 1) {
            retval.append("<");
        }
        retval.append(this.address.encode());
        if (this.address.getAddressType() != 1) {
            retval.append(">");
        }
        if (!this.parameters.isEmpty()) {
            retval.append(";").append(this.parameters.encode());
        }
        return retval.toString();
    }

    public Object clone() {
        try {
            AddressParametersHeader retval = (AddressParametersHeader)this.getClass().newInstance();
            if (this.address != null) {
                retval.address = (Address)this.address.clone();
            }
            if (this.parameters != null) {
                retval.parameters = (NameValueList)this.parameters.clone();
            }
            return retval;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }
}

