/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.address;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.siplite.address.UserInfo;

public class Authority
extends GenericObject {
    protected HostPort hostPort;
    protected UserInfo userInfo;

    public String encode() {
        if (this.userInfo != null) {
            return String.valueOf(this.userInfo.encode()) + "@" + this.hostPort.encode();
        }
        return this.hostPort.encode();
    }

    public boolean equals(Object other) {
        if (!other.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        Authority otherAuth = (Authority)other;
        if (!this.hostPort.equals(otherAuth.hostPort)) {
            return false;
        }
        return this.userInfo == null || otherAuth.userInfo == null || this.userInfo.equals(otherAuth.userInfo);
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getPassword() {
        if (this.userInfo == null) {
            return null;
        }
        return this.userInfo.password;
    }

    public String getUser() {
        return this.userInfo != null ? this.userInfo.user : null;
    }

    public Host getHost() {
        if (this.hostPort == null) {
            return null;
        }
        return this.hostPort.getHost();
    }

    public int getPort() {
        if (this.hostPort == null) {
            return -1;
        }
        return this.hostPort.getPort();
    }

    public void removePort() {
        if (this.hostPort != null) {
            this.hostPort.removePort();
        }
    }

    public void setPassword(String passwd) {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setPassword(passwd);
    }

    public void setUser(String user) {
        if (user == null) {
            return;
        }
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setUser(user);
    }

    public void setHost(Host host) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setHost(host);
    }

    public void setPort(int port) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setPort(port);
    }

    public void setHostPort(HostPort h) {
        this.hostPort = h;
    }

    public void setUserInfo(UserInfo u) {
        this.userInfo = u;
    }

    public void removeUserInfo() {
        this.userInfo = null;
    }

    public Object clone() {
        Authority retval = new Authority();
        retval.setUser(this.getUser());
        retval.setHostPort(this.getHostPort());
        return retval;
    }
}

