/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.IOException;
import sip4me.gov.nist.microedition.sip.SipClientConnectionImpl;
import sip4me.gov.nist.microedition.sip.SipConnectionNotifierImpl;
import sip4me.gov.nist.microedition.sip.SipDialogImpl;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.stack.SIPStackTimerTask;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipRefreshListener;

public class RefreshTask
extends SIPStackTimerTask {
    private Request request = null;
    private SipClientConnection sipClientConnection = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private final SipRefreshListener sipRefreshListener;

    public RefreshTask(Request request, SipConnectionNotifier sipConnectionNotifier, SipRefreshListener sipRefreshListener, SipClientConnection sipClientConnection) {
        this.request = request;
        this.sipConnectionNotifier = sipConnectionNotifier;
        this.sipRefreshListener = sipRefreshListener;
        this.sipClientConnection = sipClientConnection;
    }

    public void runTask() {
        Request clonedRequest = null;
        if (this.request.getMethod().equals("REGISTER")) {
            clonedRequest = (Request)this.request.clone();
        } else if (this.request.getMethod().equals("SUBSCRIBE")) {
            try {
                clonedRequest = ((SipDialogImpl)this.sipClientConnection.getDialog()).dialog.createRequest("SUBSCRIBE");
            }
            catch (SipException e) {
                clonedRequest = (Request)this.request.clone();
            }
        }
        if (clonedRequest.getHeader("Authorization") != null) {
            clonedRequest.removeHeader("Authorization");
            clonedRequest = ((SipClientConnectionImpl)this.sipClientConnection).authenticateRequest(clonedRequest);
        }
        if (clonedRequest.getCSeqHeaderNumber() == this.request.getCSeqHeaderNumber()) {
            CSeqHeader cseq = this.request.getCSeqHeader();
            cseq.setSequenceNumber(cseq.getSequenceNumber() + 1);
            clonedRequest.setCSeqHeader(cseq);
        }
        this.request = null;
        this.updateRequest(clonedRequest);
        try {
            this.sipClientConnection.send();
        }
        catch (sip4me.nist.javax.microedition.sip.SipException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public SipRefreshListener getSipRefreshListener() {
        return this.sipRefreshListener;
    }

    public SipConnectionNotifier getSipConnectionNotifier() {
        return this.sipConnectionNotifier;
    }

    public SipClientConnection getSipClientConnection() {
        return this.sipClientConnection;
    }

    public void updateRequest(Request request) {
        this.request = request;
        ((SipClientConnectionImpl)this.sipClientConnection).updateRequestFromRefresh(request);
    }

    public CallIdHeader getNewCallId() {
        return ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getNewCallId();
    }

    public Request getRequest() {
        return this.request;
    }
}

