/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.microedition.sip.RefreshTask;
import sip4me.gov.nist.microedition.sip.StackConnector;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipRefreshListener;

public class RefreshManager {
    private static RefreshManager instance = null;
    private Hashtable refreshTable = new Hashtable();
    private int idGenerator = 1;

    private RefreshManager() {
    }

    public static synchronized RefreshManager getInstance() {
        if (instance == null) {
            instance = new RefreshManager();
        }
        return instance;
    }

    public int createRefreshTask(Request request, SipConnectionNotifier sipConnectionNotifier, SipRefreshListener sipRefreshListener, SipClientConnection sipClientConnection) {
        int taskId = this.idGenerator++;
        RefreshTask refreshTask = new RefreshTask(request, sipConnectionNotifier, sipRefreshListener, sipClientConnection);
        this.refreshTable.put(String.valueOf(taskId), refreshTask);
        return taskId;
    }

    public void scheduleTask(String taskId, int expires) {
        block5: {
            RefreshTask refreshTask = (RefreshTask)this.refreshTable.get(taskId);
            if (refreshTask == null) {
                return;
            }
            if (expires == -1) {
                return;
            }
            if (expires >= 0) {
                try {
                    Timer timer = StackConnector.getInstance().getStackTimer();
                    refreshTask = new RefreshTask(refreshTask.getRequest(), refreshTask.getSipConnectionNotifier(), refreshTask.getSipRefreshListener(), refreshTask.getSipClientConnection());
                    this.refreshTable.put(taskId, refreshTask);
                    timer.schedule((TimerTask)refreshTask, expires * 850);
                }
                catch (IOException e) {
                    if (!LogWriter.needsLogging) break block5;
                    LogWriter.logMessage(2, "Can't get stackTimer to schedule refresh for taskID " + taskId);
                }
            }
        }
    }

    public RefreshTask getTask(String taskId) {
        if (taskId == null) {
            return null;
        }
        return (RefreshTask)this.refreshTable.get(taskId);
    }

    public void removeTask(String taskId) {
        this.refreshTable.remove(taskId);
    }
}

