/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.parser;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Token;
import sip4me.gov.nist.javax.sdp.fields.ConnectionAddress;
import sip4me.gov.nist.javax.sdp.fields.ConnectionField;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.parser.Lexer;
import sip4me.gov.nist.javax.sdp.parser.SDPParser;

public class ConnectionFieldParser
extends SDPParser {
    public ConnectionFieldParser(String connectionField) {
        this.lexer = new Lexer("charLexer", connectionField);
    }

    protected ConnectionFieldParser() {
    }

    public ConnectionAddress connectionAddress(String address) {
        ConnectionAddress connectionAddress = new ConnectionAddress();
        int begin = address.indexOf("/");
        if (begin != -1) {
            connectionAddress.setAddress(new Host(address.substring(0, begin)));
            int middle = address.indexOf("/", begin + 1);
            if (middle != -1) {
                String ttl = address.substring(begin + 1, middle);
                connectionAddress.setTtl(Integer.parseInt(ttl.trim()));
                String addressNumber = address.substring(middle + 1);
                connectionAddress.setPort(Integer.parseInt(addressNumber.trim()));
            } else {
                String ttl = address.substring(begin + 1);
                connectionAddress.setTtl(Integer.parseInt(ttl.trim()));
            }
        } else {
            connectionAddress.setAddress(new Host(address));
        }
        return connectionAddress;
    }

    public ConnectionField connectionField() throws ParseException {
        try {
            this.lexer.match(99);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            ConnectionField connectionField = new ConnectionField();
            this.lexer.match(4095);
            this.lexer.SPorHT();
            Token token = this.lexer.getNextToken();
            connectionField.setNettype(token.getTokenValue());
            this.lexer.match(4095);
            this.lexer.SPorHT();
            token = this.lexer.getNextToken();
            connectionField.setAddressType(token.getTokenValue());
            this.lexer.SPorHT();
            String rest = this.lexer.getRest();
            ConnectionAddress connectionAddress = this.connectionAddress(rest.trim());
            connectionField.setAddress(connectionAddress);
            return connectionField;
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
    }

    public SDPField parse() throws ParseException {
        return this.connectionField();
    }
}

