/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.fields.SDPObjectList;
import sip4me.gov.nist.javax.sdp.fields.ZoneAdjustment;

public class ZoneField
extends SDPField {
    protected SDPObjectList zoneAdjustments = new SDPObjectList();

    public Object clone() {
        ZoneField retval = new ZoneField();
        retval.zoneAdjustments = (SDPObjectList)this.zoneAdjustments.clone();
        return retval;
    }

    public ZoneField() {
        super("z=");
    }

    public void addZoneAdjustment(ZoneAdjustment za) {
        this.zoneAdjustments.addElement(za);
    }

    public SDPObjectList getZoneAdjustments() {
        return this.zoneAdjustments;
    }

    public String encode() {
        StringBuffer retval = new StringBuffer("z=");
        int i = 0;
        while (i < this.zoneAdjustments.size()) {
            ZoneAdjustment za = (ZoneAdjustment)this.zoneAdjustments.elementAt(i);
            if (i > 0) {
                retval.append(" ");
            }
            retval.append(za.encode());
            ++i;
        }
        retval.append("\r\n");
        return retval.toString();
    }

    public Hashtable getZoneAdjustments(boolean create) throws SdpParseException {
        Hashtable<Date, Integer> result = new Hashtable<Date, Integer>();
        SDPObjectList zoneAdjustments = this.getZoneAdjustments();
        if (zoneAdjustments == null) {
            if (create) {
                return new Hashtable();
            }
            return null;
        }
        int i = 0;
        while (i < zoneAdjustments.size()) {
            ZoneAdjustment zone = (ZoneAdjustment)zoneAdjustments.elementAt(i);
            Long l = new Long(zone.getTime());
            Integer time = new Integer((int)l.longValue());
            Date date = new Date(zone.getTime());
            result.put(date, time);
            ++i;
        }
        return result;
    }

    public void setZoneAdjustments(Hashtable map) throws SdpException {
        if (map == null) {
            throw new SdpException("The map is null");
        }
        SDPObjectList zoneAdjustments = this.getZoneAdjustments();
        Enumeration e = map.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Date) {
                Date date = (Date)o;
                ZoneAdjustment zone = new ZoneAdjustment();
                zone.setTime(date.getTime());
                this.addZoneAdjustment(zone);
                continue;
            }
            throw new SdpException("The map is not well-formated ");
        }
    }

    public void setTypedTime(boolean typedTime) {
    }

    public boolean getTypedTime() {
        return false;
    }
}

