/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

public class Host {
    protected static final int HOSTNAME = 1;
    protected static final int IPV4ADDRESS = 2;
    protected static final int IPV6ADDRESS = 3;
    protected String hostname;
    protected int addressType;

    public Host() {
        this.addressType = 1;
    }

    public Host(String hostName) throws IllegalArgumentException {
        if (hostName == null) {
            throw new IllegalArgumentException("null host name");
        }
        this.hostname = hostName;
        if (this.isIPv6Address(hostName)) {
            this.addressType = 3;
        }
        this.addressType = 2;
    }

    public Host(String name, int addrType) {
        this.addressType = addrType;
        this.hostname = name.trim().toLowerCase();
    }

    public String encode() {
        if (this.addressType == 3 && !this.isIPv6Reference(this.hostname)) {
            return "[" + this.hostname + "]";
        }
        return this.hostname;
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Host otherHost = (Host)obj;
        return otherHost.hostname.equals(this.hostname);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAddress() {
        return this.hostname;
    }

    public void setHostname(String h) {
        this.addressType = this.isIPv6Address(h) ? 3 : 1;
        if (h != null) {
            this.hostname = h.trim().toLowerCase();
        }
    }

    public void setHostAddress(String address) {
        this.addressType = this.isIPv6Address(address) ? 3 : 2;
        if (address != null) {
            this.hostname = address.trim();
        }
    }

    public void setAddress(String address) {
        this.setHostAddress(address);
    }

    public boolean isHostname() {
        return this.addressType == 1;
    }

    public boolean isIPAddress() {
        return this.addressType != 1;
    }

    private boolean isIPv6Address(String address) {
        return address != null && address.indexOf(58) != -1;
    }

    private boolean isIPv6Reference(String address) {
        return address.charAt(0) == '[' && address.charAt(address.length() - 1) == ']';
    }

    public Object clone() {
        Host retval = new Host();
        retval.addressType = this.addressType;
        retval.hostname = new String(this.hostname);
        return retval;
    }
}

