/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.sal;

import java.util.Vector;
import org.linphone.jortp.PayloadType;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalMediaDescription;
import org.linphone.sal.SalStreamDescription;

public class OfferAnswerHelper {
    public static SalMediaDescription computeOutgoing(SalMediaDescription local, SalMediaDescription remote) {
        SalMediaDescription md = SalFactory.instance().createSalMediaDescription();
        md.setAddress(remote.getAddress());
        int i = 0;
        while (i < remote.getNumStreams()) {
            SalStreamDescription rsd = remote.getStream(i);
            SalStreamDescription sd = OfferAnswerHelper.intersect(local.getStream(i), rsd);
            sd.setAddress(rsd.getAddress());
            sd.setPort(rsd.getPort());
            sd.setPtime(rsd.getPtime());
            md.addStreamDescription(sd);
            ++i;
        }
        return md;
    }

    public static AnswerResult computeIncoming(SalMediaDescription local, SalMediaDescription remote) {
        AnswerResult ar = new AnswerResult();
        SalMediaDescription answer = SalFactory.instance().createSalMediaDescription();
        SalMediaDescription result = SalFactory.instance().createSalMediaDescription();
        ar.mAnswer = answer;
        ar.mResult = result;
        answer.setAddress(local.getAddress());
        result.setAddress(remote.getAddress());
        int i = 0;
        while (i < remote.getNumStreams()) {
            SalStreamDescription lsd = local.getStream(i);
            SalStreamDescription rsd = remote.getStream(i);
            SalStreamDescription sd = OfferAnswerHelper.intersect(local.getStream(i), rsd);
            sd.setPort(rsd.getPort());
            sd.setPtime(rsd.getPtime());
            sd.setAddress(rsd.getAddress());
            SalStreamDescription asd = new SalStreamDescription();
            asd.setPayloadTypes(sd.getPayloadTypes());
            asd.setProto(sd.getProto());
            asd.setType(sd.getType());
            asd.setPtime(lsd.getPtime());
            asd.setPort(lsd.getPort());
            result.addStreamDescription(sd);
            answer.addStreamDescription(asd);
            ++i;
        }
        return ar;
    }

    private static SalStreamDescription intersect(SalStreamDescription local, SalStreamDescription remote) {
        SalStreamDescription sd = new SalStreamDescription();
        PayloadType[] lpts = local.getPayloadTypes();
        PayloadType[] rpts = remote.getPayloadTypes();
        Vector<PayloadType> result = new Vector<PayloadType>();
        sd.setProto(local.getProto());
        sd.setType(local.getType());
        int i = 0;
        while (i < lpts.length) {
            PayloadType lpt = lpts[i];
            int j = 0;
            while (j < rpts.length) {
                PayloadType rpt = rpts[j];
                if (lpt.getMimeType().equalsIgnoreCase(rpt.getMimeType()) && lpt.getClockRate() == rpt.getClockRate()) {
                    PayloadType matched = lpt.clone();
                    matched.setNumber(rpt.getNumber());
                    matched.setSendFmtp(rpt.getRecvFmtp());
                    result.addElement(matched);
                }
                ++j;
            }
            ++i;
        }
        Object[] ptr = new PayloadType[result.size()];
        result.copyInto(ptr);
        sd.setPayloadTypes((PayloadType[])ptr);
        return sd;
    }

    public static class AnswerResult {
        private SalMediaDescription mResult;
        private SalMediaDescription mAnswer;

        public SalMediaDescription getResult() {
            return this.mResult;
        }

        public SalMediaDescription getAnswer() {
            return this.mAnswer;
        }
    }
}

