/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jortp;

import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.ListHead;
import org.linphone.jortp.Logger;
import org.linphone.jortp.Node;
import org.linphone.jortp.RtpPacket;
import org.linphone.jortp.RtpPacketImpl;

abstract class JitterBuffer
extends ListHead {
    private int mCount = 0;
    private int mLastReturnedTs;
    private int mTimestampDiff = 0;
    private int mDelayTs = 0;
    private boolean mPermissive = false;
    private boolean mStarted = false;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("jortp");

    public void setPermissive(boolean val) {
        this.mPermissive = val;
    }

    public int getTimestampDiff() {
        return this.mTimestampDiff;
    }

    public int getDelayTs() {
        return this.mDelayTs;
    }

    public void put(RtpPacket p) {
        if (sLogger.isLevelEnabled(31)) {
            sLogger.debug("Packet is entering jitter buffer: " + p);
        }
        if (this.mStarted && !this.mPermissive && this.mLastReturnedTs - p.getTimestamp() > 0) {
            this.onDrop(p);
            p.recycle();
            if (sLogger.isLevelEnabled(31)) {
                sLogger.debug("Discarding incoming packet too old: mLastReturned=" + this.mLastReturnedTs + "timestamp=" + p.getTimestamp());
            }
            return;
        }
        if (this.empty()) {
            this.end().insertBefore((Node)((Object)p));
            ++this.mCount;
            return;
        }
        Node it = this.begin();
        while (it != this.end()) {
            RtpPacketImpl itp = (RtpPacketImpl)it;
            if (p.getSeqNumber() > itp.getSeqNumber()) {
                itp.insertBefore((RtpPacketImpl)p);
                ++this.mCount;
                return;
            }
            if (p.getSeqNumber() == itp.getSeqNumber()) {
                p.recycle();
                break;
            }
            it = it.getNext();
        }
    }

    public RtpPacket get(int ts) {
        RtpPacket itp = null;
        RtpPacket newer = null;
        if (!this.empty()) {
            RtpPacket first = (RtpPacket)((Object)this.begin());
            RtpPacket last = (RtpPacket)((Object)this.rend());
            this.mDelayTs = first.getTimestamp() - ts;
            this.mTimestampDiff = first.getTimestamp() - last.getTimestamp();
        }
        Node it = this.rend();
        while (it != this.rbegin()) {
            itp = (RtpPacket)((Object)it);
            if (this.mPermissive) {
                newer = itp;
                break;
            }
            if (!this.timestampNewerOrEqual(ts, itp.getTimestamp())) break;
            if (newer != null) {
                ((Node)((Object)newer)).remove();
                this.onDrop(newer);
                --this.mCount;
                newer.recycle();
            }
            newer = itp;
            it = it.getPrev();
        }
        if (newer != null) {
            this.mStarted = true;
            ((Node)((Object)newer)).remove();
            this.mLastReturnedTs = newer.getTimestamp();
            --this.mCount;
        }
        if (newer != null) {
            if (sLogger.isLevelEnabled(31)) {
                sLogger.debug("Looking for " + ts + " returning " + newer.getTimestamp());
            }
        } else if (sLogger.isLevelEnabled(31)) {
            sLogger.debug("Looking for " + ts + " returning nothing");
        }
        return newer;
    }

    public int getCount() {
        return this.mCount;
    }

    public void purge() {
        Node it;
        while ((it = this.popFront()) != null) {
            ((RtpPacket)((Object)it)).recycle();
        }
        this.mCount = 0;
        this.mStarted = false;
    }

    public abstract void onDrop(RtpPacket var1);

    private boolean timestampNewerOrEqual(int ts1, int ts2) {
        return ts1 - ts2 >= 0;
    }
}

