/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.gui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.pim.Contact;
import javax.microedition.pim.PIMException;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Display;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.KeywordFilterField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.component.TextField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.text.PhoneTextFilter;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.jlinphone.gui.LinphoneResource;
import org.linphone.jlinphone.gui.SearchableContactList;
import org.linphone.jlinphone.gui.TabFieldItem;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;

public class DialerField
extends VerticalFieldManager
implements TabFieldItem,
LinphoneResource {
    private VerticalFieldManager mOutcallFields = new VerticalFieldManager();
    private TextField mInputAddress;
    private KeywordFilterField mkeyWordField;
    private VerticalFieldManager mIncallFields = new VerticalFieldManager(0x1000000000000000L);
    RichTextField mDisplayNameField;
    TextField mPhoneNumberField;
    TextField mDurationField;
    CheckboxField mMute;
    CheckboxField mSpeaker;
    private static final Timer mTimer = new Timer();
    TimerTask mCallDurationTask;
    private static Logger sLogger = JOrtpFactory.instance().createLogger("Linphone");
    String mDisplayName;
    LinphoneCore mCore;
    static final int GREEN_BUTTON_KEY = 0x110000;
    PhoneTextFilter mPhoneTextFilter = new PhoneTextFilter();
    private static ResourceBundle mRes = ResourceBundle.getBundle((long)-8981235513634632902L, (String)"org.linphone.jlinphone.gui.Linphone");

    public DialerField(LinphoneCore aCore) {
        this.mCore = aCore;
        try {
            this.mkeyWordField = new SearchableContactList(new SearchableContactList.Listener(){

                public void onSelected(Contact selected) {
                    DialerField.this.setAddressAndDisplay(selected);
                }
            }).getKeywordFilterField();
        }
        catch (PIMException e) {
            sLogger.error("Cannot open contact list", e);
        }
        this.mkeyWordField.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                if (DialerField.this.mkeyWordField.getKeyword().length() == 0) {
                    DialerField.this.mkeyWordField.setKeyword(null);
                    DialerField.this.mInputAddress.setLabel("sip:");
                }
            }
        });
        this.mkeyWordField.setKeywordField(new TextField(0x80000000000000L));
        this.mkeyWordField.getKeywordField().setLabel(mRes.getString(4));
        this.mkeyWordField.getKeywordField().setEditable(false);
        this.mInputAddress = new TextField(0x40000000000000L){
            boolean mInDigitMode = true;

            protected boolean insert(char charater, int arg1) {
                char lNumber = DialerField.this.mPhoneTextFilter.convert(charater, 0);
                StringBuffer lnewKey = new StringBuffer(DialerField.this.mkeyWordField.getKeywordField().getText());
                DialerField.this.mkeyWordField.setKeyword(lnewKey.insert(this.getCursorPosition(), charater).toString());
                if (this.mInDigitMode && Character.digit(lNumber, 10) >= 0 && Character.digit(lNumber, 10) < 10) {
                    return super.insert(lNumber, arg1);
                }
                if (this.mInDigitMode) {
                    this.setText(DialerField.this.mkeyWordField.getKeyword());
                    this.mInDigitMode = false;
                    return true;
                }
                return super.insert(charater, arg1);
            }

            protected synchronized boolean backspace() {
                if (this.getCursorPosition() <= DialerField.this.mkeyWordField.getKeyword().length()) {
                    StringBuffer lnewKey = new StringBuffer(DialerField.this.mkeyWordField.getKeyword());
                    DialerField.this.mkeyWordField.setKeyword(lnewKey.delete(this.getCursorPosition() - 1, this.getCursorPosition()).toString());
                }
                return super.backspace();
            }

            protected boolean keyChar(char key, int status, int time) {
                DialerField.this.mDisplayName = null;
                if (this.getTextLength() != 0) {
                    DialerField.this.mInputAddress.setLabel("");
                } else {
                    this.mInDigitMode = true;
                }
                if (key == '\b' && this.getCursorPosition() == 0 && this.getTextLength() != 0) {
                    StringBuffer lnewKey = new StringBuffer(DialerField.this.mkeyWordField.getKeywordField().getText());
                    DialerField.this.mkeyWordField.setKeyword(lnewKey.delete(0, 1).toString());
                }
                if (this.getTextLength() == 0 || key == '\b' && this.getTextLength() == 1) {
                    this.setLabel("sip:");
                }
                return super.keyChar(key, status, time);
            }
        };
        this.mInputAddress.setLabel("sip:");
        this.mInputAddress.setFont(Font.getDefault().derive(2, 50));
        this.mOutcallFields.add((Field)this.mInputAddress);
        this.mOutcallFields.add((Field)new SeparatorField());
        this.mOutcallFields.add((Field)this.mkeyWordField.getKeywordField());
        this.mOutcallFields.add((Field)new SeparatorField());
        this.mOutcallFields.add((Field)this.mkeyWordField);
        this.mDisplayNameField = new RichTextField(0x80000000040000L);
        this.mDisplayNameField.setFont(Font.getDefault().derive(2, 50));
        this.mIncallFields.add((Field)this.mDisplayNameField);
        this.mIncallFields.add((Field)new SeparatorField());
        this.mPhoneNumberField = new TextField(0x80000000000000L);
        this.mDurationField = new TextField(0x80000000000000L);
        HorizontalFieldManager lNumAndDuration = new HorizontalFieldManager(0x1000000000000000L){
            {
                this.add((Field)DialerField.this.mPhoneNumberField);
                this.add((Field)DialerField.this.mDurationField);
            }

            protected void sublayout(int maxWidth, int maxHeight) {
                this.layoutChild((Field)DialerField.this.mPhoneNumberField, 2 * maxWidth / 3, maxHeight);
                this.layoutChild((Field)DialerField.this.mDurationField, maxWidth / 3, maxHeight);
                this.setPositionChild((Field)DialerField.this.mPhoneNumberField, 10, 0);
                this.setPositionChild((Field)DialerField.this.mDurationField, maxWidth - maxWidth / 3, 0);
                this.setExtent(maxWidth, DialerField.this.mPhoneNumberField.getHeight());
            }
        };
        this.mIncallFields.add((Field)lNumAndDuration);
        this.mMute = new CheckboxField(mRes.getString(5), false);
        this.mMute.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                DialerField.this.mCore.muteMic(((CheckboxField)field).getChecked());
            }
        });
        this.mSpeaker = new CheckboxField(mRes.getString(6), false);
        this.mSpeaker.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                DialerField.this.mCore.enableSpeaker(((CheckboxField)field).getChecked());
            }
        });
        HorizontalFieldManager lMuteAndSpeaker = new HorizontalFieldManager(0x1000000000000000L){
            {
                this.add((Field)DialerField.this.mMute);
                this.add((Field)DialerField.this.mSpeaker);
            }

            protected void sublayout(int maxWidth, int maxHeight) {
                this.layoutChild((Field)DialerField.this.mMute, 2 * maxWidth / 3, maxHeight);
                this.layoutChild((Field)DialerField.this.mSpeaker, maxWidth / 3, maxHeight);
                int lYPosition = Display.getHeight() - 80 - DialerField.this.mDisplayNameField.getContentHeight() - DialerField.this.mPhoneNumberField.getHeight() - 60;
                this.setPositionChild((Field)DialerField.this.mMute, 10, lYPosition);
                this.setPositionChild((Field)DialerField.this.mSpeaker, maxWidth - DialerField.this.mSpeaker.getWidth() - 10, lYPosition);
                this.setExtent(maxWidth, lYPosition + DialerField.this.mSpeaker.getHeight());
            }
        };
        this.mIncallFields.add((Field)lMuteAndSpeaker);
        this.enableOutOfCallFields();
    }

    protected boolean keyDown(int keycode, int time) {
        if (keycode == 0x110000 && (this.mkeyWordField.getSelectedElement() != null || this.mInputAddress.getText().length() > 0)) {
            try {
                if (this.mCore.isInComingInvitePending()) {
                    throw new LinphoneCoreException("Already in call");
                }
                if (this.mkeyWordField.getSelectedElement() != null && ((VerticalFieldManager)this.getFieldWithFocus()).getFieldWithFocus() == this.mkeyWordField) {
                    this.setAddressAndDisplay((Contact)this.mkeyWordField.getSelectedElement());
                }
                if (this.getAddress().length() > 0) {
                    LinphoneAddress lTo = this.mCore.interpretUrl(this.getAddress());
                    lTo.setDisplayName(this.getDisplayName());
                    this.mCore.invite(lTo);
                }
                return true;
            }
            catch (LinphoneCoreException e) {
                sLogger.error("call error", e);
                UiApplication.getUiApplication().invokeLater(new Runnable(){

                    public void run() {
                        Dialog.alert((String)e.getMessage());
                    }
                });
            }
        }
        return super.keyDown(keycode, time);
    }

    public boolean keyChar(char ch, int status, int time) {
        char lNumber = this.mPhoneTextFilter.convert(ch, 0);
        if (this.mCore.isIncall() && Character.digit(lNumber, 10) >= 0 && Character.digit(lNumber, 10) < 10) {
            this.mCore.sendDtmf(lNumber);
            return true;
        }
        return super.keyChar(ch, status, time);
    }

    private void setAddressAndDisplay(Contact aContact) {
        this.setAddress(aContact.getString(115, 0));
        String[] lContactNames = aContact.getStringArray(106, 0);
        StringBuffer lDisplayName = new StringBuffer();
        if (lContactNames[1] != null) {
            lDisplayName.append(lContactNames[1]);
        }
        if (lContactNames[0] != null) {
            if (lDisplayName.length() != 0) {
                lDisplayName.append(' ');
            }
            lDisplayName.append(lContactNames[0]);
        }
        if (lDisplayName.length() != 0) {
            this.setDisplayName(lDisplayName.toString());
        } else {
            this.setDisplayName(null);
        }
    }

    public void setAddress(String aValue) {
        if (aValue.length() > 0) {
            this.mInputAddress.setLabel(null);
        }
        this.mInputAddress.setText(aValue);
    }

    public String getAddress() {
        return this.mInputAddress.getText();
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public void setDisplayName(String aDisplayName) {
        this.mDisplayName = aDisplayName;
    }

    public void enableIncallFields() {
        if (this.mOutcallFields.getManager() == this) {
            this.delete((Field)this.mOutcallFields);
        }
        this.add((Field)this.mIncallFields);
        String lDisplay = null;
        String lNumber = "";
        if (this.mCore.getCurrentCall().getDirection() == CallDirection.Incoming) {
            LinphoneAddress lIncallAddress = this.mCore.getCurrentCall().getRemoteAddress();
            lDisplay = lIncallAddress.getDisplayName();
            lNumber = lIncallAddress.getUserName();
        } else {
            lDisplay = this.mDisplayName;
            lNumber = this.getAddress();
        }
        if (lDisplay != null) {
            this.mDisplayNameField.setText(lDisplay);
            this.mPhoneNumberField.setText(lNumber);
        } else {
            this.mDisplayNameField.setText(lNumber);
            this.mPhoneNumberField.setText("");
        }
        this.mSpeaker.setChecked(this.mCore.isSpeakerEnabled());
        this.mMute.setChecked(this.mCore.isMicMuted());
        this.mCallDurationTask = new TimerTask(){
            int mDuration = 0;
            {
                DialerField.this.mDurationField.setText("0s");
            }

            public void run() {
                ++this.mDuration;
                if (this.mDuration <= 60) {
                    DialerField.this.mDurationField.setText(String.valueOf(this.mDuration) + "s");
                } else {
                    DialerField.this.mDurationField.setText(String.valueOf(this.mDuration / 60) + ":" + (this.mDuration - this.mDuration / 60) + "s");
                }
            }
        };
        mTimer.scheduleAtFixedRate(this.mCallDurationTask, 0L, 1000L);
    }

    public void enableOutOfCallFields() {
        if (this.mIncallFields.getManager() == this) {
            this.mCallDurationTask.cancel();
            this.delete((Field)this.mIncallFields);
        }
        this.add((Field)this.mOutcallFields);
    }

    public void onSelected() {
    }

    public void onUnSelected() {
    }
}

