/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.core;

import net.rim.device.api.util.Persistable;
import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCallLog;
import org.linphone.core.LinphoneCoreFactory;

class LinphoneCallLogImpl
implements LinphoneCallLog,
Persistable {
    private boolean mCallDirectionIn;
    private String mFromString;
    private String mToString;
    private int mCallStatus = LinphoneCallLog.CallStatus.Aborted.toInt();

    LinphoneCallLogImpl(CallDirection aCallDirection, LinphoneAddress aFrom, LinphoneAddress aTo) {
        this(aCallDirection, aFrom != null ? aFrom.asString() : null, aTo != null ? aTo.asString() : null);
    }

    LinphoneCallLogImpl(CallDirection aCallDirection, String aFrom, String aTo) {
        this.mCallDirectionIn = aCallDirection == CallDirection.Incoming;
        this.mFromString = aFrom;
        this.mToString = aTo;
    }

    public CallDirection getDirection() {
        return this.mCallDirectionIn ? CallDirection.Incoming : CallDirection.Outgoing;
    }

    public LinphoneAddress getFrom() {
        return this.mFromString != null ? LinphoneCoreFactory.instance().createLinphoneAddress(this.mFromString) : null;
    }

    public LinphoneAddress getTo() {
        return this.mToString != null ? LinphoneCoreFactory.instance().createLinphoneAddress(this.mToString) : null;
    }

    void setCallStatus(LinphoneCallLog.CallStatus status) {
        this.mCallStatus = status.toInt();
    }

    public LinphoneCallLog.CallStatus getStatus() {
        return LinphoneCallLog.CallStatus.fromInt(this.mCallStatus);
    }
}

