<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_edit extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','post');
  return $this->$a($b);
  }

  /**
  * @return mixed
  * @since 1.0.0
  */
  protected function regular(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  $stage = XF::sanitize_var(XF::ifset('get','stage','form'),'enum','o=diff,o=form');
  $id = XF::sanitize_var(XF::ifset('get','post',0),'int');
  $diffrev1 = XF::sanitize_var(XF::ifset('get','rev1',0),'int');
  $diffrev2 = XF::sanitize_var(XF::ifset('get','rev2',0),'int');
  $this->gpc = array('stage'=>$stage,'id'=>$id,'rev1'=>$diffrev1,'rev2'=>$diffrev2);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('topic',array('id'=>$id)));
  unset($stage,$id,$diffrev1,$diffrev2);
    if ( $this->gpc['stage'] === 'diff' )
    return $this->show_diff();

  $sdat = XF::sql_query("SELECT p_id,p_topic_id,p_is_topic,p_u_id,p_time,p_pd_id,p_weight,p_pp_id,p_subject,p_acl,u_name FROM ".XF::tbl('post_meta')."
  LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
  WHERE p_id = :id",
  array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
  $postdata = $sdat->fetchObject();
    if ( !is_object($postdata) )
    XFUI::html_redirect(-1,XF::link('topic',array('post'=>$this->gpc['id'])));
  $postdata->u_name = XFUI::lang_str($postdata->u_name);
  $sdat->closeCursor();

    try {
    $pp = XFUI::get_post_prefix_list();
    $cache = XFCache::topic($postdata->p_topic_id);
      if ( !XFUI::topic_access($cache,$pp) )
      throw new XFE(XFUI::i18n('access_denied'),XFE::USER,'NO_ACCESS_TO_TOPIC');
    } catch ( XFE $E ){ $E->handle(); }

  $stag = XF::sql_query("SELECT td_t_id FROM ".XF::tbl('tag_data')." WHERE td_p_id = :id",
  array('id'=>array($postdata->p_id,'int')),__METHOD__,__LINE__);
  $tags = array();
    while ( $r = $stag->fetchObject() )
    $tags[] = intval($r->td_t_id);
  XFParser::tag_query($tags);
  $t = array();
    foreach ( $tags as $v )
      $t[] = XF::$tags[$v];
  $tags = implode(',',$t);
  $stag->closeCursor();

  $spst = XF::sql_query("SELECT pd_id,pd_time,pd_edit_reason,pd_text,u_name FROM ".XF::tbl('post_data')."
  LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_data').".pd_edit_u_id
  WHERE pd_p_id = :id ORDER BY pd_time DESC",array('id'=>array($postdata->p_id,'int')),__METHOD__,__LINE__);
  $history = array();
    while ( $r = $spst->fetchObject() ){
    $r->pd_id = intval($r->pd_id);
    $isc = false;
      if ( $r->pd_id === (int)$postdata->p_pd_id ){
      $current = (array)$r;
      $isc = true;
      }
    $history[$r->pd_id] = (array)$r;
    $history[$r->pd_id]['is_current'] = $isc;
    $history[$r->pd_id]['parsed_message'] = XFParser::message($r->pd_text);
    }
  $spst->closeCursor();
  $postdata->p_is_topic = (bool)$postdata->p_is_topic;
  $group = XF::get_group();
  $allow_acl = ( XF::access_control('mcp_overview') || $group['g_executive'] ) ? true : false;

  XF::tan('post_edit');
  XF::tan('post_edit_revert');
  XFUI::ajax_init();
  XFUI::html_head('{:edit_posting}');
  XF::$tpl->clear_cache('form_post_edit.tpl');
  XF::$tpl->assign('post_data',(array)$postdata);
  XF::$tpl->assign('message',$current['pd_text']);
  XF::$tpl->assign('tags',$tags);
  XF::$tpl->assign('history_post',$history);
  XF::$tpl->assign('post_maximum_weight_listing',XFUI::get_post_weight_list());
  XF::$tpl->assign('post_prefix_listing',XFUI::get_post_prefix_list(true));
  XF::$tpl->assign('allow_acl_setting',$allow_acl);
  XF::$tpl->assign('history_counter_start',(int)sizeof($history)+1);
  XF::$tpl->assign('smilie_listing',XFCache::get('simple','smilies'));
  XF::$tpl->display('form_post_edit.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $stage = XF::sanitize_var(XF::ifset($input,'stage',''),'enum','o=,o=preview,o=submit');
  $id = XF::sanitize_var(XF::ifset($input,'post',0),'int');
  $psw = XF::sanitize_var(XF::ifset($input,'f_weight',1),'int','range=1-5');
  $psp = XF::sanitize_var(XF::ifset($input,'f_prefix',0),'int');
  $psu = XF::sanitize_var(XF::ifset($input,'f_user',0),'int');
  $pss = XF::sanitize_var(XF::ifset($input,'f_subject',''),'str','length=8-128');
  $psm = XF::sanitize_var(XF::ifset($input,'f_message',''),'strwbr','length=40-'.XF::POST_MAXLEN);
  $pst = XF::sanitize_var(XF::ifset($input,'f_tags',''),'str','okifempty');
  $psa = XF::sanitize_var(XF::ifset($input,'f_acl',''),'str','okifempty,length=0-255');
  $psr = XF::sanitize_var(XF::ifset($input,'f_reason',''),'str','length=4-128');
  $this->gpc = array('stage'=>$stage,'id'=>$id,'f_weight'=>$psw,'f_prefix'=>$psp,'f_user'=>$psu,'f_subject'=>$pss,
  'f_message'=>$psm,'f_tags'=>$pst,'f_acl'=>$psa,'f_reason'=>$psr);
  $this->markgpc = array('f_user','f_subject','f_message','f_tags','f_acl','f_reason');
  return true;
  }

  /**
  * preview message text
  * @return string
  * @since 1.0.0
  */
  public function preview(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  return XFParser::message($this->gpc['f_message']);
  }

  /**
  * show differences between two posting 'revisions'
  * @return true
  * @since 1.0.0
  */
  protected function show_diff(){
  $pp = XFUI::get_post_prefix_list();

    try {
    $ssrc = XF::sql_query("SELECT pd_id,pd_text,pd_time,p_topic_id,p_subject,u_name FROM ".XF::tbl('post_data')."
    LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ".XF::tbl('post_data').".pd_p_id
    LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
    WHERE pd_id = :id",array('id'=>array($this->gpc['rev1'],'int')),__METHOD__,__LINE__);
      if ( $ssrc->rowCount() !== 1 )
      throw new XFE('illegal source posting');
    $post_src = $ssrc->fetchObject();
    $post_src->u_name = XFUI::lang_str($post_src->u_name);
    $ssrc->closeCursor();

    $stgt = XF::sql_query("SELECT pd_id,pd_text,pd_time,p_topic_id,p_subject,u_name FROM ".XF::tbl('post_data')."
    LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ".XF::tbl('post_data').".pd_p_id
    LEFT JOIN ".XF::tbl('user')." ON ".XF::tbl('user').".u_id = ".XF::tbl('post_meta').".p_u_id
    WHERE pd_id = :id",array('id'=>array($this->gpc['rev2'],'int')),__METHOD__,__LINE__);
      if ( $ssrc->rowCount() !== 1 )
      throw new XFE('illegal target posting');
    $post_tgt = $stgt->fetchObject();
    $post_tgt->u_name = XFUI::lang_str($post_tgt->u_name);
    $stgt->closeCursor();

    $c1 = XFCache::topic($post_src->p_topic_id);
    $c2 = ( (int)$post_src->p_topic_id !== (int)$post_tgt->p_topic_id ) ? XFCache::topic($post_tgt->p_topic_id) : $c1;
      if ( !XFUI::topic_access($c1,$pp) || !XFUI::topic_access($c2,$pp) )
      throw new XFE('no access permission to at least one of the postings');
    unset($a,$b);

    // render inline diff using 'Text_Diff' from PEAR...
      if ( !file_exists(XF::vault_query('root_path').'/ext/Text_Diff/Diff.php') )
      throw new XFE('diff engine not found');
    require_once(XF::vault_query('root_path').'/ext/Text_Diff/Diff.php');
    require_once(XF::vault_query('root_path').'/ext/Text_Diff/Diff/Renderer.php');
    require_once(XF::vault_query('root_path').'/ext/Text_Diff/Diff/Renderer/inline.php');
    $s = explode(chr(10),$post_src->pd_text);
    $t = explode(chr(10),$post_tgt->pd_text);
    $diff = new Text_Diff('auto',array($s,$t));
    $renderer = new Text_Diff_Renderer_inline();
    $diff = $renderer->render($diff);
    } catch ( XFE $E ){ $E->handle(); }

  XFUI::html_head('{:edit_posting}');
  XF::$tpl->clear_cache('post_edit_compare.tpl');
  XF::$tpl->assign('post_id',$this->gpc['id']);
  XF::$tpl->assign('post_data_src',(array)$post_src);
  XF::$tpl->assign('post_data_tgt',(array)$post_tgt);
  XF::$tpl->assign('post_comparison',$diff);
  XF::$tpl->display('post_edit_compare.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * edit a posting
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $sf = '';
    $force_invisible = false;
    $group = XF::get_group();
    $pp = XFUI::get_post_prefix_list();
    $susr = XF::sql_query("SELECT COUNT(u_id) AS user_count FROM ".XF::tbl('user')." WHERE u_id = :userid",
    array('userid'=>array($this->gpc['f_user'],'int')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( !is_object($userdata) || (int)$userdata->user_count === 0 ){
      $this->error = '{:invalid_username_on_edit}';
      return false;
      }
    // TODO: [idle] execute() i think sha(pd_text) would be useful but sadly postgres supports it since 8.3?
    $spst = XF::sql_query("SELECT p_topic_id,p_is_topic,p_u_id,p_approved,pd_id,pd_time,pd_text FROM ".XF::tbl('post_meta')."
    LEFT JOIN ".XF::tbl('post_data')." ON ".XF::tbl('post_data').".pd_p_id = ".XF::tbl('post_meta').".p_id
    WHERE p_id = :id AND pd_p_id = :id AND pd_is_last = true",array(
    'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $postdata = $spst->fetchObject();
    $spst->closeCursor();

      if ( !is_object($postdata) ){
      $this->error = '{:no_valid_id}';
      return false;
      }
    $a = XFCache::topic($postdata->p_topic_id);
      if ( !XFUI::topic_access($a,$pp) ){
      $this->error = '{:access_denied}';
      return false;
      }
      if ( (bool)$postdata->p_is_topic === false ){ // some options cannot be applied to a reply...
      $this->gpc['f_weight'] = 0;
      $this->gpc['f_prefix'] = 0;
      $this->gpc['f_acl'] = '';
      }
    $pp = XFUI::get_post_prefix_list(true);
      if ( !$group['g_executive'] && !XF::access_control('mcp_overview') ){
      $this->gpc['f_message'] = preg_replace('/\[notice\].+?\[\/notice\]/siu','',$this->gpc['f_message']);
      $this->gpc['f_acl'] = '';
        if ( (int)$postdata->p_u_id !== XF::vault_query('current_user_id') && empty($this->error) )
        $this->error = '{:must_not_alter_foreign_entry}';
        if ( (int)$postdata->p_u_id === XF::vault_query('current_user_id') && $postdata->pd_time+XF::get_cfg('main_post_edit_limit') < XF::vault_query('uts') && empty($this->error) )
        $this->error = '{:time_limit_exceeded_for_edit}';
      }
      if ( $this->gpc['f_prefix'] !== 0 && !isset($pp[$this->gpc['f_prefix']]) && empty($this->error) )
      $this->error = '{:you_cannot_select_this_prefix}';
      if ( XF::get_cfg('filter_enable') && $group['g_post_filter'] && XF::get_cfg('filter_spam_action') !== 'accept' ){
      $sf = XF::spam_filter('','',$this->gpc['f_message']);
        if ( is_bool($sf->result_cache) ){
          if ( $sf->result_cache ){
            if ( XF::get_cfg('filter_spam_action') === 'mark' )
            $force_invisible = true;
            elseif ( XF::get_cfg('filter_spam_action') === 'reject' )
            $this->error = '{:your_posting_has_been_filtered_as_spam}';
          }
        $sf->save();
        }
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_data'=>'w','post_meta'=>'w','tag_meta'=>'w','tag_data'=>'w')) )
        throw new XFE('unable to begin database transaction');
      require_once(XF::vault_query('root_path').'/class.parser.php');
      $sm = XF::spam_result_to_marker($sf);
        // only submit separate new post, if the message differs...
        if ( !XFParser::normalized_string_compare($this->gpc['f_message'],$postdata->pd_text) ){
        XF::sql_query("INSERT INTO ".XF::tbl('post_data')." (pd_p_id,pd_time,pd_spam_marker,pd_edit_u_id,pd_edit_reason,pd_text) VALUES (:postid,:date,:spam,:userid,:reason,:message)",
        array('postid'=>array($this->gpc['id'],'int'),
        'date'=>array(XF::vault_query('uts'),'int'),
        'spam'=>array($sm,'int'),
        'userid'=>array(XF::vault_query('current_user_id'),'int'),
        'reason'=>array($this->gpc['f_reason'],'str'),
        'message'=>array($this->gpc['f_message'],'str')),__METHOD__,__LINE__);
        $newmsgid = XF::sql_lastId('post_data.pd_id');
          if ( !$newmsgid )
          throw new XFE('new post (data) could not be inserted');
        XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_is_last = false WHERE pd_p_id = :postid AND pd_id != :newmsg",
        array('postid'=>array($this->gpc['id'],'int'),
        'newmsg'=>array($newmsgid,'int')),__METHOD__,__LINE__);
        }
        else{
        XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_edit_u_id = :userid, pd_edit_reason = :reason, pd_text = :message WHERE pd_id = :postid",
        array('postid'=>array($postdata->pd_id,'int'),
        'userid'=>array(XF::vault_query('current_user_id'),'int'),
        'reason'=>array($this->gpc['f_reason'],'str'),
        'message'=>array($this->gpc['f_message'],'str')),__METHOD__,__LINE__);
        $newmsgid = $postdata->pd_id;
        }
      XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_pd_id = :newmsg, p_u_id = :userid, p_weight = :weight, p_pp_id = :prefixid, p_subject = :subject, p_acl = :acl WHERE p_id = :postid",
      array('postid'=>array($this->gpc['id'],'int'),
      'newmsg'=>array($newmsgid,'int'),
      'userid'=>array($this->gpc['f_user'],'int'),
      'weight'=>array($this->gpc['f_weight'],'int'),
      'prefixid'=>array($this->gpc['f_prefix'],'int'),
      'subject'=>array($this->gpc['f_subject'],'str'),
      'acl'=>array($this->gpc['f_acl'],'str')),__METHOD__,__LINE__);
        if ( $force_invisible )
        XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_visible = false WHERE p_id = :postid",array('postid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        if ( !XFParser::tag_management($this->gpc['id'],$this->gpc['f_tags']) )
        throw new XFE('tags of post could not be set');
      XF::logger('info','postid',$this->gpc['id'],'new_msgid',$newmsgid);
      XF::sql_transaction('commit');
      XF::tpl_use_cache_pool($this->gpc['id'],'begin');
        if ( XF::$tpl->is_cached('post.tpl',$this->gpc['id']) )
        XF::$tpl->clear_cache('post.tpl',$this->gpc['id']);
      XF::tpl_use_cache_pool(0,'reset');
        if ( (bool)$postdata->p_approved && (bool)$postdata->p_is_topic && XF::get_cfg('rss_payload') )
        XFCache::purge('rss',XF::RSS_LAST);
        if ( (bool)$postdata->p_is_topic ){
        $cache = XFCache::topic($this->gpc['id']);
        XFCache::topic_delta($cache,'change_attribute',array('prefix'=>$this->gpc['f_prefix'],'acl'=>$this->gpc['f_acl'],'subject'=>$this->gpc['f_subject']));
        XFCache::put('topic',$this->gpc['id'],$cache);
        XFCache::purge('rss',$this->gpc['id']);
          if ( $this->gpc['f_prefix'] !== 0 ){
            if ( XF::$tpl->is_cached('mcp_request.tpl') )
            XF::$tpl->clear_cache('mcp_request.tpl');
            if ( XF::$tpl->is_cached('acp_overview_request.tpl') )
            XF::$tpl->clear_cache('acp_overview_request.tpl');
          }
        }
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_edit($input){
  $a = new XFAction_post_edit();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
    if ( $b['stage'] === 'preview' ){
    XFUI::$ajax_response->script('xf_visibility(\'f_post_preview\',\'block\',\'nofade\');');
    XFUI::$ajax_response->assign('f_post_preview','innerHTML',$a->preview());
    }
    elseif ( $b['stage'] === 'submit' ){
    $a->execute();
      if ( $a->get_success() )
      return xfaf_success(XF::link('topic',array('post'=>$b['id']),false),'{:posting_has_been_edited}');
      else
      return xfaf_failure($a->get_error());
    }
  }

?>